set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808376';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '4312044',
      2,
      1.753270,
      1,
      0,
      '2122',
      3,
      0,
      NULL,
      NULL,
      ' 4-11-1996',
      27,
      NULL,
      NULL,
      1.258105,
      1,
      NULL,
      NULL,
      2,
      NULL,
      49.586984,
      2,
      NULL,
      ' 9- 2-1984',
      ' 8-26-1990',
      NULL,
      2,
      3,
      1.153482,
      NULL,
      2,
      3,
      0,
      1.437126,
      12.432301,
      NULL,
      12.041706,
      5,
      25.893586,
      NULL,
      5,
      24,
      4,
      NULL,
      7,
      1.669700,
      1,
      0,
      1.134962,
      1,
      1.428192,
      0,
      0.534571,
      0.650069,
      0,
      11,
      5,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.772766,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.709028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      5,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      2,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0.357012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234335,
      0.226254,
      NULL,
      NULL,
      0,
      1.678533,
      NULL,
      NULL,
      NULL,
      1.534465,
      0.210339,
      1.341254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.689039,
      NULL,
      1,
      2.095854,
      1,
      0.630727,
      3,
      283.476076,
      1,
      1.107397,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032416,
      3,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      3,
      2,
      0,
      0,
      1,
      3,
      2.495692,
      0,
      1.624115,
      0.243304,
      NULL,
      1,
      0.308262,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.662814,
      2.777885,
      1.226871,
      2,
      5,
      NULL,
      10.162385,
      1.199563,
      NULL,
      2.670200,
      0,
      3.208292,
      0.272580,
      2,
      0.288946,
      45,
      2,
      NULL,
      NULL,
      23,
      NULL,
      84,
      2,
      0.404558,
      1.011277,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      0.792322,
      6,
      15,
      4.988812,
      3.687058,
      9.192174,
      5.152747,
      NULL,
      4,
      3.545657,
      2.899952,
      NULL,
      3.840141,
      0.252735,
      NULL,
      1,
      NULL,
      NULL,
      3.397940,
      2.557403,
      1.902830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.502160,
      1.276627,
      1,
      NULL,
      1.947674,
      NULL,
      NULL,
      1.436126,
      1,
      3.381144,
      NULL,
      3.033813,
      1,
      1.689902,
      3.867831,
      NULL,
      0,
      3.616023,
      8.871520,
      1,
      1,
      0.842392,
      1.768435,
      3,
      0.547369,
      0.377125,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.672091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725753,
      NULL,
      NULL,
      0.067197,
      NULL,
      NULL,
      0,
      0,
      0.702109,
      2.068326,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.846048,
      NULL,
      NULL,
      NULL,
      1,
      2.375089,
      0,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0.372012,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.821053,
      8,
      9.175536,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      4.303189,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      2.864849,
      1.763158,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.493856,
      5.465224,
      1.733336,
      0.540507,
      2.219620,
      0.029695,
      7.898208,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.744929,
      3.441597,
      3,
      1.634567,
      NULL,
      6.674722,
      0.160693,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.038352,
      NULL,
      NULL,
      2.049696,
      2.967615,
      1.393321,
      1.952953,
      NULL,
      5,
      NULL,
      NULL,
      0.121387,
      2,
      2,
      1,
      1,
      NULL,
      2,
      0.602596,
      NULL,
      0.073075,
      NULL,
      0,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.720720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.874736,
      NULL,
      NULL,
      3.962956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.082778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.731813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.207047,
      0.854767,
      0.384492,
      NULL,
      0.769618,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.815271,
      NULL,
      NULL,
      1.344476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.972748,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.899034,
      1.645238,
      NULL,
      NULL,
      0.791823,
      1,
      NULL,
      NULL,
      0,
      1.033992,
      NULL,
      NULL,
      1.669535,
      0,
      NULL,
      NULL,
      1,
      1.417938,
      NULL,
      NULL,
      3.372736,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070915,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      0.522414,
      NULL,
      NULL,
      NULL,
      3,
      0.624711,
      2.983889,
      0.872193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.442058,
      NULL,
      NULL,
      3.352135,
      2.167347,
      3,
      1.193921,
      NULL,
      NULL,
      0,
      NULL,
      0.849546,
      NULL,
      1.651102,
      1.381509,
      0.140101,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      1.094696,
      NULL,
      0.616884,
      0.149432,
      3,
      NULL,
      1,
      NULL,
      0.084152,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.224170,
      NULL,
      NULL,
      NULL,
      0,
      26.573617,
      24,
      1.008570,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.727911,
      NULL,
      0.374093,
      NULL,
      1.605640,
      NULL,
      0.465827,
      NULL,
      0.077027,
      NULL,
      0,
      NULL,
      0.415906,
      NULL,
      1.092849,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.890195,
      NULL,
      NULL,
      1.316499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832454,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051824,
      1.853483,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      5.704271,
      0,
      2.477872,
      2,
      0,
      2,
      NULL,
      3,
      1.383753,
      1.369387,
      0,
      1,
      1.002082,
      0,
      1.999654,
      2.303915,
      0,
      0.042231,
      2.916851,
      0.939144,
      2,
      1,
      1.229399,
      NULL,
      2.596869,
      0,
      1.908060,
      0.136190,
      1,
      0.060104,
      1.495608,
      1,
      1.342177,
      1,
      1,
      0.775376,
      3.130344,
      3,
      1,
      1.456330,
      0.450425,
      0,
      NULL,
      NULL,
      0,
      3.703086,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.636411,
      NULL,
      0.928265,
      NULL,
      1,
      NULL,
      0.366000,
      NULL,
      0.586733,
      NULL,
      0.313315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.611836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.833930,
      NULL,
      0,
      0,
      6,
      0,
      NULL,
      NULL,
      67,
      NULL,
      NULL,
      0,
      6.888694,
      '44020',
      '40434',
      '40433',
      1,
      '',
      '',
      '',
      0.987323,
      '',
      '',
      NULL);
commit;
end;
/


