set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1431244',
      2.260076,
      0,
      6,
      NULL,
      '3042',
      NULL,
      0.597213,
      NULL,
      NULL,
      ' 2-27-1988',
      32,
      NULL,
      NULL,
      3.634830,
      1,
      ' 6-24-1999',
      25,
      3.336289,
      116,
      NULL,
      3,
      ' 8-29-2002',
      NULL,
      ' 6-22-2000',
      3.322928,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.043313,
      0.775870,
      10,
      2,
      0,
      3.055251,
      2,
      14.248849,
      NULL,
      16.435125,
      0,
      3,
      NULL,
      1.484698,
      1,
      1,
      NULL,
      0.153012,
      0.487053,
      NULL,
      0,
      1.601640,
      1,
      NULL,
      1,
      1,
      6,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      4,
      NULL,
      0,
      1,
      1,
      0,
      5,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.418000,
      NULL,
      NULL,
      2,
      NULL,
      0.021097,
      3,
      1.241613,
      1.721524,
      3,
      1.677657,
      3.622682,
      0,
      3.595228,
      0.450591,
      1,
      1,
      3,
      1,
      1.165406,
      0.641736,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1.566438,
      1,
      NULL,
      NULL,
      1.518174,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0.629586,
      1,
      0,
      1,
      1,
      0.643556,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      4,
      1,
      1,
      ' 6- 9-1998',
      71,
      ' 8-25-2001',
      NULL,
      3.951966,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      12,
      NULL,
      3,
      1.844019,
      5,
      0,
      0,
      0,
      1,
      9,
      2,
      0.048328,
      0.226514,
      NULL,
      NULL,
      NULL,
      1,
      1.669286,
      4.309010,
      3.706754,
      1.378303,
      NULL,
      2.708879,
      NULL,
      NULL,
      NULL,
      0.843749,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.215295,
      NULL,
      0.856220,
      0,
      1,
      0,
      0,
      NULL,
      66,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      0,
      0,
      3,
      2,
      2,
      0,
      2,
      1,
      1,
      2,
      2,
      NULL,
      1,
      0,
      1.538850,
      1.142235,
      NULL,
      NULL,
      0,
      1.615779,
      NULL,
      23.837220,
      179,
      2,
      1.902637,
      1,
      0.514413,
      1.103764,
      1.847074,
      7.184156,
      5,
      4.826689,
      2,
      4.539703,
      0.996663,
      7,
      2.807165,
      0,
      0.497023,
      28.130423,
      0,
      0,
      NULL,
      35,
      35,
      4.199711,
      5,
      1.330433,
      0.395762,
      '23423',
      '',
      '',
      1,
      '',
      '',
      '',
      0.807318,
      '',
      '',
      '',
      1.464021,
      5.699360,
      12.353907,
      30.872122,
      3,
      8.920753,
      6,
      1,
      5,
      0.636797,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.896712,
      1,
      0,
      NULL,
      1.588784,
      2.274546,
      3.691441,
      0,
      1,
      NULL,
      NULL,
      3.006260,
      0.154039,
      2,
      0.105251,
      NULL,
      NULL,
      0.768646,
      NULL,
      NULL,
      1.120197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.098019,
      NULL,
      NULL,
      3.606206,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.176971,
      2,
      NULL,
      1.517373,
      1.274852,
      0.504905,
      NULL,
      3.793503,
      1.628660,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.324179,
      1.201861,
      2,
      1.443743,
      7.022975,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.583343,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.992261,
      1.007556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.797867,
      1,
      0,
      NULL,
      NULL,
      1.724336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020263,
      NULL,
      NULL,
      0.381805,
      NULL,
      NULL,
      0,
      3,
      0,
      1.667682,
      NULL,
      NULL,
      3,
      NULL,
      2.901731,
      2,
      1.498738,
      5,
      NULL,
      NULL,
      NULL,
      1.822268,
      NULL,
      NULL,
      1,
      1.554095,
      NULL,
      3.270051,
      2.643209,
      0.145537,
      5.752136,
      2.953814,
      8.312487,
      NULL,
      1.741342,
      2.346755,
      3.797202,
      1,
      NULL,
      0.891429,
      0,
      3.125137,
      2.610796,
      2,
      3,
      1.067164,
      NULL,
      0,
      1,
      4,
      5,
      2,
      0,
      3,
      NULL,
      0.693489,
      1.473369,
      0.334738,
      1.715167,
      2.600435,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.436401,
      NULL,
      NULL,
      1.766715,
      NULL,
      NULL,
      2.533358,
      NULL,
      NULL,
      1.768534,
      NULL,
      NULL,
      1.535660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592998,
      1,
      1.443898,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.966709,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.221608,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.282052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.325198,
      NULL,
      NULL,
      NULL,
      1.525236,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936951,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.001631,
      NULL,
      NULL,
      NULL,
      3.432024,
      NULL,
      NULL,
      NULL,
      1.840531,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.727065,
      NULL,
      NULL,
      NULL,
      4.700381,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      2,
      29.637352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.559300,
      NULL,
      1,
      NULL,
      NULL,
      1.991717,
      NULL,
      0,
      70.587959,
      NULL,
      0.272130,
      0,
      0,
      1.958220,
      0.952307,
      0.907581,
      NULL,
      NULL,
      1.868765,
      0,
      0,
      0.899990,
      NULL,
      NULL,
      NULL,
      1.999905,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.386563,
      1.658459,
      0.039875,
      NULL,
      0.165309,
      2.598219,
      2,
      1,
      NULL,
      1,
      NULL,
      1.801344,
      NULL,
      NULL,
      NULL,
      0.117084,
      NULL,
      0,
      1,
      NULL,
      2.898052,
      0.067274,
      NULL,
      NULL,
      1,
      NULL,
      1.574733,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.163703,
      NULL,
      NULL,
      1,
      NULL,
      0.426052,
      1.562221,
      NULL,
      0.295616,
      0.850751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84.382178,
      3,
      0,
      2.542008,
      '34233',
      '',
      '',
      1.007481,
      '',
      '',
      '',
      1.910166,
      '',
      '',
      NULL);
commit;
end;
/


