set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '0004131',
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.008676,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      3,
      3.301332,
      0,
      '10- 9-1989',
      22.207183,
      NULL,
      211.072080,
      88.075835,
      2,
      '10-27-2000',
      NULL,
      ' 4-10-1982',
      2.759391,
      1,
      NULL,
      0,
      0,
      2.705531,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.838634,
      15,
      4,
      16,
      4,
      3,
      5,
      0,
      1,
      1,
      1.635667,
      0.393350,
      0,
      1,
      0.097876,
      1.885739,
      1.530607,
      0,
      2,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      1,
      3,
      0,
      5,
      0,
      3,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.750271,
      3.361753,
      1,
      0.345737,
      NULL,
      1.499190,
      NULL,
      3,
      3,
      0.336191,
      1.286165,
      1,
      0,
      1.829092,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.677224,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.911194,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      2,
      1,
      2,
      2,
      3,
      4,
      NULL,
      3,
      0,
      3,
      2,
      5,
      5,
      5,
      3,
      5,
      3,
      0,
      NULL,
      0.249212,
      ' 2-11-1998',
      290,
      '10-23-1979',
      168.936058,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.610185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.343383,
      0.398875,
      NULL,
      2,
      1,
      1.095460,
      0,
      0,
      4.782397,
      2,
      0,
      1,
      2.650307,
      0,
      0,
      0,
      NULL,
      1,
      9.186041,
      0,
      4,
      3.497554,
      1.682242,
      2.974046,
      1,
      0.656343,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472930,
      1.190964,
      NULL,
      0,
      0.310523,
      1,
      3.279886,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      3.883042,
      2,
      1,
      0,
      NULL,
      0.306714,
      0,
      1.194187,
      NULL,
      1,
      0,
      0,
      0.461784,
      1,
      NULL,
      NULL,
      NULL,
      8,
      3.086949,
      4,
      0.867666,
      6.415080,
      1,
      2,
      0.265145,
      5,
      1.082171,
      2.003507,
      1,
      45.616950,
      0,
      NULL,
      NULL,
      2,
      11,
      43.967054,
      1,
      NULL,
      0,
      '30210',
      '20041',
      '',
      1,
      '',
      '',
      '',
      1.096414,
      '',
      '',
      NULL,
      1.766476,
      NULL,
      54.887722,
      36.628967,
      NULL,
      36.829341,
      1,
      0,
      4,
      2,
      2.453656,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.322470,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.125485,
      NULL,
      NULL,
      3,
      NULL,
      2.422664,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.224858,
      NULL,
      NULL,
      0.405663,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.515169,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519182,
      NULL,
      NULL,
      NULL,
      2,
      1.654467,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.412792,
      1.997935,
      NULL,
      0,
      NULL,
      2,
      3,
      1.925486,
      1,
      0.995867,
      1.635070,
      0.633853,
      0,
      0.268547,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.332014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.455541,
      NULL,
      0.982953,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643881,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.116883,
      NULL,
      NULL,
      2.197339,
      NULL,
      1,
      1.140856,
      NULL,
      NULL,
      1.950720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444318,
      NULL,
      NULL,
      0.140171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.039781,
      NULL,
      NULL,
      3.046002,
      NULL,
      3.056742,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.236617,
      NULL,
      3.255757,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.651290,
      0,
      1.279995,
      NULL,
      2,
      0.878246,
      1,
      0,
      7.128800,
      1,
      1,
      1.291534,
      2,
      0.654133,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      0.007272,
      4.157031,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.987029,
      1,
      0,
      1.032204,
      NULL,
      3,
      NULL,
      NULL,
      2.807155,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612747,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135457,
      1.677818,
      1,
      1.467282,
      0.303903,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.588141,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.705479,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.322172,
      NULL,
      NULL,
      NULL,
      1.949640,
      NULL,
      NULL,
      NULL,
      3.427614,
      NULL,
      NULL,
      NULL,
      2.601629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208448,
      NULL,
      NULL,
      NULL,
      0.242894,
      NULL,
      NULL,
      NULL,
      0.554291,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.855150,
      NULL,
      NULL,
      NULL,
      2.604663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.585974,
      NULL,
      NULL,
      NULL,
      1.431507,
      1.602914,
      3,
      2,
      NULL,
      2,
      1,
      1.143166,
      NULL,
      1.064269,
      1.976818,
      NULL,
      NULL,
      0,
      11.588677,
      NULL,
      1.850056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880582,
      NULL,
      0,
      NULL,
      9,
      NULL,
      0.939715,
      1.003394,
      1,
      0,
      1,
      0.659199,
      3,
      1,
      1,
      0.995705,
      1,
      1.096992,
      0.090308,
      1.407844,
      0,
      1.820321,
      2.696648,
      1.764024,
      NULL,
      0,
      0.014783,
      1,
      0.404724,
      0,
      3,
      2.871541,
      NULL,
      3,
      1,
      0.273786,
      1,
      40.793615,
      NULL,
      1.389145,
      0,
      NULL,
      0,
      0,
      0,
      1.253247,
      1.675967,
      0,
      0.837859,
      1,
      0,
      0.698113,
      NULL,
      0,
      1.072996,
      0,
      1,
      1.283179,
      0.846446,
      0.808196,
      1,
      0.960510,
      1,
      1.748797,
      NULL,
      NULL,
      1.306039,
      1.278320,
      0.629125,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4,
      0.275075,
      3.969437,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      0.780446,
      NULL,
      1.645175,
      0,
      NULL,
      1.342729,
      0.480423,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.335037,
      NULL,
      3.893273,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.639761,
      NULL,
      0.676642,
      3.650746,
      NULL,
      1.364645,
      NULL,
      NULL,
      2.617286,
      0.488362,
      0.467175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297231,
      NULL,
      0.704045,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.530249,
      NULL,
      NULL,
      81,
      3,
      NULL,
      1.349030,
      '33123',
      '14242',
      '',
      1.666198,
      NULL,
      '',
      '',
      1.268062,
      '',
      '',
      NULL);
commit;
end;
/


