set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.561652,
      0,
      1.774593,
      NULL,
      1,
      1,
      2.797281,
      NULL,
      NULL,
      '04032331',
      38,
      21.476928,
      '2303441',
      2,
      0.166854,
      1,
      3,
      NULL,
      0.920286,
      1.432852,
      NULL,
      NULL,
      ' 7- 6-1996',
      152.628790,
      NULL,
      NULL,
      1,
      NULL,
      '10-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1991',
      0,
      1,
      0.168504,
      NULL,
      1,
      3.845824,
      6,
      1.766436,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.001162,
      1,
      0,
      1,
      0,
      1.980695,
      NULL,
      5,
      0,
      2,
      2,
      5,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      4,
      4,
      NULL,
      5.268966,
      0,
      1,
      NULL,
      1,
      0.796059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1.005407,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1.989881,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      4,
      2,
      2,
      2,
      5,
      2,
      0,
      3,
      NULL,
      1,
      2,
      1,
      2,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1976',
      203,
      '10- 2-1990',
      33.046699,
      3.942450,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.910885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.509475,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      4,
      1.192222,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.551128,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763597,
      2.888145,
      0,
      0,
      NULL,
      0.839288,
      0.547440,
      2,
      6,
      NULL,
      1.366636,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.045654,
      NULL,
      NULL,
      1,
      2,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      3,
      5,
      1.687689,
      3,
      NULL,
      1,
      1.724684,
      1,
      0,
      1,
      NULL,
      1.368046,
      NULL,
      1.532552,
      1.342736,
      0,
      2.803713,
      NULL,
      0,
      9.733714,
      1.582503,
      5.835209,
      1,
      7,
      4,
      NULL,
      1.305468,
      7,
      1,
      1,
      0.348788,
      NULL,
      0,
      1,
      NULL,
      NULL,
      69,
      NULL,
      2,
      3.940113,
      3.596368,
      '20431',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.522577,
      22.170689,
      18,
      15.388253,
      1.543309,
      37,
      1,
      12,
      2,
      1,
      3.432457,
      1.990437,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.994024,
      1,
      0.579947,
      0,
      1.953157,
      3,
      0,
      1.931674,
      3.933881,
      0.635554,
      1.505288,
      0,
      0,
      1.959812,
      NULL,
      NULL,
      0.666401,
      2,
      1.663840,
      0.767873,
      11.143029,
      5.907202,
      0.607061,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.030111,
      1,
      1.352055,
      NULL,
      1.882025,
      NULL,
      NULL,
      0.913785,
      2,
      0.944738,
      1.591564,
      NULL,
      2.790579,
      3,
      0.276022,
      NULL,
      NULL,
      1,
      3.879664,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.429769,
      NULL,
      1.172212,
      NULL,
      0.641567,
      0.579751,
      1.093541,
      1.904440,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.526957,
      1.159022,
      1.047905,
      NULL,
      NULL,
      6,
      1,
      NULL,
      0.597582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310208,
      NULL,
      NULL,
      0.894059,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357700,
      NULL,
      NULL,
      0.010201,
      NULL,
      NULL,
      0.972518,
      NULL,
      NULL,
      4.626355,
      1,
      1,
      1,
      1,
      0,
      1.118367,
      1.531776,
      1,
      2.512388,
      3,
      1,
      0,
      3.104689,
      0,
      1,
      1.269045,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      0.735280,
      1,
      2,
      NULL,
      0,
      1.987900,
      2.007097,
      6,
      NULL,
      3.996599,
      0.584895,
      0.721841,
      1.832410,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0.244993,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.316139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.555375,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.295111,
      NULL,
      NULL,
      1.026488,
      NULL,
      NULL,
      0,
      1,
      1.739387,
      1.519745,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.621646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.302331,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.248194,
      NULL,
      NULL,
      NULL,
      3.531458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384886,
      NULL,
      NULL,
      NULL,
      1.783210,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11.965643,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.388438,
      NULL,
      0.163319,
      NULL,
      3,
      2.830913,
      0.656797,
      NULL,
      NULL,
      NULL,
      9.357049,
      2.045263,
      1.372741,
      NULL,
      NULL,
      0.253184,
      NULL,
      NULL,
      1.659456,
      NULL,
      0,
      NULL,
      1.733019,
      0.335977,
      0,
      0,
      1,
      1.497782,
      0.071377,
      1,
      NULL,
      NULL,
      0.528774,
      0,
      1.637715,
      0.344597,
      1.547378,
      1,
      0.811091,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.744586,
      1.110385,
      NULL,
      NULL,
      NULL,
      0.284004,
      1,
      3,
      1.789784,
      1,
      0,
      NULL,
      1.703214,
      NULL,
      NULL,
      1.596730,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3.540233,
      NULL,
      1,
      3.037156,
      NULL,
      1.147699,
      NULL,
      NULL,
      1,
      2.963303,
      NULL,
      NULL,
      NULL,
      NULL,
      3.864865,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711725,
      NULL,
      0.501889,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.242688,
      NULL,
      NULL,
      32,
      135.465977,
      2,
      2,
      NULL,
      '12412',
      '',
      '',
      0.203761,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


