set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7.935660,
      3.777007,
      1,
      1,
      1.933655,
      0.346153,
      NULL,
      2.702447,
      '214',
      '0',
      70.364420,
      57.247153,
      '0221040',
      NULL,
      1.553428,
      NULL,
      3,
      '4440',
      1.452003,
      0,
      NULL,
      NULL,
      NULL,
      131,
      2,
      NULL,
      3.647144,
      NULL,
      ' 8-24-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 1-21-1997',
      2,
      1,
      NULL,
      0,
      1.066398,
      0.913315,
      5,
      0.593082,
      1,
      0.088475,
      5,
      18.457553,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3.455058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      2,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      1,
      0,
      0.363677,
      NULL,
      NULL,
      0.543592,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.597726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      5,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.875473,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      4,
      0,
      1,
      1,
      0,
      4,
      1,
      1,
      NULL,
      2,
      2,
      NULL,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.503027,
      5,
      3.633607,
      NULL,
      0.001061,
      1.499327,
      0.343885,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.843340,
      4,
      NULL,
      0,
      0.096357,
      1.909098,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.727761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.264704,
      1,
      2.896271,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.715355,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      2,
      0,
      2,
      4.812488,
      5.459310,
      NULL,
      0,
      1,
      1.802742,
      NULL,
      0,
      1,
      1.169179,
      1.855191,
      1,
      1,
      NULL,
      3,
      NULL,
      0.106952,
      6,
      9.913087,
      NULL,
      5.711973,
      0.663749,
      1,
      3,
      0.321308,
      3.172068,
      2,
      2.944958,
      1,
      37,
      NULL,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      1,
      5.743959,
      1,
      NULL,
      '',
      '',
      1.330831,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      23,
      86,
      9,
      NULL,
      26.852037,
      5.523416,
      5,
      3,
      3.668580,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.910233,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.711501,
      3.343903,
      NULL,
      1.103560,
      1.885976,
      NULL,
      0.679698,
      0.561578,
      1.069342,
      1.391261,
      0.362369,
      2,
      0.576772,
      0,
      0,
      0,
      0,
      1,
      0,
      2.603891,
      1,
      0.395401,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.100250,
      1.680429,
      1.837293,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.803256,
      NULL,
      3,
      3.020960,
      NULL,
      1,
      0.913370,
      2,
      0,
      1.450442,
      NULL,
      2.244147,
      1.835672,
      3,
      0.059037,
      NULL,
      NULL,
      3.093898,
      0.335002,
      1,
      NULL,
      0,
      1.489861,
      4.687699,
      NULL,
      1.950854,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.088453,
      0,
      1,
      0.750987,
      0.720981,
      1.149531,
      1.702004,
      NULL,
      NULL,
      7,
      1,
      0.992272,
      3.526628,
      0,
      1.477262,
      1.143427,
      NULL,
      1,
      3.371840,
      1.868357,
      NULL,
      0,
      NULL,
      NULL,
      1.581338,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.518824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.762049,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.343242,
      2.546405,
      3,
      0,
      1.690330,
      NULL,
      0,
      1,
      1.152607,
      1.182725,
      6,
      1.799639,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.430673,
      3.690764,
      2,
      2,
      3.472566,
      1,
      NULL,
      0.095922,
      NULL,
      3,
      0.837921,
      1,
      3,
      1,
      3,
      1,
      NULL,
      0.010458,
      1,
      NULL,
      0.277470,
      NULL,
      NULL,
      0.757070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.476865,
      NULL,
      NULL,
      1.691874,
      NULL,
      NULL,
      0.539832,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.449268,
      NULL,
      NULL,
      7.715696,
      NULL,
      NULL,
      0,
      0,
      0,
      0.490204,
      1,
      0,
      2,
      NULL,
      NULL,
      0.794029,
      4.789888,
      NULL,
      NULL,
      NULL,
      40,
      NULL,
      NULL,
      NULL,
      2.519633,
      NULL,
      NULL,
      NULL,
      0.059952,
      NULL,
      NULL,
      1.882223,
      2,
      NULL,
      NULL,
      NULL,
      1.020197,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.467114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.782218,
      NULL,
      NULL,
      NULL,
      0,
      1.502945,
      NULL,
      NULL,
      1,
      0.972519,
      NULL,
      NULL,
      0.738594,
      0.052281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.124006,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.546932,
      NULL,
      NULL,
      NULL,
      1.914923,
      50,
      3.377494,
      3,
      45.928645,
      NULL,
      1.573590,
      NULL,
      NULL,
      3.802071,
      59,
      NULL,
      0.376176,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.678708,
      NULL,
      1,
      1,
      1,
      NULL,
      0.572718,
      NULL,
      1.617068,
      0.167120,
      NULL,
      NULL,
      0.551792,
      0.160024,
      1,
      0,
      1,
      NULL,
      1.285914,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.334224,
      NULL,
      0,
      0.322211,
      0,
      NULL,
      1,
      2,
      2,
      0,
      1.789432,
      1,
      0,
      2,
      0.686895,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.667375,
      0,
      0,
      1,
      1,
      0,
      1.707217,
      1,
      0.820144,
      1,
      0,
      2.106010,
      3.140539,
      0.553295,
      0,
      1.629533,
      NULL,
      NULL,
      3,
      1.499726,
      1.440611,
      1.527040,
      2,
      3,
      0.145996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977530,
      1.153650,
      0.409294,
      NULL,
      1,
      1.136468,
      NULL,
      4,
      4,
      1,
      NULL,
      NULL,
      11,
      82,
      4,
      1.108340,
      0,
      '30420',
      '',
      '',
      1.643442,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


