set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7425231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '10',
      41.134220,
      0.489119,
      '0333124',
      1,
      NULL,
      NULL,
      2,
      '0010',
      1.645249,
      1.293085,
      NULL,
      NULL,
      ' 5-22-1993',
      NULL,
      8.876340,
      NULL,
      3,
      1,
      ' 0-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-10-1998',
      ' 0-27-1999',
      ' 5-18-1979',
      2,
      3.750925,
      3.842247,
      1,
      0,
      NULL,
      1,
      0.425255,
      1,
      87,
      0,
      13.887872,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.178653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      3,
      3,
      1,
      0,
      1,
      0,
      1,
      6.456941,
      1,
      NULL,
      NULL,
      1,
      0.114988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.893308,
      0.486939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      4.342561,
      0,
      NULL,
      5.290452,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.131385,
      1,
      0,
      0,
      NULL,
      4,
      0.352009,
      4.198182,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      5,
      5,
      0,
      0,
      3,
      3,
      NULL,
      1,
      NULL,
      3,
      4,
      3.366579,
      0.604776,
      ' 8- 0-1994',
      1694,
      '10-17-1995',
      NULL,
      3.683778,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      5,
      1,
      0,
      1,
      0,
      NULL,
      1.361309,
      3.512995,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      757,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658345,
      0,
      NULL,
      7,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.308957,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.360671,
      0,
      0.644193,
      0.185589,
      0.571002,
      0,
      0.351049,
      1.851560,
      68.192996,
      0,
      0.479947,
      9,
      7,
      34.568014,
      3,
      1.330611,
      1.784366,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      1,
      2,
      2.227238,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.675571,
      NULL,
      1.005410,
      0,
      0,
      NULL,
      0.066483,
      0.087043,
      5.386542,
      NULL,
      NULL,
      9.542319,
      NULL,
      1.729199,
      1,
      NULL,
      6,
      0.558606,
      0,
      3.431019,
      NULL,
      1,
      1.194168,
      69,
      NULL,
      34,
      52.975016,
      0,
      3.280334,
      NULL,
      '34022',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.227954,
      7,
      85,
      NULL,
      0,
      43,
      7.300120,
      NULL,
      NULL,
      2.627844,
      1,
      1.310559,
      0.697654,
      NULL,
      NULL,
      2.230479,
      1,
      NULL,
      1.558052,
      NULL,
      NULL,
      0.557786,
      NULL,
      NULL,
      3,
      2,
      1.527964,
      2.777316,
      0.305308,
      1,
      1,
      NULL,
      NULL,
      1.726966,
      NULL,
      NULL,
      1.871002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.548755,
      1,
      3.668629,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.814935,
      1.189497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.284921,
      NULL,
      NULL,
      1.485912,
      NULL,
      NULL,
      0.337891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.725876,
      3.977934,
      1.092921,
      0.426093,
      NULL,
      NULL,
      0.747520,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.954308,
      0.995097,
      2,
      NULL,
      NULL,
      NULL,
      1.492100,
      NULL,
      NULL,
      0,
      1.004543,
      NULL,
      0.443948,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.751476,
      1.102326,
      1,
      0.501521,
      NULL,
      NULL,
      7,
      1.112823,
      1,
      0.849608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339867,
      1.750636,
      NULL,
      1.431550,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.606782,
      4.535677,
      4.907906,
      7,
      5,
      2.701074,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      5.756475,
      4.057790,
      1,
      NULL,
      0.518191,
      1.151150,
      3,
      3,
      2,
      3.174029,
      NULL,
      2,
      1.125089,
      3.092743,
      3,
      6.632552,
      3.023659,
      3.877756,
      7.930502,
      6.534906,
      3,
      3.507950,
      3,
      4,
      1,
      0,
      1,
      0,
      0.340323,
      0.395546,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529623,
      NULL,
      NULL,
      0.483056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562106,
      NULL,
      NULL,
      1.948772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.915737,
      0.262131,
      1,
      3.394245,
      0.874303,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200674,
      NULL,
      NULL,
      NULL,
      0.979610,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.930998,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.039930,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.130735,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.899444,
      28.702220,
      0.280741,
      2.647560,
      6.471188,
      NULL,
      0.815288,
      NULL,
      NULL,
      3.942955,
      3,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.174318,
      NULL,
      NULL,
      695.647564,
      NULL,
      0.270247,
      1,
      NULL,
      0.007427,
      0,
      1.281693,
      NULL,
      0.242809,
      0.800750,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      4.054733,
      0.223389,
      3,
      NULL,
      3.329739,
      3,
      1,
      0,
      1.550675,
      NULL,
      NULL,
      0.529287,
      NULL,
      1,
      3.682888,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.135254,
      3.792291,
      NULL,
      1,
      1.723589,
      NULL,
      0,
      1.172967,
      NULL,
      0.578164,
      2,
      NULL,
      0.112166,
      0.205982,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.942226,
      0,
      NULL,
      NULL,
      NULL,
      0.578614,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.297211,
      NULL,
      1.249577,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.234517,
      NULL,
      1.281160,
      NULL,
      5.422246,
      3.797992,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.783997,
      NULL,
      NULL,
      4,
      NULL,
      1.191503,
      0,
      3,
      53.911193,
      NULL,
      2,
      NULL,
      1.933945,
      '04342',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.302973,
      '',
      '',
      '');
commit;
end;
/


