set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9425957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1212300',
      3.330243,
      0,
      3,
      1,
      '1344',
      3,
      NULL,
      NULL,
      NULL,
      ' 0-20-1975',
      88.623138,
      NULL,
      0,
      3.535770,
      2.667587,
      '11-11-2003',
      30.356402,
      2,
      203.255589,
      128,
      1,
      ' 9- 8-2003',
      ' 8-28-2000',
      ' 4-26-1978',
      2,
      3.505457,
      3.267013,
      3,
      0,
      3,
      1,
      0.082101,
      0.592607,
      105,
      3,
      NULL,
      6,
      2.166833,
      20.726780,
      0,
      13,
      4,
      3,
      NULL,
      0.042135,
      2,
      1,
      NULL,
      0,
      0.719753,
      1,
      1,
      1,
      0.113376,
      NULL,
      0,
      NULL,
      3,
      0,
      4,
      1,
      3,
      1,
      NULL,
      5,
      0,
      0,
      4,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      NULL,
      5,
      1.194983,
      NULL,
      NULL,
      1.914787,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      3.353007,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      5,
      3,
      2,
      1,
      1,
      NULL,
      3,
      0,
      5,
      0,
      2,
      5,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      3.466196,
      2,
      NULL,
      NULL,
      ' 6- 6-1981',
      11.353669,
      1,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      1,
      0,
      1,
      1.344223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0.433050,
      1.885988,
      5,
      NULL,
      2,
      NULL,
      1.035110,
      1,
      5.687478,
      NULL,
      1.922362,
      1,
      1,
      3.251819,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.250639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070176,
      1.810886,
      1.337914,
      0,
      0.144944,
      NULL,
      19,
      0.981344,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      3.924267,
      0,
      2,
      0.269832,
      0.481184,
      0.403356,
      0.116661,
      0.708085,
      1,
      1,
      0,
      1.964647,
      0,
      0,
      2,
      1,
      0.489022,
      1.054956,
      9.758054,
      NULL,
      7,
      5,
      7.554776,
      2,
      2,
      1.601430,
      NULL,
      0.241436,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      33,
      59.023887,
      4,
      0,
      1.750115,
      '30414',
      NULL,
      NULL,
      1.592001,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1.011755,
      15,
      108.585456,
      0.398019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.280917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776972,
      NULL,
      NULL,
      0.675450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.997288,
      0,
      0,
      0.668637,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.496640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.930950,
      NULL,
      NULL,
      0.455879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.504604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.229158,
      NULL,
      NULL,
      2.957123,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.215503,
      0.031734,
      NULL,
      NULL,
      0.265015,
      NULL,
      NULL,
      0.272230,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.886782,
      NULL,
      NULL,
      1.837862,
      NULL,
      NULL,
      4,
      2.454923,
      4,
      NULL,
      NULL,
      NULL,
      3.753260,
      2,
      NULL,
      0.529292,
      3,
      0.127791,
      2,
      2,
      3,
      2,
      0.867947,
      4,
      NULL,
      2,
      0,
      2,
      3,
      0,
      2,
      1.603639,
      0.668888,
      3.178625,
      2,
      2.172169,
      0.634649,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.952305,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239537,
      NULL,
      NULL,
      0.370427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.951714,
      NULL,
      3.339334,
      0,
      2.016632,
      1,
      NULL,
      1.055864,
      0.811777,
      1.340540,
      2,
      1.630124,
      NULL,
      0,
      0.222928,
      NULL,
      3,
      1.680673,
      1.765745,
      1.544078,
      1.561462,
      NULL,
      0.133834,
      NULL,
      0.583214,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      30,
      NULL,
      8.461431,
      11,
      24.738278,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.225833,
      NULL,
      0,
      NULL,
      0.210459,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.194047,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.037109,
      0.705493,
      NULL,
      1.935728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.776016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.744572,
      0,
      NULL,
      NULL,
      1.480671,
      NULL,
      1,
      NULL,
      7.156865,
      NULL,
      3,
      NULL,
      0.515358,
      NULL,
      NULL,
      NULL,
      2,
      1.858471,
      1.406941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102624,
      1.343658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.446893,
      NULL,
      0,
      NULL,
      17.274234,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.116459,
      16,
      NULL,
      0.829085,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0.795011,
      NULL,
      1,
      8,
      NULL,
      NULL,
      NULL,
      2.833942,
      1,
      NULL,
      1.052081,
      1.937839,
      NULL,
      NULL,
      3,
      NULL,
      1.084499,
      1,
      NULL,
      0.744962,
      0.258120,
      NULL,
      2.185248,
      3,
      NULL,
      0,
      2,
      NULL,
      1.342435,
      0.974353,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.441698,
      NULL,
      0.878890,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.077291,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      90.881005,
      44,
      3,
      3,
      3,
      '02410',
      '44132',
      '',
      0.105532,
      '',
      '',
      '',
      1.141483,
      '',
      '',
      '');
commit;
end;
/


