set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3423121',
      1,
      1.228076,
      5,
      NULL,
      '2220',
      1.722558,
      NULL,
      NULL,
      NULL,
      ' 4-27-1978',
      17,
      NULL,
      NULL,
      NULL,
      0.763792,
      ' 9-28-1976',
      48.634340,
      3.292597,
      NULL,
      48,
      2,
      ' 4- 0-1988',
      ' 5- 4-1979',
      ' 1-25-1976',
      2.654277,
      1.725503,
      1.854432,
      0,
      1,
      1,
      3,
      3.624360,
      NULL,
      NULL,
      NULL,
      2.966816,
      NULL,
      14.753183,
      25.682828,
      0,
      1.396483,
      5,
      2,
      0.953547,
      0,
      1,
      0,
      1.056832,
      1,
      1.111404,
      0,
      1,
      0.767090,
      0,
      NULL,
      5,
      3,
      3,
      0,
      1,
      1,
      2,
      0,
      0,
      1,
      1,
      5,
      0,
      2,
      NULL,
      NULL,
      1.164073,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0.030265,
      3.698787,
      3,
      3.577170,
      1.460950,
      0,
      NULL,
      2.666840,
      1,
      0,
      NULL,
      NULL,
      2.860662,
      0.438483,
      0,
      1,
      NULL,
      1.801524,
      0,
      2,
      NULL,
      1.978224,
      NULL,
      NULL,
      0.607424,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      3,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      5,
      1,
      4,
      2,
      0,
      4,
      4,
      5,
      1,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      401.407623,
      ' 6- 6-1999',
      8.278471,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2.795124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763469,
      NULL,
      3,
      1,
      1,
      5,
      0.327889,
      NULL,
      NULL,
      NULL,
      1.990507,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.259719,
      NULL,
      0,
      1.825674,
      1.895408,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.819903,
      1,
      1,
      3,
      0,
      3,
      2,
      0,
      1,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.311412,
      1.060897,
      NULL,
      NULL,
      0.252504,
      0.844005,
      NULL,
      0,
      1.171489,
      0.651654,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.846991,
      1.487542,
      NULL,
      NULL,
      1.586202,
      3,
      3,
      1,
      0,
      1.392035,
      47.560384,
      0,
      1.056319,
      NULL,
      NULL,
      29,
      18.229610,
      2,
      1,
      0,
      '24022',
      '',
      '',
      1.386603,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      NULL,
      134.507910,
      26,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      2.900797,
      2,
      1.989816,
      NULL,
      NULL,
      0.731741,
      NULL,
      NULL,
      0.228199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367824,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837535,
      NULL,
      0.866169,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.497354,
      NULL,
      NULL,
      0.975612,
      3.322464,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.464846,
      2.152773,
      2,
      1.811769,
      1,
      NULL,
      0.265778,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      3.054296,
      0,
      NULL,
      2.184317,
      3.064096,
      1,
      1.159173,
      2,
      1,
      1.525925,
      3,
      1,
      0.675719,
      NULL,
      NULL,
      0.116856,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.252907,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.328792,
      0.236484,
      NULL,
      NULL,
      NULL,
      7.781073,
      NULL,
      0.935181,
      NULL,
      0,
      1.501114,
      1,
      NULL,
      NULL,
      0.182423,
      NULL,
      0,
      1.447330,
      NULL,
      NULL,
      1.692909,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990082,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      1,
      4.207045,
      1.932962,
      NULL,
      3,
      0.033392,
      0,
      0.794522,
      NULL,
      NULL,
      0,
      1.414747,
      0,
      1.609619,
      1,
      0.207488,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.897208,
      1,
      NULL,
      2,
      0,
      0.316506,
      1,
      NULL,
      0.800604,
      2,
      NULL,
      4.487141,
      3.531458,
      0,
      0.131570,
      1,
      3,
      1.870861,
      1.184060,
      NULL,
      1.039072,
      0.102806,
      2.396691,
      NULL,
      NULL,
      0.156501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980669,
      NULL,
      NULL,
      1.651047,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.765574,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.009468,
      3,
      NULL,
      0,
      NULL,
      1.122610,
      NULL,
      1.330720,
      1,
      1.915461,
      NULL,
      1.728916,
      NULL,
      NULL,
      NULL,
      2.328607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.025256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308451,
      1.336488,
      1.009693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.452974,
      1.480817,
      NULL,
      1.934827,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.329912,
      0,
      NULL,
      NULL,
      0.524408,
      1,
      NULL,
      NULL,
      1.561409,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      20,
      1.724142,
      4.264550,
      0,
      0.895575,
      NULL,
      NULL,
      2.422243,
      2,
      0,
      1.190253,
      2.426646,
      0.693148,
      0.287830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.946849,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.194091,
      0,
      NULL,
      1,
      1.744221,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.516649,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077644,
      1.060957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717309,
      1.096407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.176825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310697,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.585739,
      1.229031,
      3,
      1,
      NULL,
      7,
      NULL,
      2.146875,
      2,
      0.692897,
      NULL,
      1.830773,
      1.870668,
      0.003433,
      1.112917,
      NULL,
      NULL,
      3.369975,
      0.099114,
      1,
      1,
      1.105000,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.298502,
      1.342281,
      0,
      NULL,
      1,
      1.615239,
      0.657366,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.724234,
      0.294468,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.736344,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.874493,
      NULL,
      NULL,
      NULL,
      0.965067,
      NULL,
      1,
      NULL,
      0.241741,
      NULL,
      0.555277,
      NULL,
      3.671775,
      1,
      NULL,
      0,
      0,
      0.636378,
      0,
      0.351465,
      NULL,
      4,
      NULL,
      NULL,
      1.383364,
      NULL,
      NULL,
      26.804669,
      NULL,
      0,
      0.349459,
      3.595425,
      '24104',
      NULL,
      '',
      0.119625,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


