set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5713594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3332204',
      2.478008,
      0,
      3,
      3,
      '3224',
      1,
      NULL,
      NULL,
      NULL,
      ' 1-24-1999',
      17,
      NULL,
      0,
      1.600530,
      NULL,
      '10-29-1979',
      NULL,
      3.019825,
      NULL,
      NULL,
      3,
      '10-13-1997',
      NULL,
      ' 7- 8-1976',
      3,
      3,
      NULL,
      NULL,
      0,
      1.738441,
      1,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      13,
      4,
      7.092927,
      5,
      NULL,
      4,
      0.419906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.059116,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      2,
      0.581046,
      NULL,
      0,
      2,
      1,
      2,
      2.566897,
      0.832944,
      1.165928,
      2,
      0,
      2,
      1,
      NULL,
      3,
      NULL,
      1,
      4,
      9,
      0,
      1,
      3.225126,
      0.509470,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      4,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      3.196511,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.611157,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      4,
      2,
      0,
      2,
      2,
      5,
      5,
      5,
      4,
      NULL,
      3,
      3.926107,
      ' 8-13-1999',
      955,
      ' 8-20-1992',
      391,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      47,
      3.772971,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.335769,
      0,
      NULL,
      0.842344,
      3,
      6.078174,
      1.582833,
      2,
      6,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.427261,
      5,
      2,
      0,
      3,
      2,
      0.704515,
      ' 7- 8-2003',
      1303,
      ' 7-15-1991',
      39,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.989341,
      1,
      0,
      0,
      NULL,
      43,
      NULL,
      1.831420,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.098009,
      1,
      0,
      NULL,
      0,
      0,
      2,
      2,
      1,
      0,
      0,
      NULL,
      0,
      1,
      7,
      3.561649,
      0,
      4.423036,
      1,
      0.091680,
      1,
      1.796818,
      1.207125,
      1.244973,
      0.315454,
      0.632424,
      NULL,
      0.038162,
      1,
      NULL,
      0.426976,
      8,
      7,
      1,
      10,
      NULL,
      2,
      0.233533,
      2.936815,
      3,
      NULL,
      3.028570,
      NULL,
      NULL,
      0.913024,
      NULL,
      5,
      NULL,
      72.780349,
      2,
      0.922520,
      2.890890,
      '44343',
      '23121',
      '',
      1,
      '',
      '',
      '',
      2.338507,
      '30442',
      '10143',
      '',
      1.351866,
      10,
      NULL,
      42,
      1,
      69,
      1.349345,
      NULL,
      1,
      3,
      1.558721,
      3,
      1.625591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.622046,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.560414,
      NULL,
      NULL,
      0.169973,
      NULL,
      NULL,
      0.019535,
      NULL,
      NULL,
      0.256262,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.977482,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.896228,
      NULL,
      NULL,
      1,
      1,
      0.248562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.157145,
      1,
      3.522293,
      0.562633,
      0,
      NULL,
      1.547932,
      2,
      0,
      0.093813,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.348914,
      2,
      0,
      4,
      1,
      0.655540,
      NULL,
      NULL,
      NULL,
      3.066531,
      2.884115,
      0.331815,
      1.296372,
      0,
      NULL,
      NULL,
      1.218620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.032748,
      NULL,
      NULL,
      1.964520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.759125,
      NULL,
      NULL,
      1.309440,
      NULL,
      NULL,
      0.954621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      4.776560,
      NULL,
      7,
      1,
      NULL,
      NULL,
      3.504405,
      NULL,
      1,
      1,
      0.997897,
      0.865722,
      NULL,
      1,
      2.426540,
      6,
      NULL,
      2,
      3,
      0,
      1.114576,
      2.300958,
      0.282261,
      0,
      3,
      0,
      0.868801,
      NULL,
      3.332748,
      1.307616,
      7,
      2,
      5.629466,
      1,
      NULL,
      1.826522,
      3.995688,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1.192397,
      0,
      NULL,
      NULL,
      0.774725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.375826,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.719740,
      NULL,
      NULL,
      1.963568,
      NULL,
      NULL,
      0.516005,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.820330,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      3.412072,
      NULL,
      81.294459,
      NULL,
      194.946183,
      NULL,
      2,
      NULL,
      3.043860,
      NULL,
      NULL,
      NULL,
      0.255760,
      NULL,
      0,
      NULL,
      0.362509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.557087,
      NULL,
      3.698773,
      NULL,
      2.452057,
      NULL,
      0.886680,
      NULL,
      3.631930,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      10.033839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.951193,
      1.903108,
      4,
      0,
      68,
      4,
      0.917580,
      NULL,
      NULL,
      NULL,
      47,
      17.191168,
      0.504308,
      NULL,
      NULL,
      1.767373,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      513.658822,
      44,
      0.604411,
      2.706587,
      0.240520,
      0,
      1,
      NULL,
      1.785025,
      1.891178,
      NULL,
      1,
      NULL,
      2.722536,
      0.800982,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.078486,
      NULL,
      0,
      NULL,
      64.797052,
      NULL,
      3,
      NULL,
      8.771070,
      1.630868,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.738691,
      NULL,
      0.625361,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.822918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.348270,
      NULL,
      1,
      3,
      0,
      2.204382,
      NULL,
      3.409357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416950,
      NULL,
      0,
      NULL,
      1.675783,
      NULL,
      0,
      NULL,
      1.477481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.034150,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.495717,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.933799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.485276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930610,
      NULL,
      0.909460,
      NULL,
      0.843978,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.154651,
      5.984957,
      3,
      NULL,
      14,
      NULL,
      2.274232,
      1,
      1,
      1,
      NULL,
      0.018077,
      1.997520,
      NULL,
      1,
      NULL,
      NULL,
      1.097188,
      0,
      NULL,
      3,
      0.363819,
      NULL,
      0.511608,
      0,
      NULL,
      3.492042,
      1,
      NULL,
      2.841199,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.929330,
      NULL,
      1,
      0.550232,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.996469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794474,
      NULL,
      1.167690,
      NULL,
      0.806847,
      NULL,
      1,
      5,
      5,
      2,
      NULL,
      3.415577,
      21.860037,
      82.958749,
      0,
      0,
      NULL,
      '33313',
      '32411',
      '',
      0.814905,
      NULL,
      '',
      NULL,
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


