set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.129232,
      2.979438,
      2.710845,
      3.994114,
      3,
      NULL,
      0.195238,
      3.623589,
      '121',
      '34234322',
      63.574555,
      53,
      '3304111',
      NULL,
      1,
      2,
      3,
      NULL,
      3.750338,
      1.591269,
      NULL,
      NULL,
      NULL,
      112,
      228,
      NULL,
      0.887428,
      NULL,
      ' 5- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7- 2-1995',
      NULL,
      NULL,
      2.097335,
      1.069856,
      NULL,
      0,
      0,
      NULL,
      0,
      1.283462,
      NULL,
      NULL,
      NULL,
      4.712739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.043354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      2,
      0,
      1,
      1,
      3,
      0,
      1,
      3,
      0,
      0,
      1,
      1,
      1,
      3,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.246208,
      NULL,
      NULL,
      4,
      NULL,
      5.145852,
      1,
      0,
      1.381659,
      NULL,
      NULL,
      1.047860,
      1,
      2,
      NULL,
      0.472777,
      0.755052,
      NULL,
      1,
      0.491670,
      0.303742,
      0.837340,
      NULL,
      0,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079751,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      3,
      4,
      2,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0.005640,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      5,
      2,
      NULL,
      1,
      0,
      0,
      5,
      4,
      0,
      2,
      0,
      1,
      5,
      NULL,
      0,
      5,
      5,
      NULL,
      1,
      1,
      0.616100,
      2,
      ' 3-29-1998',
      3273.393315,
      '11- 6-1981',
      359.962566,
      3,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0.353625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.625752,
      1.307166,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786583,
      0,
      4,
      7.636170,
      1,
      0,
      1.350531,
      NULL,
      NULL,
      NULL,
      0.035717,
      2.459695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.410071,
      0,
      1.024672,
      1,
      0.616461,
      1,
      0.173451,
      0,
      NULL,
      2.534522,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.081857,
      NULL,
      1,
      3,
      0,
      1,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      3.527699,
      1,
      3,
      NULL,
      NULL,
      1.530921,
      5.709994,
      1,
      0,
      0.213042,
      1.957853,
      NULL,
      NULL,
      0,
      0.982428,
      NULL,
      3.356699,
      2.038359,
      1.529475,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.955513,
      NULL,
      4.170865,
      NULL,
      0.104843,
      3,
      62,
      1,
      1,
      NULL,
      NULL,
      25,
      64,
      5,
      5.782638,
      3,
      '43103',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.265162,
      '',
      '',
      '',
      0.880243,
      2,
      1,
      17,
      1,
      24,
      20,
      92,
      2,
      0.187001,
      2.806987,
      0.368179,
      1,
      NULL,
      NULL,
      0.329172,
      1.869617,
      1.500626,
      NULL,
      NULL,
      1.858377,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.406572,
      2.711933,
      NULL,
      1.732498,
      NULL,
      NULL,
      1.363112,
      NULL,
      2.389340,
      NULL,
      1.139244,
      NULL,
      2.570938,
      0.129527,
      0.610109,
      1,
      NULL,
      0.405683,
      11,
      0,
      8.342214,
      NULL,
      1.839446,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.833654,
      0,
      2.723032,
      1,
      3.331228,
      3,
      1,
      1,
      2.766697,
      1,
      3.477148,
      3,
      1.404591,
      0,
      NULL,
      NULL,
      0.604562,
      NULL,
      0,
      0,
      3.668100,
      1.785341,
      3.212585,
      2,
      1.479878,
      NULL,
      NULL,
      1.595711,
      NULL,
      NULL,
      NULL,
      1.607893,
      NULL,
      8.038184,
      9.692289,
      4.350223,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362820,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.053221,
      NULL,
      NULL,
      1.157054,
      3,
      1,
      2.938284,
      NULL,
      1.636630,
      0.551284,
      9,
      0,
      NULL,
      0.787808,
      2.132707,
      0.983235,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.536011,
      NULL,
      NULL,
      2.242136,
      0.200458,
      1.220011,
      1,
      0.784512,
      0,
      0.631056,
      0,
      NULL,
      1.754283,
      1.437695,
      1,
      1.288209,
      1,
      5,
      8,
      4.177184,
      0,
      0,
      NULL,
      NULL,
      0.751218,
      1,
      0,
      0,
      1.939565,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0.808013,
      0.716058,
      2,
      0,
      1.314292,
      0,
      NULL,
      0.939738,
      NULL,
      0.374991,
      1,
      3,
      7,
      3,
      3.010095,
      1,
      NULL,
      NULL,
      0,
      3,
      3,
      0.979559,
      0.890239,
      0.572613,
      1.096195,
      1,
      3.534798,
      NULL,
      NULL,
      0.679852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.084694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318390,
      NULL,
      NULL,
      0.377961,
      NULL,
      NULL,
      1.247670,
      1.562202,
      0.557873,
      1,
      0.526652,
      2.738782,
      0.531702,
      NULL,
      NULL,
      3.620607,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.357356,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.390695,
      NULL,
      NULL,
      NULL,
      0.532593,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.747032,
      NULL,
      NULL,
      NULL,
      9.831034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      570.414131,
      74.920317,
      3.614712,
      NULL,
      NULL,
      1.815842,
      NULL,
      NULL,
      2,
      56,
      NULL,
      3,
      91,
      19,
      1,
      NULL,
      NULL,
      0.637840,
      NULL,
      NULL,
      NULL,
      1.758112,
      0,
      1.483037,
      0.275336,
      1.662917,
      0.756839,
      1.596827,
      NULL,
      1.023206,
      NULL,
      0,
      0.424859,
      1,
      NULL,
      0.044160,
      1.069033,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      3.853426,
      1.864898,
      1,
      3.890934,
      NULL,
      3.868038,
      0.505039,
      0.590166,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.347458,
      1,
      NULL,
      NULL,
      1.299488,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.705980,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      3.269523,
      1.886360,
      1.638904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059965,
      NULL,
      0,
      NULL,
      0.109284,
      NULL,
      2,
      3,
      3,
      1,
      NULL,
      NULL,
      57,
      NULL,
      NULL,
      3,
      NULL,
      '02024',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


