set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7.188128,
      1.706162,
      NULL,
      0.345036,
      3,
      2.484180,
      3.669271,
      5.961628,
      '202',
      '42202232',
      26,
      68.467402,
      '1411120',
      1.648718,
      1,
      0,
      2,
      '4020',
      5.332388,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1975',
      28.313715,
      40,
      NULL,
      2,
      NULL,
      ' 1-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-23-1986',
      ' 8-18-1989',
      '11- 6-2000',
      0.660262,
      0,
      NULL,
      NULL,
      0.897418,
      1.724777,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3.531481,
      1.092230,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      3,
      1,
      1,
      1,
      0.707108,
      1.607366,
      3.361807,
      0,
      NULL,
      1,
      3,
      0,
      3,
      3,
      3,
      1,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      1,
      0,
      1,
      5,
      9,
      0,
      0,
      0,
      NULL,
      0.923337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.796000,
      NULL,
      1.326747,
      1,
      0,
      1.313327,
      3.353954,
      0.505850,
      1.277369,
      0.798658,
      1.815161,
      0,
      NULL,
      1.809705,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      0,
      1,
      1.726660,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      4.149420,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      4,
      0,
      4,
      1,
      0,
      3,
      NULL,
      2,
      1,
      3,
      1,
      NULL,
      2,
      NULL,
      5,
      0,
      1,
      2,
      0,
      3,
      2,
      5,
      3,
      3,
      NULL,
      17.339267,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.548815,
      3.220050,
      3.475254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.261276,
      4.050360,
      NULL,
      1.731726,
      0.050339,
      8.575222,
      0,
      0.760619,
      NULL,
      NULL,
      1,
      5.749721,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.635445,
      0,
      0.814161,
      3.129139,
      0,
      0,
      NULL,
      0,
      71.271965,
      1.363547,
      1.588081,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.600136,
      2,
      3.547621,
      1,
      0,
      1,
      0,
      0,
      1,
      0.105351,
      1.503707,
      1,
      1.434006,
      0.700045,
      1.938051,
      1,
      0.908824,
      NULL,
      0.432249,
      4.474206,
      2.966578,
      5,
      0,
      1,
      7.532390,
      0.044852,
      1,
      2,
      NULL,
      0.139911,
      0.983271,
      NULL,
      NULL,
      3,
      12,
      NULL,
      7,
      81,
      0,
      1.549837,
      NULL,
      '31114',
      '11304',
      '',
      NULL,
      '14104',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      0.057905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.847110,
      1.389114,
      2,
      1.500681,
      NULL,
      0,
      NULL,
      NULL,
      1.090594,
      2.422374,
      0.576403,
      0,
      NULL,
      NULL,
      1.805719,
      NULL,
      NULL,
      1.654378,
      NULL,
      0.291000,
      69.705645,
      NULL,
      0,
      0.081391,
      0,
      0.692729,
      0,
      0.344855,
      NULL,
      0.085236,
      1,
      1.430084,
      0.819430,
      0.161581,
      1,
      0,
      0,
      1.959574,
      3.918035,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      29,
      NULL,
      2.020751,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.347829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327230,
      NULL,
      0.779439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.045244,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.174892,
      NULL,
      2,
      NULL,
      1.890342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.294536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517795,
      0.129738,
      2,
      NULL,
      3.381556,
      NULL,
      213.766329,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.602138,
      NULL,
      NULL,
      NULL,
      3.608853,
      NULL,
      NULL,
      NULL,
      260.597616,
      NULL,
      2,
      NULL,
      0.565620,
      NULL,
      1.225728,
      NULL,
      NULL,
      NULL,
      1.164940,
      1.534604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.755423,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087764,
      NULL,
      NULL,
      2.675753,
      NULL,
      184,
      NULL,
      1,
      NULL,
      1.959010,
      NULL,
      1.608750,
      NULL,
      0,
      NULL,
      29,
      NULL,
      1.616414,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      0.777109,
      NULL,
      0,
      NULL,
      1,
      1.147855,
      NULL,
      1.640551,
      0,
      NULL,
      0,
      0.153995,
      NULL,
      0.895196,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.884255,
      1,
      NULL,
      1,
      1,
      NULL,
      1.650533,
      1,
      NULL,
      0.123202,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      0.338126,
      NULL,
      NULL,
      6.945883,
      44.030657,
      NULL,
      5.340660,
      1.701807,
      '14023',
      '12332',
      '40403',
      NULL,
      '',
      '',
      '',
      1.445192,
      '',
      '',
      '');
commit;
end;
/


