set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9921354';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      2,
      3,
      2,
      1,
      0.345243,
      7.399789,
      NULL,
      '10113132',
      40.669680,
      21,
      '0120344',
      0,
      1.039575,
      NULL,
      2,
      '0133',
      NULL,
      1.016075,
      NULL,
      NULL,
      NULL,
      25,
      29.955829,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5-24-1998',
      ' 2-18-2000',
      ' 7-21-1993',
      0.951315,
      0.004801,
      1.959858,
      3,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1.667189,
      1,
      0,
      1,
      0.652022,
      0.420876,
      0.929805,
      1,
      NULL,
      4,
      1,
      NULL,
      4,
      NULL,
      2,
      2,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.839097,
      1.420318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2,
      0,
      2,
      3,
      1,
      1,
      NULL,
      2,
      5,
      3,
      0,
      5.795469,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      4,
      3,
      0,
      0,
      NULL,
      1,
      3,
      0,
      1,
      0,
      5,
      4,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.671592,
      '10-10-1978',
      4.933601,
      ' 0-29-1998',
      4,
      0.182625,
      2,
      2,
      3,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      5,
      0,
      4,
      0,
      1,
      5,
      0,
      2.931530,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.591026,
      2.260392,
      2.986989,
      3.182142,
      5.202013,
      0.568656,
      1.347322,
      NULL,
      0,
      1.404916,
      1.557445,
      NULL,
      NULL,
      NULL,
      1.025362,
      6.784719,
      1.022582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735644,
      0,
      0,
      3,
      0.469500,
      0,
      NULL,
      NULL,
      1.506811,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.283176,
      NULL,
      3,
      3,
      0,
      3,
      1,
      3,
      3,
      2,
      1,
      1,
      3,
      2,
      NULL,
      1,
      1,
      1.133554,
      NULL,
      1.272336,
      0.983112,
      1,
      NULL,
      1.771594,
      0,
      1.063790,
      1.258400,
      1,
      0,
      1,
      1.218723,
      3.978525,
      3,
      NULL,
      6.564947,
      0,
      6,
      3,
      1,
      NULL,
      1.511405,
      1,
      2.774918,
      NULL,
      0,
      1.424046,
      5,
      NULL,
      7,
      75.993856,
      0,
      2,
      NULL,
      '13121',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.411185,
      '',
      '',
      NULL,
      3.918206,
      10,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738286,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.449371,
      NULL,
      NULL,
      0.862700,
      NULL,
      NULL,
      0.903041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323414,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.457008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472766,
      NULL,
      NULL,
      0.560646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.512794,
      NULL,
      NULL,
      0.234387,
      NULL,
      NULL,
      0.694670,
      NULL,
      NULL,
      0.046067,
      NULL,
      NULL,
      0.639729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.957455,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929664,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.179503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.768356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.983405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.413567,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623835,
      NULL,
      NULL,
      0.008175,
      NULL,
      NULL,
      1.689853,
      1,
      NULL,
      0,
      0.670643,
      0.491365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.996304,
      0.122632,
      2.415297,
      1.302822,
      1.574598,
      1.703890,
      NULL,
      NULL,
      NULL,
      NULL,
      25.621087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235068,
      NULL,
      NULL,
      NULL,
      0.307096,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.753176,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.229847,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.101369,
      8.036582,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.709785,
      3.225991,
      0.499385,
      1,
      NULL,
      NULL,
      0.861474,
      NULL,
      NULL,
      219.804240,
      0,
      0.547459,
      1.338298,
      0,
      1.833491,
      1.748102,
      0.626995,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0.920609,
      0,
      0,
      NULL,
      0.413378,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.827845,
      NULL,
      3.339874,
      NULL,
      8,
      NULL,
      3,
      NULL,
      17,
      NULL,
      0,
      0.568586,
      NULL,
      1,
      NULL,
      1.305710,
      NULL,
      0.344348,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.125190,
      NULL,
      0.679313,
      NULL,
      0.648874,
      NULL,
      NULL,
      NULL,
      1.448786,
      NULL,
      0.320429,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.347232,
      0.386140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682557,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075085,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.239908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972513,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.259400,
      NULL,
      1,
      NULL,
      1,
      NULL,
      10.636001,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871098,
      5,
      0.584885,
      0.973786,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.594031,
      1.803050,
      1.210562,
      3,
      3,
      3,
      3,
      NULL,
      1,
      1,
      1.304551,
      1,
      1.208289,
      1.744352,
      1,
      0.130093,
      1.939368,
      1,
      0.220309,
      1,
      1.884310,
      1,
      3,
      0.418609,
      1,
      0,
      NULL,
      NULL,
      2.058762,
      2,
      1.984081,
      NULL,
      0,
      1,
      0.909451,
      NULL,
      2.438096,
      0.747640,
      0.956428,
      0,
      0.958351,
      1.134739,
      NULL,
      1,
      0.371363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970512,
      0.834039,
      1,
      1,
      1,
      0.761730,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      103.457350,
      22.824257,
      1,
      1,
      4.507833,
      '32031',
      '14320',
      '41244',
      1.212214,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


