set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9336131';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0411242',
      3,
      1,
      NULL,
      NULL,
      '3404',
      2,
      1.275919,
      NULL,
      NULL,
      '11-24-1989',
      118,
      NULL,
      3,
      1.727958,
      0.168659,
      NULL,
      41,
      NULL,
      161,
      NULL,
      3,
      ' 9-25-1978',
      ' 6-15-1996',
      ' 3-28-1994',
      0.381148,
      0,
      3,
      NULL,
      1.735696,
      NULL,
      5,
      1,
      0,
      3.704228,
      3,
      14,
      2.050046,
      NULL,
      NULL,
      3,
      15,
      1,
      1,
      4.000079,
      1.776272,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      4.690930,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.841260,
      1.983287,
      0,
      0,
      0.702912,
      0.609986,
      1.633875,
      1.896690,
      0.580416,
      0,
      1,
      NULL,
      1.721092,
      0.351843,
      1.910838,
      NULL,
      0,
      3,
      0,
      NULL,
      5.010012,
      NULL,
      1,
      1.509806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      5.668557,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      0,
      2,
      0,
      1,
      NULL,
      537.521935,
      '11- 5-1978',
      1679.579598,
      0.157325,
      2,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3,
      0,
      1,
      2,
      4,
      0,
      3,
      2,
      2,
      NULL,
      3,
      NULL,
      2.307753,
      1.584815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      2.691939,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      1.721454,
      0.487442,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.898339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1.471314,
      1.639038,
      16,
      1.506758,
      0.081800,
      NULL,
      NULL,
      NULL,
      0,
      1.743456,
      2,
      3,
      3,
      3,
      0,
      3,
      3,
      1,
      2,
      2,
      3,
      0,
      0,
      1.823786,
      3.725998,
      1,
      0,
      2,
      NULL,
      0,
      1.392842,
      0,
      1,
      0,
      NULL,
      1.613825,
      3,
      0,
      2,
      0,
      8.364068,
      9.460146,
      2.355575,
      0.875443,
      9.600295,
      3.823640,
      1.550614,
      NULL,
      7.949389,
      NULL,
      0,
      2,
      15,
      1,
      2,
      NULL,
      3,
      40,
      9,
      0,
      3.752712,
      3.525399,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '13204',
      NULL,
      37.469451,
      365,
      NULL,
      2.922318,
      NULL,
      5.624277,
      0.069143,
      2,
      0.444509,
      1.739887,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.199921,
      1.617526,
      2,
      0,
      2,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      0,
      0.893480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.364882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.709677,
      0,
      0,
      1.565105,
      NULL,
      NULL,
      NULL,
      0.753452,
      NULL,
      NULL,
      NULL,
      2.275285,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470630,
      1.701245,
      1,
      1,
      1,
      1.152127,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.912945,
      0.557788,
      0.818020,
      0.256435,
      2,
      0,
      0.921204,
      1.549053,
      NULL,
      NULL,
      0,
      1,
      1,
      2.945209,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.342617,
      0.352687,
      NULL,
      2,
      0.294643,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.362716,
      0,
      2,
      1,
      2,
      0.795573,
      0.207801,
      3.014537,
      2,
      1,
      NULL,
      5,
      0.271629,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268887,
      NULL,
      NULL,
      0.971793,
      NULL,
      NULL,
      0.920741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.686284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.232531,
      NULL,
      NULL,
      3.429039,
      0,
      3,
      1,
      0.799421,
      2.602205,
      2.897553,
      1,
      1.513269,
      0.181149,
      NULL,
      NULL,
      2.406991,
      NULL,
      2.226380,
      NULL,
      1.054434,
      NULL,
      0.463508,
      0,
      3,
      0.111366,
      0,
      1.851074,
      0,
      2.980437,
      1.688524,
      2,
      0.708249,
      3,
      3.186836,
      NULL,
      NULL,
      0.622524,
      0,
      1,
      0.203248,
      1,
      0.024587,
      1.960497,
      1.390619,
      NULL,
      NULL,
      NULL,
      0.684231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768584,
      NULL,
      NULL,
      0.446594,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635185,
      NULL,
      NULL,
      1.266760,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      0.242732,
      1.831233,
      0.926747,
      3.995452,
      0.607730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.551220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.128086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816656,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.273611,
      2.406664,
      2.180181,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278022,
      NULL,
      0,
      538.547490,
      54.659168,
      NULL,
      2,
      NULL,
      1.566809,
      1.309795,
      1,
      1,
      3,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3.771685,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.500782,
      NULL,
      1.487543,
      NULL,
      NULL,
      NULL,
      84,
      NULL,
      1,
      18,
      53,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346728,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.927191,
      2,
      NULL,
      0.683659,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.590243,
      NULL,
      1,
      NULL,
      1.696539,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.811087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400496,
      NULL,
      0,
      NULL,
      0.765634,
      NULL,
      0.863134,
      1,
      0.160892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.031682,
      NULL,
      0.546320,
      NULL,
      NULL,
      NULL,
      0.911138,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278686,
      1,
      NULL,
      0.347437,
      NULL,
      0.388976,
      NULL,
      NULL,
      NULL,
      0.759791,
      3,
      3,
      0,
      2.144997,
      1.861288,
      1.403046,
      NULL,
      NULL,
      1.649901,
      0.030267,
      0,
      1.925234,
      1,
      0.361410,
      0.767488,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      0.918366,
      NULL,
      2,
      5,
      3.494021,
      1,
      NULL,
      1.341115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184683,
      3.585527,
      NULL,
      NULL,
      0,
      NULL,
      0.744392,
      1.097490,
      NULL,
      0.198655,
      0.517506,
      NULL,
      0,
      0.006114,
      NULL,
      0,
      1,
      NULL,
      0.640555,
      2.557719,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      2.060818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724466,
      NULL,
      NULL,
      NULL,
      0.049649,
      NULL,
      4,
      5,
      5,
      1.704036,
      NULL,
      NULL,
      31,
      58.416381,
      5,
      NULL,
      5.299710,
      '40233',
      '03003',
      '',
      0,
      '',
      '',
      '',
      3.267899,
      '23101',
      '44440',
      '04232');
commit;
end;
/


