set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      '4423',
      1,
      1,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      3,
      2,
      3.436931,
      ' 0- 0-1992',
      38.095929,
      NULL,
      NULL,
      42.540522,
      1,
      ' 7-12-2001',
      ' 5-13-1987',
      ' 1-22-1974',
      NULL,
      3,
      3.396237,
      NULL,
      1,
      1,
      NULL,
      0.056093,
      NULL,
      NULL,
      NULL,
      0.932182,
      4.643522,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      NULL,
      0.847948,
      3,
      1,
      0.354621,
      0,
      0.328033,
      0.791952,
      1,
      1,
      NULL,
      0,
      3,
      4,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      3,
      1,
      3,
      4,
      0,
      4,
      5,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.728649,
      2,
      1.226306,
      0.216871,
      NULL,
      2,
      0,
      2,
      0.824206,
      0,
      2.164165,
      0.070113,
      0.374942,
      1,
      1,
      NULL,
      3.265584,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      2.016271,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      2,
      1,
      5,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      2.772788,
      NULL,
      0.201463,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      4,
      5,
      4,
      2,
      0,
      3,
      NULL,
      0,
      4,
      4,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      10.727175,
      '10- 6-1986',
      3,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286370,
      NULL,
      NULL,
      1.775133,
      1.391993,
      2,
      3.037781,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.299677,
      0.513144,
      NULL,
      1.268510,
      3.899715,
      NULL,
      2,
      0.011550,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247951,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      0,
      3,
      NULL,
      0,
      3,
      0.966490,
      2,
      3.510523,
      1.478858,
      0.229285,
      NULL,
      0.172326,
      1.174573,
      0.210899,
      1,
      NULL,
      0,
      1,
      1.878515,
      0,
      0,
      12.177587,
      5.303061,
      1,
      6.943447,
      8.908120,
      0.665308,
      10,
      1,
      NULL,
      5.047575,
      NULL,
      NULL,
      1.813116,
      3,
      3.021668,
      51,
      2,
      3.532239,
      NULL,
      33,
      4,
      75,
      NULL,
      4,
      1.187751,
      '03020',
      '',
      '',
      1.413825,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      14.194462,
      20,
      24,
      1.955348,
      5.101809,
      0.862487,
      NULL,
      1,
      NULL,
      0.096038,
      0,
      1,
      NULL,
      NULL,
      2,
      0.019859,
      0,
      0,
      NULL,
      NULL,
      1.379493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1.561367,
      2,
      3,
      2,
      3.063523,
      0.909568,
      0,
      0.195879,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11,
      3.215532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.185850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.566417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846858,
      NULL,
      NULL,
      NULL,
      1.907954,
      2,
      0.382567,
      1.058786,
      1.664982,
      0.453941,
      NULL,
      NULL,
      5.876381,
      7,
      0.700854,
      1.312641,
      2.998828,
      3.835441,
      1.149323,
      2.291197,
      1,
      4,
      1.096776,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.579312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.319699,
      2,
      2.221647,
      1.239713,
      1,
      0.191264,
      7,
      2.605561,
      7,
      1.879142,
      1.125476,
      7.115608,
      4.921887,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.928107,
      1,
      0,
      1,
      NULL,
      0,
      1.144412,
      NULL,
      NULL,
      2,
      NULL,
      0.720905,
      1.955245,
      0,
      0.008384,
      1,
      NULL,
      NULL,
      0,
      3.700825,
      11,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.283989,
      1,
      1.119878,
      NULL,
      1.980935,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532804,
      0.257893,
      0.400235,
      NULL,
      3.654823,
      0.691179,
      NULL,
      NULL,
      1.882357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.936727,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.494717,
      NULL,
      NULL,
      NULL,
      1.484383,
      NULL,
      NULL,
      NULL,
      3.392883,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.307139,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.307383,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459129,
      3,
      6,
      4,
      2,
      NULL,
      1.823447,
      0.775744,
      0,
      NULL,
      0.730497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.075323,
      NULL,
      NULL,
      1.644582,
      NULL,
      0,
      68,
      NULL,
      0,
      0.073011,
      0.883648,
      1.600244,
      1,
      NULL,
      1.892290,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.740847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      2.926877,
      2,
      0,
      0.817352,
      NULL,
      NULL,
      1.901328,
      3,
      NULL,
      0.028471,
      3.070850,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      0.823707,
      NULL,
      NULL,
      1.552043,
      2,
      NULL,
      1,
      2.961132,
      NULL,
      1.948795,
      1,
      NULL,
      1.277482,
      0.922038,
      NULL,
      0.061435,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.343021,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      3,
      5,
      2,
      '21420',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


