set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3330020',
      1.114120,
      1.111468,
      NULL,
      1,
      '3322',
      1.072895,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      1,
      ' 1- 4-1999',
      28.517223,
      NULL,
      167,
      31,
      1,
      ' 2- 5-1979',
      NULL,
      ' 9-28-2001',
      NULL,
      1,
      1,
      NULL,
      1,
      3.962201,
      3,
      1,
      0.206220,
      0.210177,
      1,
      NULL,
      2.190000,
      7,
      14,
      1,
      14,
      2,
      4,
      9,
      1,
      0,
      1,
      0,
      0.154427,
      0.686388,
      0.600364,
      NULL,
      0.043518,
      1.242283,
      2.642955,
      NULL,
      6,
      6,
      0.279167,
      0,
      0,
      0,
      2,
      4,
      0,
      1,
      4,
      3,
      3,
      5,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747664,
      NULL,
      2.123981,
      NULL,
      0,
      0,
      0,
      1.560157,
      NULL,
      1.955340,
      3.011788,
      NULL,
      NULL,
      2.228193,
      1,
      1.588667,
      1.284723,
      1,
      0,
      4,
      0.590548,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.404885,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.947676,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.059771,
      4,
      1,
      5,
      4,
      1,
      0,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      3,
      4,
      0,
      2,
      1,
      NULL,
      0,
      2,
      NULL,
      3,
      2,
      4,
      2,
      0.832900,
      3,
      ' 7- 2-1992',
      201.737631,
      '10-10-1989',
      NULL,
      1.050055,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.650377,
      NULL,
      1.020516,
      3,
      1.352092,
      0,
      NULL,
      1.106830,
      14.121059,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566808,
      0.509978,
      5.127610,
      0,
      3.490383,
      1,
      1,
      4.872495,
      2,
      1,
      2.965623,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.973673,
      1.807237,
      1.626730,
      1,
      0.301950,
      1,
      1.000281,
      3,
      NULL,
      1.857447,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.202200,
      1.008817,
      0,
      1,
      0,
      1,
      2,
      3,
      2,
      3,
      0,
      3,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.176785,
      NULL,
      0,
      1,
      1.779635,
      NULL,
      0.752806,
      1,
      0,
      1.387891,
      1,
      2.237319,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      23,
      54.784932,
      1,
      0,
      1,
      '01431',
      NULL,
      '',
      0.521791,
      '23202',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      29,
      51.432584,
      7.098853,
      NULL,
      NULL,
      2.490257,
      7.802924,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.698153,
      NULL,
      NULL,
      2.503467,
      1.793575,
      0,
      2,
      0,
      3.027142,
      0.344842,
      NULL,
      NULL,
      0.615241,
      0,
      NULL,
      3.241928,
      1,
      1.762538,
      2,
      1,
      NULL,
      1,
      NULL,
      0.860942,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      3.454700,
      0.390575,
      1.728169,
      0.879954,
      1.496477,
      NULL,
      NULL,
      NULL,
      3.839122,
      0.639339,
      0.099843,
      1,
      NULL,
      NULL,
      3,
      3.660176,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.114017,
      1.896914,
      3.426575,
      3,
      3,
      NULL,
      0,
      2.959998,
      0.905653,
      0.371282,
      1,
      1.684944,
      3.843161,
      3.336804,
      1,
      0,
      NULL,
      NULL,
      0.741080,
      NULL,
      NULL,
      6.532879,
      6,
      5.327207,
      2,
      3,
      NULL,
      0.198645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776562,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.580072,
      1,
      0,
      0.291643,
      NULL,
      NULL,
      6,
      2,
      0,
      0.399425,
      NULL,
      NULL,
      3.733867,
      2.901107,
      1,
      3,
      NULL,
      NULL,
      1.001341,
      NULL,
      NULL,
      0.285150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.859974,
      NULL,
      NULL,
      0.188826,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.872637,
      0,
      3.823611,
      0,
      2.002238,
      2.669541,
      0,
      5.693662,
      NULL,
      4,
      NULL,
      NULL,
      1.632785,
      5,
      2,
      2.813338,
      1.608133,
      0.203532,
      3,
      0.736132,
      3.152616,
      1.836160,
      0,
      0,
      NULL,
      9,
      NULL,
      0,
      3.522449,
      1.288218,
      1,
      NULL,
      NULL,
      2.474714,
      3.700732,
      3.352207,
      2.376292,
      1,
      0.131917,
      9,
      NULL,
      7,
      NULL,
      7,
      1,
      3.648699,
      0,
      0,
      2.461977,
      0,
      3.745067,
      NULL,
      1,
      0,
      NULL,
      3,
      0.160056,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.005797,
      3,
      NULL,
      3.246382,
      0,
      NULL,
      3,
      2,
      NULL,
      0,
      0.122716,
      NULL,
      2.936480,
      0,
      NULL,
      0.731690,
      1.430255,
      NULL,
      6,
      5,
      NULL,
      2.244334,
      1.473879,
      1.410926,
      1,
      NULL,
      0.948234,
      1.619364,
      1.805512,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254868,
      NULL,
      NULL,
      NULL,
      0.099659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.283543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.724848,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      41,
      0.784037,
      NULL,
      NULL,
      1.239306,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4.596376,
      2,
      1.075373,
      1,
      1,
      1.515262,
      1,
      62,
      0.083550,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.480969,
      0.580101,
      0,
      1.512088,
      0,
      0.406388,
      1,
      0,
      0.641733,
      NULL,
      0.085716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.611582,
      0.380426,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.669861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.735377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.666488,
      NULL,
      0.520437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649537,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      4.859709,
      3,
      3.459501,
      2,
      3,
      NULL,
      1.664076,
      3,
      NULL,
      0.589126,
      NULL,
      NULL,
      0.899299,
      0.992946,
      NULL,
      1,
      0.830480,
      NULL,
      1.941815,
      1.125147,
      NULL,
      0.556251,
      0,
      NULL,
      1,
      1.766859,
      NULL,
      1.625894,
      1,
      NULL,
      1,
      1.937834,
      NULL,
      0.957831,
      0,
      NULL,
      NULL,
      3.946297,
      NULL,
      1.503344,
      0.422403,
      NULL,
      2.512816,
      0.376250,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886645,
      NULL,
      1,
      NULL,
      4,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      47.843351,
      0,
      NULL,
      NULL,
      '21241',
      '',
      '',
      NULL,
      '03024',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


