set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '2411230',
      0.746160,
      1.281700,
      0,
      2,
      '0101',
      3.131068,
      1.084494,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1.017045,
      1,
      NULL,
      NULL,
      NULL,
      58.037013,
      65,
      0,
      ' 5- 6-1977',
      ' 1- 8-1975',
      ' 8-22-1977',
      0.646523,
      1,
      NULL,
      0.156760,
      1,
      NULL,
      2,
      NULL,
      1.106045,
      5.080488,
      4,
      14.153086,
      NULL,
      18.685135,
      NULL,
      NULL,
      8,
      NULL,
      5,
      5,
      1.333023,
      1,
      1,
      0.592916,
      0,
      0.198747,
      0,
      NULL,
      0,
      1,
      NULL,
      7,
      5,
      0,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      1,
      0,
      3,
      5,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.786501,
      1,
      NULL,
      2.385359,
      2,
      1.750827,
      1,
      2.444611,
      1,
      0.566817,
      NULL,
      NULL,
      0,
      NULL,
      1.711269,
      NULL,
      1.916488,
      0,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      0.891226,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      2,
      3,
      0,
      0,
      4,
      NULL,
      4,
      0,
      4.645483,
      0,
      0,
      NULL,
      0,
      0.750127,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      2,
      5,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      2,
      NULL,
      6,
      1.278835,
      ' 2-13-1983',
      243,
      '11-22-1995',
      5.411906,
      2.517288,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.285221,
      0.152701,
      1.760664,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.771667,
      NULL,
      1,
      3.777457,
      0,
      NULL,
      7,
      2,
      0,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.098563,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      68.311399,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      1,
      3,
      1,
      3,
      NULL,
      2,
      NULL,
      0,
      2.356897,
      1.334345,
      12,
      NULL,
      1.049755,
      NULL,
      0.638002,
      1,
      NULL,
      0.355598,
      0,
      0.761462,
      0,
      0,
      0,
      0,
      NULL,
      7.272463,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      5,
      0,
      1.412161,
      NULL,
      1.958971,
      2.823970,
      2,
      15.154200,
      1,
      0,
      NULL,
      32,
      15,
      NULL,
      NULL,
      1,
      1.864298,
      '04403',
      '',
      '',
      0.880679,
      '10042',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.760817,
      NULL,
      36,
      1,
      2.459396,
      2,
      5.256832,
      3,
      4,
      NULL,
      1.486897,
      0,
      0.018207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.300395,
      1.602168,
      0.658226,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.291568,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.238335,
      NULL,
      NULL,
      1.250712,
      3.582577,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.260258,
      5,
      1,
      0.560672,
      NULL,
      NULL,
      NULL,
      1.642704,
      NULL,
      NULL,
      NULL,
      NULL,
      3.109517,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      2,
      3,
      3,
      1.600983,
      0.665604,
      0.157178,
      0,
      0,
      3,
      3,
      2.945246,
      1.201228,
      NULL,
      0.260320,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.471907,
      1,
      0,
      8.559589,
      8.321312,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.845263,
      NULL,
      NULL,
      NULL,
      0.282266,
      NULL,
      NULL,
      0.938390,
      NULL,
      NULL,
      2,
      1,
      1.615711,
      1,
      NULL,
      NULL,
      6,
      4,
      0.996458,
      NULL,
      2,
      0.338601,
      2.389684,
      1,
      1,
      7,
      3.520745,
      1.555369,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184264,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      2,
      6.786886,
      NULL,
      4.276799,
      NULL,
      0.556109,
      2,
      7,
      4,
      0.054362,
      1,
      1.463807,
      NULL,
      1.233536,
      2,
      1.502171,
      NULL,
      NULL,
      NULL,
      5,
      2,
      5.022905,
      2,
      2.482426,
      NULL,
      0,
      NULL,
      NULL,
      3.829873,
      0.924180,
      3.081279,
      NULL,
      1.979950,
      2,
      5,
      2,
      8.473786,
      0,
      3.344903,
      5.587390,
      1.997938,
      1,
      2,
      0,
      1.148705,
      0,
      1.650140,
      NULL,
      3,
      NULL,
      NULL,
      3.871375,
      NULL,
      NULL,
      3.302320,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.627622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.429084,
      NULL,
      NULL,
      1.540504,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945907,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.724383,
      0,
      0,
      1.974927,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.574122,
      NULL,
      NULL,
      NULL,
      1.066681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.963871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.629696,
      7.458718,
      14,
      1.143555,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.183085,
      19.625197,
      2.219328,
      NULL,
      0.147778,
      0,
      NULL,
      10,
      NULL,
      170.323204,
      NULL,
      NULL,
      1,
      0.105113,
      0.555802,
      0,
      NULL,
      1.551802,
      0,
      0,
      1,
      1.471550,
      0.701114,
      0.254446,
      0.686125,
      0.957681,
      0,
      0.400536,
      0.668975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897302,
      1.903351,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.987565,
      NULL,
      0,
      NULL,
      1.819028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816039,
      NULL,
      1,
      1.377210,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.831467,
      NULL,
      0.567067,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.842338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.534999,
      0,
      3.603276,
      2.598587,
      3,
      3.523320,
      2.067815,
      0,
      0.722737,
      0.042187,
      0.883271,
      NULL,
      1.128015,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.341641,
      NULL,
      1,
      1.059110,
      NULL,
      1.362023,
      0.912263,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.970341,
      NULL,
      0.999341,
      1.902681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      14,
      63.205351,
      NULL,
      1,
      0.816266,
      '11444',
      '',
      '',
      NULL,
      '44330',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


