set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1012112',
      3,
      0.784994,
      3,
      NULL,
      '0434',
      NULL,
      1.159294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.329311,
      1.583770,
      NULL,
      17.503793,
      3.085466,
      83.761943,
      112,
      3,
      ' 7-25-1992',
      ' 9-20-1996',
      ' 3-27-1991',
      0,
      3,
      3,
      0.399979,
      1,
      2,
      3,
      NULL,
      1,
      9,
      4,
      2.854595,
      2,
      2,
      10,
      5,
      3,
      0,
      4,
      4,
      1,
      1,
      NULL,
      1,
      1.118864,
      1.309540,
      NULL,
      0.585545,
      0.955621,
      0.579198,
      6.474393,
      9,
      4,
      2,
      1,
      2,
      0,
      3,
      3,
      4,
      NULL,
      2,
      4,
      4,
      2,
      2,
      0,
      9,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      1,
      1.388171,
      1,
      0.891193,
      2.877978,
      2,
      1.570104,
      NULL,
      3,
      NULL,
      1.174635,
      1,
      1,
      0.158316,
      1,
      0,
      5,
      3.141748,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      2,
      1,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      2,
      NULL,
      3,
      0,
      NULL,
      4,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      5,
      0,
      NULL,
      0,
      2,
      1.671292,
      NULL,
      ' 1- 5-1980',
      173,
      ' 0-24-1990',
      96,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      0.582564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      3.645511,
      1.241984,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2.814137,
      0,
      3.189444,
      2,
      NULL,
      4,
      0,
      1,
      7,
      1.260401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.281104,
      0,
      1,
      0,
      3.650203,
      6.519328,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.244206,
      0.176932,
      2,
      3,
      1,
      0,
      NULL,
      1,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.980051,
      1.318921,
      0.519286,
      1,
      1.743807,
      0.938598,
      1,
      1.315943,
      0,
      NULL,
      NULL,
      1,
      2.016919,
      NULL,
      1.415475,
      3,
      4,
      7,
      7.723510,
      9,
      7.238629,
      4.294459,
      NULL,
      3.308035,
      2,
      3.539006,
      2.600597,
      NULL,
      0,
      2,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194363,
      '20230',
      '',
      '',
      1,
      '20411',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      32.714164,
      15.440300,
      30.348719,
      0.732505,
      NULL,
      7,
      11,
      3,
      1.473148,
      1,
      3.866058,
      NULL,
      NULL,
      NULL,
      0.878230,
      NULL,
      NULL,
      1.264424,
      NULL,
      0.141543,
      0.157123,
      NULL,
      2.578799,
      1,
      NULL,
      NULL,
      2.115805,
      1.257299,
      3.540524,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.949227,
      NULL,
      NULL,
      8,
      4,
      5,
      1,
      3,
      NULL,
      NULL,
      1.929025,
      1.543563,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900491,
      NULL,
      1.648675,
      NULL,
      NULL,
      3,
      0,
      1.237964,
      3.238963,
      2,
      1.727035,
      0.860142,
      1,
      0,
      1.362658,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      1.323298,
      1,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1.207904,
      NULL,
      NULL,
      4,
      4,
      3,
      3,
      0,
      1.786587,
      0,
      2.653075,
      0.698932,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.157745,
      1,
      0,
      0,
      NULL,
      NULL,
      6.829417,
      1,
      1.173809,
      1.627965,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624397,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683691,
      NULL,
      NULL,
      0,
      3,
      2.981007,
      2,
      NULL,
      1,
      8.272109,
      5,
      3.044125,
      4,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1,
      1.644946,
      1.864070,
      1.677905,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.955005,
      9.514819,
      NULL,
      3.823866,
      3.021885,
      0.011911,
      NULL,
      NULL,
      1.803323,
      3,
      3.874489,
      1,
      2.324209,
      3,
      3.491426,
      3.381525,
      2,
      3.966420,
      4,
      NULL,
      1,
      4,
      NULL,
      1.457711,
      1,
      0.729952,
      0,
      0,
      3,
      NULL,
      4.344795,
      1,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619135,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.849578,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.785425,
      0,
      NULL,
      0.557084,
      0.224210,
      NULL,
      1.482311,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.745301,
      NULL,
      8,
      2.028778,
      NULL,
      1.232265,
      NULL,
      0.768640,
      0,
      1,
      NULL,
      2.157709,
      1.855792,
      NULL,
      NULL,
      0.487101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.223028,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.556255,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.025849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.258969,
      NULL,
      NULL,
      NULL,
      0.798326,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.598490,
      NULL,
      NULL,
      NULL,
      3.981211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070582,
      NULL,
      NULL,
      NULL,
      1.112421,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1.788233,
      NULL,
      NULL,
      NULL,
      3.065586,
      47,
      9,
      0.616551,
      NULL,
      NULL,
      1.856218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1.697935,
      NULL,
      3,
      5.305166,
      0,
      160,
      NULL,
      0.103361,
      0.488502,
      0,
      1.958029,
      0,
      1,
      NULL,
      0,
      0,
      1.240686,
      0.574449,
      1,
      1,
      0,
      0.213391,
      1.339508,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.435287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085538,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806995,
      1.306194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.797682,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.209546,
      NULL,
      1,
      NULL,
      1.872113,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.336036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.799362,
      NULL,
      1,
      NULL,
      0.060373,
      NULL,
      NULL,
      NULL,
      1.741734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.619106,
      2.003461,
      3,
      3,
      0,
      NULL,
      0.847519,
      0.368427,
      0.045145,
      1.139201,
      NULL,
      NULL,
      1,
      0.619342,
      NULL,
      1.605521,
      0.509825,
      NULL,
      NULL,
      0,
      NULL,
      0.007844,
      NULL,
      NULL,
      0,
      0.702135,
      NULL,
      NULL,
      3.272610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.759330,
      1,
      NULL,
      1,
      0.496346,
      NULL,
      3.964703,
      1.417005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      6,
      NULL,
      1.898636,
      NULL,
      NULL,
      NULL,
      26,
      3,
      NULL,
      2,
      NULL,
      '',
      NULL,
      0.360141,
      '04342',
      '',
      '',
      1.536431,
      '',
      '',
      '');
commit;
end;
/


