set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0.620677,
      0.816884,
      1,
      3,
      '3111',
      2.887654,
      1.857523,
      NULL,
      NULL,
      NULL,
      7.293777,
      NULL,
      NULL,
      0,
      1.524254,
      ' 4-13-1982',
      11,
      1,
      320.394862,
      101,
      4,
      NULL,
      NULL,
      ' 3-15-1984',
      2.088295,
      2.883488,
      1.694712,
      0.633380,
      0,
      NULL,
      0,
      NULL,
      0,
      521,
      1,
      19,
      10,
      155.926583,
      NULL,
      5,
      16.926368,
      4,
      NULL,
      NULL,
      0.947067,
      1,
      1,
      1,
      1.701217,
      NULL,
      1.835587,
      1,
      1.362113,
      0.321492,
      144,
      6,
      3,
      4,
      2.930312,
      3,
      1,
      5,
      3,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      0,
      1,
      6.840457,
      NULL,
      2,
      2,
      1,
      1.458495,
      NULL,
      NULL,
      2,
      2,
      2,
      1,
      0,
      0,
      1.710006,
      1.715446,
      0.106935,
      0,
      0,
      1.783231,
      1.541657,
      NULL,
      1,
      0.126078,
      1.042855,
      0,
      1.083840,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.210205,
      1,
      NULL,
      NULL,
      0.947813,
      NULL,
      0,
      0,
      2,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0.225578,
      NULL,
      1,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      4,
      1,
      5,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      2,
      4,
      5,
      2,
      1,
      2,
      0,
      6.144425,
      NULL,
      NULL,
      117.906557,
      NULL,
      818.014097,
      1.988771,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      1,
      1,
      4,
      NULL,
      0.222089,
      NULL,
      3,
      19,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934494,
      1,
      1.023576,
      NULL,
      8,
      2,
      1.304660,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.535309,
      1,
      NULL,
      3,
      0.200773,
      NULL,
      NULL,
      NULL,
      1944,
      0.299646,
      0,
      1,
      3.836682,
      NULL,
      NULL,
      0.788846,
      NULL,
      1,
      0.729782,
      3,
      15093.400370,
      NULL,
      2,
      194,
      99,
      433.930804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '11213',
      '43240',
      '23320',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      52,
      9,
      1.955158,
      38.831354,
      10.591559,
      19.633120,
      NULL,
      1.949154,
      NULL,
      NULL,
      0.823993,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.009096,
      0,
      1.277174,
      0,
      NULL,
      NULL,
      1.856665,
      NULL,
      NULL,
      1.629883,
      1,
      1.355473,
      1,
      NULL,
      NULL,
      1.168058,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.797930,
      2,
      1,
      3,
      1.634776,
      3,
      2.768309,
      2,
      1.894455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.819943,
      2.369863,
      1.660096,
      NULL,
      0.498147,
      0,
      0.304523,
      NULL,
      NULL,
      1.540652,
      1.164379,
      0.517062,
      NULL,
      0.356085,
      0.406186,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1.384071,
      NULL,
      0.331449,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.810451,
      0,
      6.078818,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      1.678953,
      1,
      1.341673,
      1,
      NULL,
      NULL,
      4.529822,
      1.044783,
      2,
      3.056636,
      0,
      1.629036,
      1.092520,
      NULL,
      NULL,
      0.134321,
      0.832522,
      0,
      1.720520,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.211604,
      NULL,
      NULL,
      1.043027,
      NULL,
      NULL,
      0.535387,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.458357,
      5,
      3.617798,
      NULL,
      NULL,
      0.680967,
      0.302395,
      3.989549,
      0,
      NULL,
      0,
      3.107643,
      1.631566,
      0,
      9.412359,
      NULL,
      4.862567,
      3,
      0.870501,
      NULL,
      3,
      3,
      0,
      2.162187,
      0,
      1.891387,
      3.339314,
      2,
      2.085641,
      1.130178,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.096431,
      NULL,
      3,
      0.332635,
      1,
      NULL,
      1.151723,
      0.647561,
      1.066165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.642978,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.741083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.736923,
      NULL,
      NULL,
      0.443803,
      NULL,
      NULL,
      NULL,
      2,
      2.820570,
      1.204899,
      1.912184,
      1.241132,
      0.208461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.267022,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      2.396110,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      209.822989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      99,
      1,
      1705,
      NULL,
      1.520402,
      NULL,
      1.237776,
      1,
      1.233522,
      NULL,
      1,
      2.505842,
      1,
      1,
      1.228471,
      1.737921,
      0,
      NULL,
      1.165415,
      1.797739,
      0,
      NULL,
      NULL,
      0.015503,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      85.483938,
      NULL,
      0.717664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.277945,
      1,
      2.268116,
      3.186166,
      0,
      1.499286,
      1,
      NULL,
      NULL,
      0.723301,
      12.908479,
      NULL,
      1.903548,
      2.625726,
      NULL,
      1.262516,
      16,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.011980,
      NULL,
      0,
      5,
      NULL,
      1,
      2.944651,
      NULL,
      NULL,
      9,
      NULL,
      0.980326,
      16.881839,
      NULL,
      1.199324,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.884623,
      NULL,
      1.452761,
      NULL,
      0,
      6,
      4,
      2.850069,
      NULL,
      3,
      NULL,
      0,
      2,
      0.778479,
      NULL,
      '32430',
      NULL,
      '02233',
      0.282940,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


