set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      1.882348,
      NULL,
      1,
      3,
      '2114',
      1.820862,
      1.447497,
      NULL,
      NULL,
      ' 4- 6-1980',
      22,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      3,
      47.805806,
      102,
      2,
      ' 1-15-1986',
      ' 0- 5-2001',
      ' 7-28-1975',
      0,
      1,
      3.893512,
      1.344271,
      NULL,
      NULL,
      NULL,
      0.340656,
      0,
      40,
      NULL,
      5,
      1.183138,
      35.366882,
      5.393815,
      5,
      23,
      NULL,
      2,
      1.109006,
      1.013911,
      1,
      1,
      1.719353,
      NULL,
      NULL,
      1.542572,
      0.393347,
      NULL,
      1.298742,
      0.886431,
      3,
      2,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      NULL,
      3,
      0,
      0,
      0,
      1,
      1,
      6.782588,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1.577397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.442243,
      0,
      1,
      0.804793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      5.440567,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.229791,
      4,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      2,
      3,
      2,
      3,
      5,
      3,
      NULL,
      0,
      5,
      1,
      ' 1- 3-1993',
      146.969380,
      ' 5-11-2001',
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      5,
      1,
      1,
      0,
      4.047727,
      1.188233,
      3,
      1.432903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.727448,
      1,
      0.817158,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.548293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.177592,
      0,
      0.473189,
      1,
      0,
      0.625105,
      3.998652,
      3,
      2.234602,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      2,
      1,
      1,
      3,
      3,
      NULL,
      3.998214,
      NULL,
      NULL,
      1.014887,
      1.730849,
      1.550612,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.441464,
      1.761051,
      0,
      1,
      0.875086,
      1,
      4.927230,
      10.563449,
      4.303275,
      8.046756,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      31,
      23,
      6,
      5,
      0.562441,
      5,
      NULL,
      '32433',
      '32134',
      1.910114,
      '',
      '',
      '',
      1.806492,
      NULL,
      '',
      '',
      NULL,
      NULL,
      15.507286,
      NULL,
      2,
      35.166566,
      7,
      3.135301,
      3,
      2.079756,
      NULL,
      3.063915,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.489821,
      3.511580,
      NULL,
      2.575009,
      NULL,
      1,
      1.790850,
      0,
      NULL,
      2.521584,
      1.885518,
      2.748256,
      NULL,
      1.048733,
      NULL,
      2,
      0.437938,
      1,
      1.762037,
      1.640128,
      0.600616,
      3,
      NULL,
      1.790133,
      NULL,
      NULL,
      2,
      6,
      3.523118,
      0,
      0,
      NULL,
      1.800112,
      2.563541,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.113199,
      3.660129,
      1,
      1.406178,
      1,
      NULL,
      NULL,
      NULL,
      1.387908,
      1,
      0,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.605101,
      2,
      1,
      0.273685,
      1.248764,
      NULL,
      0,
      3.662947,
      NULL,
      NULL,
      NULL,
      2.280011,
      2.333908,
      0.857586,
      2.165282,
      NULL,
      4,
      3,
      0.789974,
      NULL,
      1.838776,
      NULL,
      1.427947,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.673967,
      0,
      0.515331,
      1,
      0.065562,
      1.464992,
      NULL,
      NULL,
      0.286534,
      NULL,
      1.454205,
      2,
      NULL,
      1.043052,
      NULL,
      1.498006,
      0.442562,
      NULL,
      9.216028,
      0,
      1,
      NULL,
      NULL,
      1.087222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.921207,
      NULL,
      NULL,
      6,
      0.914158,
      1.588361,
      2,
      2,
      1.941925,
      NULL,
      1.903590,
      NULL,
      2,
      0.542035,
      2,
      5,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.542850,
      0.197332,
      1,
      1,
      NULL,
      2,
      NULL,
      3,
      1,
      8.472879,
      NULL,
      2,
      3,
      2,
      0,
      2,
      2,
      2,
      NULL,
      3,
      NULL,
      NULL,
      2.025971,
      2.494402,
      NULL,
      3,
      1,
      NULL,
      NULL,
      88.289918,
      NULL,
      2.860078,
      2,
      NULL,
      1.317984,
      1.592371,
      NULL,
      0.280631,
      0,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2.996566,
      NULL,
      NULL,
      0,
      2.942952,
      NULL,
      1,
      1.258249,
      NULL,
      0,
      1,
      NULL,
      3,
      2.139331,
      NULL,
      1,
      1,
      NULL,
      15,
      2,
      NULL,
      2,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.052488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.107827,
      NULL,
      NULL,
      NULL,
      0.119630,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.621603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      34.643075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079061,
      NULL,
      NULL,
      3.235605,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559074,
      NULL,
      NULL,
      13480,
      NULL,
      3.542367,
      1.985119,
      0,
      0.530413,
      NULL,
      1.869090,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      1.707354,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3.223621,
      NULL,
      9,
      NULL,
      NULL,
      1.451775,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.625961,
      NULL,
      0.470274,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.193013,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.825274,
      NULL,
      0,
      NULL,
      0.362498,
      0,
      0.922735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504194,
      3.982481,
      NULL,
      0.541056,
      NULL,
      498,
      NULL,
      3.333761,
      NULL,
      3.140744,
      NULL,
      NULL,
      NULL,
      2.496191,
      0,
      NULL,
      NULL,
      0.497916,
      0,
      0,
      NULL,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      4,
      0,
      14.665367,
      1,
      0,
      NULL,
      3.642459,
      0.505596,
      NULL,
      3.898947,
      0,
      NULL,
      2.056224,
      1.363183,
      NULL,
      1,
      2.142728,
      NULL,
      0.856046,
      0,
      NULL,
      2.768042,
      0,
      NULL,
      2,
      1.093789,
      NULL,
      2,
      3.339335,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.126172,
      NULL,
      0,
      2.270062,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      3.504920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817133,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.274021,
      NULL,
      0.621302,
      NULL,
      NULL,
      NULL,
      3.261589,
      NULL,
      NULL,
      NULL,
      160,
      NULL,
      812,
      3.871086,
      2.437331,
      NULL,
      NULL,
      NULL,
      1.217365,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.212326,
      NULL,
      1,
      NULL,
      2.235399,
      NULL,
      0.136565,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      470.580555,
      1.974464,
      NULL,
      0.711185,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.915573,
      NULL,
      89,
      0,
      0.805129,
      NULL,
      '32410',
      '13404',
      '00021',
      NULL,
      '30204',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


