set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      2.721918,
      1.450051,
      NULL,
      3,
      '0334',
      3.991274,
      0,
      NULL,
      NULL,
      '11-23-2001',
      25,
      NULL,
      2,
      3.400034,
      2.961886,
      ' 7- 7-2003',
      NULL,
      2,
      54,
      82,
      3,
      ' 6- 4-1985',
      '10- 8-1984',
      ' 2- 6-1981',
      0.091259,
      0.896660,
      1.888548,
      NULL,
      1,
      0,
      1,
      0,
      0.174148,
      10.680205,
      7,
      12,
      NULL,
      190,
      100,
      1,
      5.362427,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0.694924,
      0.307550,
      0.191880,
      NULL,
      0.968047,
      0,
      1.909220,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      5,
      1,
      4,
      5,
      2,
      NULL,
      4,
      5,
      NULL,
      7.633719,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      2,
      3,
      0,
      2,
      2,
      0,
      3.480172,
      NULL,
      1,
      1,
      1,
      NULL,
      2.029039,
      2.050091,
      0,
      0.259134,
      0.354513,
      NULL,
      1,
      0.983017,
      2.616728,
      0.332006,
      0,
      4,
      0,
      NULL,
      8,
      0,
      NULL,
      0.531625,
      2.952063,
      2.353218,
      2,
      NULL,
      1,
      2,
      1,
      4,
      NULL,
      0,
      3,
      1,
      2,
      0,
      0,
      0,
      5,
      0,
      1,
      6.614564,
      NULL,
      NULL,
      NULL,
      0,
      1.262878,
      NULL,
      1.914893,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4,
      4,
      1,
      NULL,
      2,
      0,
      5,
      0,
      3,
      NULL,
      3,
      3,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4,
      3.840844,
      1,
      0,
      2,
      5,
      NULL,
      3,
      0,
      0,
      1,
      0,
      NULL,
      2,
      4,
      1,
      NULL,
      3,
      NULL,
      0,
      11.398543,
      3.555166,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      3,
      19,
      763.663031,
      1.091244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.716503,
      2.966693,
      0,
      NULL,
      NULL,
      6,
      5.636794,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.122630,
      1,
      1,
      1.444550,
      1,
      NULL,
      1.495354,
      3.164012,
      8,
      0.983748,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.813632,
      1,
      3,
      3,
      2,
      0,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      11.395586,
      NULL,
      3.589537,
      0,
      1,
      5.090003,
      0.420968,
      0,
      NULL,
      0,
      NULL,
      1.213342,
      NULL,
      1.816154,
      1,
      17,
      NULL,
      1.096411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.888157,
      NULL,
      10,
      11,
      5,
      4,
      1.048211,
      NULL,
      '30421',
      NULL,
      '22224',
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.395797,
      36.708413,
      53.730207,
      44.604127,
      1.518638,
      8,
      0,
      NULL,
      3,
      2.724204,
      NULL,
      3.537577,
      2.746192,
      1.649479,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.042678,
      2.798796,
      2,
      2.999369,
      3.630354,
      2,
      3.073747,
      2.627810,
      1,
      2.955648,
      1,
      2.014106,
      NULL,
      2,
      1,
      3,
      2.082607,
      0.648050,
      0,
      1.906764,
      3.978915,
      2,
      0.039014,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      3.335174,
      NULL,
      0,
      0.480033,
      2.608857,
      1,
      2.800580,
      1,
      0,
      NULL,
      NULL,
      0.584619,
      0.578850,
      1,
      NULL,
      NULL,
      0,
      0.648541,
      0.749548,
      3.635303,
      0,
      0.813869,
      NULL,
      3.689926,
      1.154593,
      0,
      1,
      1.834142,
      1.938667,
      0.188954,
      1.415739,
      0.309608,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.265146,
      1.648912,
      11.893211,
      3,
      4.129975,
      1,
      NULL,
      3.007500,
      1,
      2,
      0.113113,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.398559,
      0.701443,
      1.557702,
      0.447517,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.871202,
      0.274019,
      2,
      1.189182,
      3,
      1.154726,
      3,
      1,
      NULL,
      8.593358,
      3.272502,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.634704,
      2.122575,
      1,
      3.062855,
      7,
      0.307310,
      7,
      4.850877,
      NULL,
      2.736907,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      3,
      2,
      NULL,
      1,
      0,
      9,
      NULL,
      4.704623,
      NULL,
      0.932657,
      3,
      1,
      2,
      2.030304,
      1.977553,
      NULL,
      0.214283,
      0.248858,
      NULL,
      3.075181,
      2.361082,
      5.562622,
      3.833664,
      3.323376,
      NULL,
      6,
      NULL,
      2,
      1,
      3.615761,
      1,
      1.856469,
      NULL,
      NULL,
      3.414833,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.576587,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.552865,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.402784,
      NULL,
      1.521627,
      0.082832,
      NULL,
      0.623026,
      1.487594,
      NULL,
      2.263427,
      NULL,
      NULL,
      1.066063,
      9,
      NULL,
      13,
      4,
      NULL,
      3,
      0,
      1.095332,
      0.208737,
      1.689741,
      3,
      0.102895,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289467,
      NULL,
      NULL,
      NULL,
      0,
      0.117698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.586164,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.890890,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.858763,
      0.630760,
      NULL,
      NULL,
      2,
      1.050552,
      NULL,
      NULL,
      1.359069,
      3,
      NULL,
      NULL,
      3.517376,
      0.804112,
      NULL,
      NULL,
      3.289570,
      1,
      NULL,
      NULL,
      9,
      5,
      NULL,
      NULL,
      1.157545,
      NULL,
      NULL,
      NULL,
      NULL,
      6.785265,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      17.143423,
      NULL,
      1.073408,
      NULL,
      NULL,
      1.913209,
      NULL,
      1.938614,
      NULL,
      1200.161985,
      3.346016,
      1,
      2,
      NULL,
      2.831996,
      0,
      NULL,
      NULL,
      0.089724,
      0.262737,
      0.898066,
      0.196257,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.843692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.510598,
      NULL,
      125.513039,
      NULL,
      3,
      NULL,
      30,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.736011,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.464515,
      NULL,
      0.104399,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.404969,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399864,
      1.615404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078093,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750062,
      1,
      NULL,
      1.801742,
      NULL,
      1.749778,
      NULL,
      NULL,
      NULL,
      1,
      1.763290,
      0,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      32,
      NULL,
      0.198735,
      0.642340,
      0.627102,
      NULL,
      3,
      NULL,
      2,
      5.175546,
      1,
      5,
      NULL,
      1,
      NULL,
      2,
      1.426154,
      2,
      NULL,
      NULL,
      1.391639,
      19.326497,
      6.956218,
      1,
      6.990219,
      15.388033,
      0,
      2.473937,
      4,
      1,
      12,
      NULL,
      3,
      19.463514,
      10,
      1,
      1.593314,
      NULL,
      1.985528,
      0,
      NULL,
      3.986809,
      0,
      6,
      0.570716,
      0,
      17,
      1.236105,
      NULL,
      18.443278,
      0.871359,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.831671,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.552831,
      NULL,
      0.301027,
      NULL,
      1.781530,
      NULL,
      3.587522,
      NULL,
      NULL,
      NULL,
      0.051421,
      NULL,
      0,
      NULL,
      NULL,
      696,
      2,
      17,
      NULL,
      NULL,
      2,
      NULL,
      1.331153,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.557799,
      NULL,
      0.190890,
      NULL,
      1.331061,
      NULL,
      1,
      NULL,
      3.665628,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      123,
      0.925915,
      872.271561,
      1,
      1.850653,
      1.410319,
      0.253030,
      0,
      2,
      3,
      5,
      NULL,
      1.639133,
      NULL,
      NULL,
      NULL,
      99,
      0,
      NULL,
      7.889839,
      NULL,
      NULL,
      '33300',
      1,
      '',
      '',
      '',
      1.106955,
      '',
      '',
      '');
commit;
end;
/


