set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      0.219814,
      NULL,
      0,
      '1013',
      1,
      0.339169,
      NULL,
      NULL,
      '11-21-1983',
      18,
      NULL,
      0,
      2.885753,
      2,
      ' 6-24-1982',
      13,
      0.722430,
      57,
      116.141907,
      NULL,
      '10-23-1984',
      '11-12-2001',
      ' 6- 1-1999',
      2,
      3.926019,
      2,
      1,
      1,
      1.915028,
      1,
      0,
      1.944275,
      163.375604,
      4,
      5,
      2,
      37,
      29,
      1,
      17,
      2,
      NULL,
      4.350687,
      1.403021,
      1,
      1,
      1,
      0.858878,
      1.241859,
      0.649677,
      NULL,
      0.032945,
      3,
      1.386123,
      1,
      2,
      7,
      3,
      0,
      0,
      NULL,
      3,
      1,
      3,
      3,
      4,
      3,
      4,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.492436,
      1.709846,
      0,
      2,
      2.439027,
      NULL,
      NULL,
      1,
      1.200259,
      NULL,
      NULL,
      5,
      1,
      2,
      8,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      3,
      1,
      1,
      5,
      NULL,
      2,
      1,
      2,
      4,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      3,
      5,
      1,
      4,
      1,
      NULL,
      5,
      NULL,
      0,
      5,
      0,
      5,
      5,
      1,
      3,
      3,
      4,
      5,
      4,
      2,
      0,
      7.664886,
      0.872941,
      ' 9-25-1976',
      NULL,
      ' 0-15-1982',
      117.001996,
      1.514403,
      0,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      4,
      1,
      2,
      NULL,
      4,
      1,
      6,
      NULL,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      5.657438,
      6,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.663465,
      NULL,
      1,
      1.633119,
      0,
      0,
      2.925369,
      NULL,
      NULL,
      0.282916,
      NULL,
      NULL,
      NULL,
      0,
      0.705265,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      3,
      3,
      3,
      0,
      2.813841,
      3,
      3,
      0.777011,
      1.303193,
      0.193443,
      0,
      0,
      NULL,
      0.705161,
      1.063137,
      0.418320,
      0,
      0.504287,
      1,
      1.388458,
      1.563026,
      1,
      0,
      NULL,
      5.774135,
      2.480016,
      11.833883,
      1,
      0.458262,
      2,
      1.807685,
      2.240264,
      1.943497,
      3.348450,
      56.042371,
      0,
      2.446471,
      NULL,
      31,
      31,
      10.864486,
      0,
      0.755571,
      4,
      '00404',
      NULL,
      '00223',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.144608,
      28.167818,
      117,
      16,
      3,
      17.412834,
      7,
      1,
      3,
      3,
      0,
      1.595020,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.855405,
      1.312316,
      3.263970,
      2,
      NULL,
      3,
      NULL,
      2.899368,
      NULL,
      3.838585,
      3,
      NULL,
      NULL,
      2.954402,
      1.769451,
      3,
      2.745580,
      3,
      0,
      NULL,
      1.664915,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.520338,
      4.254000,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.235079,
      0,
      3.881885,
      NULL,
      3.875894,
      0,
      0.641491,
      NULL,
      NULL,
      1.683989,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.989465,
      1,
      0.568837,
      1,
      NULL,
      2.457309,
      0,
      1.167831,
      1.587208,
      0.149288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.746440,
      NULL,
      NULL,
      1.147088,
      2,
      2,
      1.695803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.485022,
      1,
      2.313329,
      NULL,
      1,
      1.010763,
      NULL,
      NULL,
      NULL,
      11,
      0,
      NULL,
      0.448015,
      0,
      1.839245,
      2.722979,
      1.360944,
      1,
      2.579929,
      1,
      0.393437,
      NULL,
      NULL,
      1.494144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.709816,
      1,
      0.913324,
      3,
      1,
      0.938188,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.053935,
      0,
      2.135211,
      0.912693,
      1.292213,
      NULL,
      5.549530,
      NULL,
      3,
      0.621795,
      0,
      0,
      0.778408,
      0,
      3.774593,
      1.509758,
      3.880358,
      3.582824,
      1.674611,
      3.960588,
      1.744245,
      NULL,
      4,
      0,
      0,
      3.472566,
      2.561689,
      0,
      1,
      NULL,
      3.195767,
      NULL,
      1,
      1.386194,
      0.128371,
      NULL,
      6,
      1.118209,
      NULL,
      27.417749,
      163,
      NULL,
      2.977444,
      0.004384,
      NULL,
      1,
      1,
      NULL,
      0,
      1.878875,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.402343,
      NULL,
      3.645049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.138032,
      0.967200,
      NULL,
      2,
      3,
      NULL,
      NULL,
      10.260561,
      NULL,
      NULL,
      1,
      1.580301,
      0.306628,
      1,
      1,
      1.213182,
      0.415814,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.855303,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.875130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.480669,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.258312,
      NULL,
      NULL,
      NULL,
      3.563454,
      NULL,
      NULL,
      NULL,
      0.432507,
      NULL,
      NULL,
      NULL,
      0.124859,
      NULL,
      NULL,
      NULL,
      4.644711,
      NULL,
      NULL,
      NULL,
      0.822543,
      NULL,
      NULL,
      NULL,
      1.504742,
      0,
      0.990641,
      1.494580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.625112,
      NULL,
      NULL,
      3,
      10.612822,
      NULL,
      0.551433,
      NULL,
      NULL,
      0,
      NULL,
      1.656090,
      NULL,
      72,
      3,
      0.130420,
      1,
      1.765587,
      0.771268,
      NULL,
      0,
      NULL,
      3.002838,
      0,
      NULL,
      1.529664,
      1,
      0,
      NULL,
      1,
      0,
      1.188820,
      3.367696,
      NULL,
      0.608938,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      251,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.432197,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.935979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.246116,
      NULL,
      NULL,
      NULL,
      0.005249,
      NULL,
      1.972223,
      NULL,
      1,
      NULL,
      2.640739,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742152,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095283,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852474,
      1.999413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.044142,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      956.414105,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      1.749356,
      19.577779,
      NULL,
      2,
      3.087276,
      0,
      NULL,
      3,
      1,
      NULL,
      7,
      5,
      NULL,
      2,
      3,
      19.341952,
      3.727143,
      NULL,
      0,
      2.621439,
      0.097109,
      NULL,
      NULL,
      2,
      NULL,
      2.778747,
      3,
      NULL,
      NULL,
      1.524504,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.400525,
      NULL,
      NULL,
      3.515002,
      2,
      NULL,
      1.629029,
      1.788457,
      NULL,
      1.222337,
      0.243000,
      NULL,
      0,
      0.253224,
      NULL,
      0.472127,
      0.500937,
      3.411320,
      2.060290,
      NULL,
      0,
      NULL,
      2.397885,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.482512,
      NULL,
      1,
      NULL,
      1.348407,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.450555,
      NULL,
      0.746250,
      NULL,
      29.232901,
      1,
      NULL,
      0.392330,
      3.058334,
      NULL,
      0,
      NULL,
      1.192089,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.264094,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1646.183441,
      1,
      NULL,
      0,
      NULL,
      1.428574,
      NULL,
      3,
      4,
      NULL,
      3,
      1.498808,
      NULL,
      67,
      NULL,
      1,
      1,
      3.120169,
      '43041',
      NULL,
      NULL,
      0,
      '02244',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL);
commit;
end;
/


