set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0012023',
      3.659600,
      0,
      3,
      3,
      '0302',
      0,
      0.340039,
      NULL,
      NULL,
      '10- 6-1987',
      32.403356,
      NULL,
      0,
      2.565847,
      1,
      ' 2-25-1994',
      NULL,
      0.814478,
      196,
      NULL,
      3,
      '10-22-1975',
      ' 7- 0-1984',
      '10-19-1975',
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      1,
      0,
      0,
      190.246701,
      NULL,
      7,
      NULL,
      5.923119,
      18,
      NULL,
      6.354599,
      5,
      3,
      4,
      2.886933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      6,
      1.951502,
      2,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      5,
      2,
      5,
      0,
      2,
      11,
      0,
      NULL,
      1,
      2,
      1.277123,
      NULL,
      NULL,
      1.865662,
      NULL,
      NULL,
      1,
      5,
      2.847246,
      NULL,
      0,
      0.431125,
      0,
      NULL,
      0.915515,
      1.436885,
      1.004990,
      1,
      1,
      2,
      1,
      NULL,
      3,
      0,
      2.327748,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      1.832815,
      NULL,
      NULL,
      1.916710,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      1,
      0,
      2,
      5,
      0,
      NULL,
      3,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      3,
      NULL,
      5,
      NULL,
      1,
      NULL,
      2,
      5,
      3,
      NULL,
      1,
      NULL,
      2.195101,
      NULL,
      ' 8-24-1979',
      659.044994,
      ' 4-29-1986',
      280,
      2,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.489917,
      0,
      0.370368,
      0.059539,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.437882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.562910,
      0,
      1,
      0.705223,
      NULL,
      0,
      NULL,
      1.885596,
      0.158666,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      2,
      3,
      0,
      1,
      3,
      NULL,
      1,
      3,
      2,
      3,
      1,
      1.091832,
      NULL,
      2,
      1,
      1,
      0,
      1.820210,
      1,
      0.858025,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      2.823995,
      0.405944,
      10.212795,
      6,
      5,
      NULL,
      8.324924,
      2,
      0,
      0.242654,
      1.814568,
      1,
      0.557604,
      1,
      22.064862,
      2,
      2,
      NULL,
      27,
      42,
      18,
      3,
      NULL,
      2.872458,
      '10244',
      '30131',
      '14132',
      0,
      '',
      '',
      '',
      0.833204,
      '',
      NULL,
      NULL,
      NULL,
      7,
      107.738984,
      0,
      NULL,
      53.620491,
      11.924371,
      3,
      NULL,
      2.952816,
      3,
      2.729641,
      2,
      NULL,
      1.082122,
      1.599373,
      NULL,
      NULL,
      1.846252,
      1,
      3,
      0.171085,
      1.835460,
      3,
      0,
      2,
      0.707778,
      2.025802,
      0.842259,
      1,
      3,
      0,
      NULL,
      NULL,
      0.489654,
      2.848395,
      3.481588,
      3.193076,
      0,
      3,
      2,
      3.694771,
      1,
      1,
      3,
      9,
      1,
      2.733867,
      1,
      3.976636,
      1.834460,
      1,
      NULL,
      0.970366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.034830,
      0.712753,
      1,
      1,
      2,
      NULL,
      NULL,
      3,
      1.863297,
      NULL,
      3,
      1,
      3,
      1,
      0,
      3,
      2.370096,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.760297,
      NULL,
      3,
      8,
      2.964321,
      0,
      NULL,
      NULL,
      0,
      0.732957,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.559529,
      3.923612,
      2.297020,
      1.507114,
      NULL,
      NULL,
      NULL,
      0.538295,
      1.035477,
      NULL,
      NULL,
      4,
      11,
      1.642353,
      NULL,
      3,
      3,
      1.583760,
      3,
      2.483646,
      0,
      7.405204,
      1,
      0.909745,
      NULL,
      NULL,
      1.791050,
      NULL,
      NULL,
      0.006969,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.590070,
      NULL,
      NULL,
      1.061895,
      NULL,
      NULL,
      0.980077,
      NULL,
      0,
      3,
      2.211828,
      1,
      6,
      1.617581,
      4.095620,
      2,
      NULL,
      1,
      0.580528,
      5.150663,
      4.002228,
      3,
      0.981001,
      NULL,
      1.258171,
      3,
      3,
      0,
      2,
      NULL,
      1,
      0.243275,
      2.497083,
      NULL,
      2.920699,
      0,
      1.459378,
      0,
      NULL,
      3,
      2,
      2,
      0,
      2.428302,
      NULL,
      10,
      3.640453,
      7.056290,
      NULL,
      3.640383,
      2.159823,
      3,
      NULL,
      1,
      3,
      3.409499,
      1.522870,
      NULL,
      0.822752,
      1,
      NULL,
      6,
      2,
      NULL,
      0,
      157,
      NULL,
      2.101162,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.824141,
      1,
      NULL,
      1.132160,
      3,
      NULL,
      2.399212,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.448766,
      NULL,
      0,
      0,
      NULL,
      0,
      2.781040,
      NULL,
      3,
      3.951362,
      NULL,
      NULL,
      0,
      NULL,
      9,
      15.047109,
      NULL,
      0,
      0,
      0,
      0,
      1.582879,
      1,
      1,
      1.838707,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.847175,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.988630,
      NULL,
      NULL,
      NULL,
      1.271304,
      NULL,
      NULL,
      NULL,
      0.030042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231611,
      NULL,
      NULL,
      NULL,
      1.138457,
      NULL,
      NULL,
      NULL,
      0.779392,
      NULL,
      NULL,
      NULL,
      2.602291,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.446032,
      NULL,
      NULL,
      NULL,
      2.337657,
      NULL,
      NULL,
      NULL,
      1.193802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      13.072987,
      NULL,
      1,
      NULL,
      NULL,
      1.451297,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.684077,
      NULL,
      NULL,
      1.510276,
      NULL,
      NULL,
      1009.516980,
      9.228593,
      0.690656,
      0,
      1,
      2,
      1,
      0.189551,
      0,
      0.549049,
      0,
      0,
      0.013931,
      0.530815,
      1.772344,
      NULL,
      0,
      NULL,
      1.800008,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.784513,
      NULL,
      1.053293,
      NULL,
      NULL,
      NULL,
      0,
      20,
      41.250223,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433114,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.397616,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.917998,
      NULL,
      1.619400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.506519,
      NULL,
      NULL,
      1,
      0,
      0.506320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418028,
      1.925506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.622193,
      NULL,
      2.660166,
      NULL,
      3.257077,
      0,
      NULL,
      10.577531,
      NULL,
      1.651822,
      2,
      0.072547,
      NULL,
      2,
      2,
      0,
      0.152103,
      6.813328,
      NULL,
      NULL,
      1,
      16.335532,
      NULL,
      NULL,
      0,
      1.340316,
      1,
      NULL,
      2.312381,
      NULL,
      NULL,
      1.928948,
      3,
      NULL,
      2.829697,
      2,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      2.121854,
      NULL,
      1.610951,
      2.665995,
      NULL,
      NULL,
      0.925584,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.589171,
      0.815971,
      1.974263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741406,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0.472928,
      0,
      13.166939,
      69,
      4,
      1,
      5.783661,
      '00103',
      '13204',
      '11243',
      3.028506,
      '13423',
      '',
      NULL,
      1.611051,
      NULL,
      '',
      '');
commit;
end;
/


