set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3243344',
      3,
      NULL,
      NULL,
      2,
      '0031',
      2.453659,
      NULL,
      NULL,
      NULL,
      NULL,
      46.792581,
      NULL,
      3,
      1.919317,
      0.894885,
      '11- 9-2000',
      62.399718,
      5,
      160,
      NULL,
      2,
      NULL,
      ' 2-18-1975',
      ' 1-13-1977',
      3,
      2,
      1,
      3.077763,
      0,
      1,
      NULL,
      0.545084,
      0,
      7.201353,
      6,
      4.130781,
      9.622534,
      5,
      8.723656,
      0,
      11.518385,
      2,
      NULL,
      9.107223,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.379602,
      1.312797,
      NULL,
      NULL,
      1,
      NULL,
      3.100537,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      4,
      2,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      5,
      NULL,
      2,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.054100,
      1,
      NULL,
      0,
      1,
      1,
      0.667346,
      3.127971,
      0,
      3,
      5,
      0,
      3,
      2,
      2,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      5,
      2,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      4,
      5,
      5,
      1,
      1,
      1,
      ' 4-26-1982',
      1974.226500,
      '11- 9-1986',
      20,
      3.784579,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      1.802323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.503791,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.219640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1.494724,
      1,
      3,
      NULL,
      0.383078,
      0.246654,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.169533,
      0,
      3,
      0,
      3,
      NULL,
      2,
      NULL,
      3,
      3,
      2,
      2.953511,
      2.769790,
      1,
      NULL,
      1.459449,
      0.980834,
      NULL,
      NULL,
      1.426341,
      2.296172,
      1,
      0.295190,
      0,
      NULL,
      NULL,
      1,
      0.894074,
      NULL,
      0,
      NULL,
      4,
      2.681284,
      NULL,
      NULL,
      3,
      NULL,
      2.158174,
      7.921881,
      0.147932,
      0.968123,
      1.707615,
      NULL,
      0,
      3.308887,
      NULL,
      5,
      44,
      41,
      4,
      5.405495,
      1.507173,
      '3412',
      '03114',
      '',
      NULL,
      '',
      '',
      '',
      1.426211,
      '0003',
      '',
      NULL,
      3,
      26,
      340.815911,
      54.371959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      1.736688,
      NULL,
      NULL,
      NULL,
      1.924597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.180077,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.763893,
      3.749809,
      NULL,
      2.034563,
      NULL,
      0,
      1.680720,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968895,
      NULL,
      NULL,
      0.979534,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058221,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539531,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.121999,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      4,
      1.093820,
      NULL,
      1,
      NULL,
      NULL,
      1.250173,
      NULL,
      NULL,
      1.064938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.496213,
      NULL,
      NULL,
      0.431410,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.849128,
      NULL,
      NULL,
      3.452803,
      1,
      1,
      0.583605,
      1.324141,
      0,
      1.072065,
      NULL,
      NULL,
      NULL,
      0.519746,
      3.354202,
      2,
      NULL,
      NULL,
      0,
      1.699025,
      1,
      NULL,
      1.271201,
      1.388785,
      1,
      NULL,
      NULL,
      0,
      0.959531,
      NULL,
      NULL,
      0,
      0,
      1.193135,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212727,
      NULL,
      NULL,
      2.423283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.593586,
      NULL,
      NULL,
      1.768041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.404016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.767599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901627,
      0,
      1,
      2.879554,
      0.069824,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.444303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487070,
      0.341461,
      NULL,
      NULL,
      1,
      1.639365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.170295,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.793305,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.449154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.407180,
      NULL,
      NULL,
      0,
      NULL,
      1,
      167.376318,
      1,
      0.513383,
      0,
      1,
      0,
      NULL,
      1.668181,
      NULL,
      1.273596,
      0,
      1,
      NULL,
      0.838037,
      1,
      0,
      0,
      0,
      0.972956,
      1.994472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      2,
      2.194578,
      1,
      5,
      0,
      3,
      NULL,
      0,
      NULL,
      1.743273,
      0,
      0.450248,
      0,
      1,
      1,
      0,
      1,
      0.989740,
      0,
      0.219108,
      0,
      3,
      NULL,
      0.668037,
      2.920622,
      3.601382,
      NULL,
      3.945683,
      0,
      1,
      0,
      1.434009,
      NULL,
      3,
      1,
      1.979677,
      2.093917,
      1.721707,
      0,
      0,
      2.658903,
      1.210252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238852,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0.670879,
      14.524853,
      0,
      3,
      3.433561,
      '2123',
      '04330',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      '',
      NULL);
commit;
end;
/


