set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3041121',
      2.942348,
      0.190084,
      5,
      0,
      '1400',
      NULL,
      1.558120,
      NULL,
      NULL,
      ' 4-10-1979',
      5.553487,
      NULL,
      2,
      NULL,
      1.720417,
      NULL,
      12,
      0.912923,
      NULL,
      41,
      NULL,
      ' 5- 1-1994',
      ' 1- 5-2000',
      ' 0-25-2002',
      0,
      3.257751,
      0,
      1,
      0.058748,
      NULL,
      0,
      0.868350,
      1.305064,
      1,
      NULL,
      NULL,
      1.671660,
      NULL,
      17,
      1,
      16.734424,
      2,
      2,
      3,
      1.390539,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.633344,
      1,
      0.578362,
      0,
      2,
      0,
      5,
      NULL,
      0,
      1,
      0,
      1,
      0,
      2,
      3,
      3,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.818683,
      NULL,
      NULL,
      1,
      0,
      0.111499,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      2,
      5,
      1,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.200588,
      0,
      NULL,
      0,
      2,
      1,
      3,
      2,
      NULL,
      0,
      5,
      1,
      0,
      5,
      0,
      2,
      1,
      3,
      3,
      5,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.526266,
      2.922644,
      ' 8- 2-2001',
      113,
      ' 0- 1-1979',
      205,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      0,
      0.343525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039617,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.378755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.203912,
      0.589664,
      NULL,
      NULL,
      NULL,
      0.198268,
      1.380806,
      27.061740,
      NULL,
      0.418168,
      99.685896,
      471.779086,
      454.514780,
      2,
      NULL,
      0.640778,
      1,
      3,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      1.316969,
      NULL,
      0,
      1,
      0,
      0,
      0,
      3.567264,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      49,
      50,
      NULL,
      5,
      0.911176,
      NULL,
      '04241',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      6.355223,
      67,
      1.580275,
      3,
      NULL,
      NULL,
      3,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      3,
      0,
      NULL,
      NULL,
      3.396727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.807847,
      3.838858,
      0,
      0.583326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      8,
      NULL,
      1,
      0.307339,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853192,
      3,
      0.068825,
      1.318067,
      NULL,
      NULL,
      0,
      NULL,
      1.297597,
      NULL,
      4,
      0.672103,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727892,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.248728,
      9,
      NULL,
      1,
      NULL,
      0.315749,
      NULL,
      NULL,
      NULL,
      0.874835,
      2,
      1.062276,
      0.445766,
      NULL,
      NULL,
      1.809346,
      NULL,
      NULL,
      0.547639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.165717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0.881132,
      0.153573,
      3,
      0,
      5,
      NULL,
      2,
      NULL,
      0.969883,
      5,
      1,
      NULL,
      NULL,
      0.373682,
      0,
      0,
      NULL,
      NULL,
      1.106244,
      3,
      0,
      NULL,
      6,
      NULL,
      3.092846,
      0,
      2,
      1.533786,
      0.436757,
      NULL,
      NULL,
      3.571645,
      1,
      1.572769,
      2.262127,
      2.290692,
      0.787075,
      2,
      7.565534,
      7.044421,
      5.004640,
      1,
      0.656463,
      0.085502,
      0,
      4,
      NULL,
      0,
      0,
      1,
      0.779505,
      2.892247,
      NULL,
      NULL,
      1.209260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172961,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.071073,
      NULL,
      0.801386,
      0.318422,
      1.328994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.416672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514028,
      NULL,
      NULL,
      NULL,
      1.013357,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.712430,
      NULL,
      NULL,
      NULL,
      9.500978,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.650928,
      NULL,
      1.634343,
      NULL,
      NULL,
      0.365731,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.844137,
      NULL,
      NULL,
      0.420938,
      NULL,
      NULL,
      1.450599,
      NULL,
      1,
      312,
      1658,
      1,
      NULL,
      1.229456,
      1.604029,
      1.561768,
      0.862744,
      0,
      NULL,
      1.766151,
      NULL,
      1.159183,
      1,
      1.651337,
      0.456600,
      NULL,
      NULL,
      1.474765,
      1.970034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487976,
      1.950838,
      1.203310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.155056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.541312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.742201,
      0,
      0.256010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.514708,
      3.777930,
      3,
      4,
      2,
      10.308189,
      3,
      2.309007,
      0,
      0.772362,
      0,
      0,
      1.342738,
      1.067729,
      0,
      0,
      1.379757,
      0.389323,
      0.510406,
      19,
      NULL,
      1.112445,
      0,
      0,
      1.066724,
      2,
      3.211951,
      1.323376,
      1,
      1.016811,
      1,
      3.760441,
      1,
      1.321273,
      0.176145,
      0.817159,
      1,
      3,
      0.582987,
      1.764340,
      3.950518,
      1.237656,
      1.059237,
      3.793022,
      0.260386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749339,
      1.414976,
      NULL,
      0.204972,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      5.139100,
      89,
      1,
      0.971915,
      0,
      '42001',
      '',
      '',
      0.143779,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


