set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1123024',
      1.469454,
      NULL,
      0,
      0,
      '1432',
      NULL,
      0.136893,
      NULL,
      NULL,
      NULL,
      46.382622,
      NULL,
      4,
      0,
      0,
      ' 5-10-1990',
      12,
      3,
      288,
      14,
      NULL,
      '11- 0-2002',
      ' 5- 3-1977',
      ' 3- 5-1984',
      NULL,
      2,
      2,
      0.926676,
      0,
      0.610124,
      3,
      0.943687,
      1,
      13,
      7,
      9,
      1,
      1.415386,
      53.233194,
      4,
      22.850019,
      2,
      3,
      7.194085,
      1,
      1,
      0,
      0.109035,
      0.759714,
      0,
      NULL,
      NULL,
      0,
      0.852708,
      1.925467,
      0,
      NULL,
      NULL,
      2.750253,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      1,
      5,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      2,
      1.050739,
      NULL,
      NULL,
      1.237954,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2.747044,
      0,
      NULL,
      0.916691,
      0.779355,
      NULL,
      NULL,
      0.883424,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      4,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.830761,
      1,
      0,
      0,
      NULL,
      1,
      3,
      4,
      0,
      1,
      NULL,
      0,
      0,
      5,
      0,
      2,
      4,
      1,
      3,
      0,
      5,
      NULL,
      5,
      2,
      1,
      0,
      0,
      1.280307,
      ' 6-13-1979',
      173.618589,
      ' 2-17-1986',
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1.670099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.600420,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      1,
      6,
      1.879202,
      NULL,
      NULL,
      NULL,
      NULL,
      6.746984,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328991,
      0.510499,
      0.454612,
      1.977121,
      0,
      0.374005,
      1.423639,
      0.556722,
      15.247929,
      0.538985,
      0,
      15.735407,
      0.736318,
      0.947180,
      NULL,
      1.858627,
      0.563349,
      3,
      0,
      0,
      0,
      2,
      1,
      2,
      3,
      3,
      3,
      4.352147,
      1.880161,
      3,
      1,
      0,
      0,
      NULL,
      0,
      0.386001,
      0.530139,
      0.001282,
      0.463249,
      1,
      1.901038,
      1.879634,
      1,
      0,
      1,
      0.795170,
      6.829182,
      NULL,
      4,
      11,
      NULL,
      2.975509,
      NULL,
      0.214644,
      4.788237,
      3,
      1.837772,
      0.281650,
      37.437017,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      2,
      1.557967,
      0,
      '21023',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      '',
      1,
      26.366655,
      43,
      25,
      1.382417,
      8.923771,
      1,
      3.529918,
      NULL,
      1.813081,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572695,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.977464,
      NULL,
      NULL,
      NULL,
      3,
      1.867679,
      2,
      2,
      0.913146,
      0.270555,
      3,
      NULL,
      0.668519,
      1,
      1,
      2.498779,
      NULL,
      0,
      3,
      2,
      1,
      1.483476,
      NULL,
      NULL,
      NULL,
      11,
      3,
      1,
      1.034797,
      NULL,
      NULL,
      NULL,
      0.793021,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.732801,
      NULL,
      NULL,
      0.915068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.836860,
      NULL,
      NULL,
      2,
      1.161422,
      1,
      3,
      0.559209,
      NULL,
      0,
      NULL,
      1,
      0.693836,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.202744,
      1,
      1.306794,
      NULL,
      NULL,
      2.439163,
      NULL,
      NULL,
      2.903289,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.945319,
      5,
      0,
      0,
      NULL,
      NULL,
      1.470242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      5,
      NULL,
      1.153108,
      NULL,
      3,
      0.350122,
      NULL,
      NULL,
      2.141341,
      5,
      0.389101,
      NULL,
      9.277434,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      3.258509,
      2.779660,
      3,
      0.163654,
      NULL,
      1.711850,
      NULL,
      2.666146,
      9,
      3.030261,
      2.067818,
      NULL,
      1.365708,
      0,
      1,
      1,
      1,
      0.606747,
      2.588416,
      1.505066,
      1.497384,
      2,
      0,
      0.376427,
      5.535033,
      NULL,
      0.862139,
      1,
      0.773352,
      NULL,
      NULL,
      0.899785,
      0.375181,
      NULL,
      0.852951,
      1.649906,
      2.777923,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998839,
      NULL,
      NULL,
      0.906463,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.002073,
      0.153578,
      1,
      0.931392,
      NULL,
      2.966772,
      0.136435,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.428934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.959751,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517893,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.310667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.728329,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.242368,
      183.047282,
      0.508352,
      0,
      1.688744,
      1.952228,
      NULL,
      1.990781,
      1.050974,
      0,
      1.947002,
      NULL,
      0.787971,
      1,
      1,
      0.985566,
      NULL,
      1.110022,
      NULL,
      NULL,
      0.458018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213357,
      1.069799,
      0.701962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.700364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.028894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675698,
      0.763135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548151,
      0.091091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.578993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.093452,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.769101,
      2.792689,
      NULL,
      1,
      0,
      NULL,
      1.361954,
      1,
      NULL,
      1.243823,
      NULL,
      NULL,
      NULL,
      0.542481,
      NULL,
      1,
      2.651569,
      NULL,
      NULL,
      1.798651,
      NULL,
      0.075383,
      3.165491,
      NULL,
      0.767200,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.216318,
      1,
      NULL,
      0.734711,
      2.883342,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.094116,
      NULL,
      0.803987,
      NULL,
      2,
      NULL,
      0.594679,
      NULL,
      3.858581,
      NULL,
      2.562176,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.105531,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.941232,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3.902810,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.854059,
      NULL,
      NULL,
      53.054846,
      49,
      5,
      1,
      1,
      NULL,
      '',
      '',
      1.838424,
      '',
      NULL,
      '',
      NULL,
      '11334',
      '',
      '');
commit;
end;
/


