set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3113010',
      2.264872,
      1.630796,
      NULL,
      NULL,
      NULL,
      0,
      1.782860,
      NULL,
      NULL,
      ' 8-16-1980',
      57.446156,
      NULL,
      2,
      1,
      5.445109,
      NULL,
      NULL,
      1.031166,
      277,
      NULL,
      0,
      ' 4-19-1999',
      ' 8- 4-1984',
      NULL,
      2,
      NULL,
      2,
      3.420627,
      NULL,
      2,
      2,
      0.375482,
      NULL,
      NULL,
      7,
      2,
      1.025343,
      36.751957,
      NULL,
      2,
      NULL,
      5,
      3,
      1.600534,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0.092692,
      1.238703,
      1.691036,
      0,
      1,
      0,
      3,
      0,
      0,
      1,
      2,
      NULL,
      5,
      0,
      2,
      5,
      1,
      5,
      0,
      NULL,
      1,
      0,
      0,
      2,
      0.121537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.726430,
      0.536180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      5.758022,
      NULL,
      NULL,
      NULL,
      1.375411,
      NULL,
      NULL,
      1.002376,
      NULL,
      NULL,
      1,
      4,
      0,
      3,
      5,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      2.730132,
      0,
      0,
      1,
      1,
      0,
      1.235056,
      2.781179,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      0,
      2,
      5,
      1,
      0,
      0,
      4,
      1,
      1,
      1,
      NULL,
      2,
      4,
      5,
      0,
      5,
      0,
      NULL,
      0,
      ' 2-23-1975',
      106.908457,
      ' 1-23-1977',
      150.220479,
      1.429610,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      4,
      0,
      1.120069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.386060,
      1,
      4,
      1,
      1,
      9,
      0.753028,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      43,
      0.504026,
      0.462457,
      29.294062,
      14.621095,
      6,
      2,
      1,
      1,
      0,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      2,
      2,
      0,
      0,
      NULL,
      0.000481,
      NULL,
      1.915902,
      NULL,
      0,
      1,
      1.695089,
      1.064857,
      1.533420,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.780245,
      7,
      9,
      0.200632,
      8,
      8,
      2,
      2.585150,
      0,
      7.755702,
      2,
      2,
      0.804125,
      28,
      1,
      3.812351,
      NULL,
      NULL,
      48,
      86,
      0,
      1,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.404780,
      '41230',
      '',
      '',
      2.971080,
      33.240329,
      6,
      17,
      2.072594,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476888,
      1.015440,
      0,
      1,
      NULL,
      NULL,
      0.301986,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      0.019540,
      1,
      0,
      3,
      1,
      NULL,
      1.344165,
      1.494241,
      NULL,
      3.770921,
      0,
      0,
      NULL,
      NULL,
      3.724742,
      NULL,
      0.025366,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055115,
      NULL,
      NULL,
      1.352820,
      NULL,
      NULL,
      0.411556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.289587,
      1.861689,
      1.988361,
      0.531599,
      2,
      1.749483,
      0,
      1,
      NULL,
      4.608661,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.428337,
      NULL,
      NULL,
      3.056200,
      0.888769,
      0,
      1.522439,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      5,
      1.362592,
      0.586726,
      1,
      0,
      1.530384,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1.148086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      0.368265,
      NULL,
      1,
      2.313600,
      2,
      3,
      0,
      NULL,
      NULL,
      1.680038,
      4.284517,
      4,
      9,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.922100,
      2,
      1,
      2,
      3.400078,
      0,
      2,
      1.951375,
      9.831702,
      2.059582,
      5,
      3,
      NULL,
      3,
      NULL,
      2.624626,
      1.090505,
      3.007984,
      1.369639,
      0,
      1,
      3.509398,
      3,
      7.766408,
      9.955381,
      2.658174,
      7,
      5.563771,
      4.417144,
      0.987229,
      1,
      0,
      1.915856,
      NULL,
      1,
      0.570872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.905829,
      NULL,
      NULL,
      0.347328,
      1.047611,
      1,
      1.077399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      29,
      24.999038,
      NULL,
      NULL,
      0,
      3.384754,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.876850,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717953,
      NULL,
      NULL,
      NULL,
      1,
      1.595252,
      NULL,
      NULL,
      0.728141,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.834019,
      NULL,
      NULL,
      1,
      1.690709,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.025859,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.744740,
      NULL,
      NULL,
      0.441380,
      2.821805,
      NULL,
      NULL,
      0,
      0.237348,
      NULL,
      NULL,
      8,
      4.851517,
      NULL,
      NULL,
      1.270067,
      NULL,
      NULL,
      NULL,
      2,
      42.897009,
      1.988861,
      1.309618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869239,
      NULL,
      NULL,
      1.938595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357072,
      NULL,
      NULL,
      128.209417,
      2.614556,
      NULL,
      NULL,
      1.257106,
      1.677934,
      0,
      0,
      0.059703,
      1.249537,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0.696824,
      0.591082,
      1.128308,
      1.476641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191562,
      0.894605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.596430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666995,
      0.824552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509539,
      0.584627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.135262,
      NULL,
      1.353223,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.515819,
      NULL,
      1,
      1,
      0.073394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.962658,
      6,
      1.469148,
      4.297945,
      1,
      3,
      1.944718,
      0,
      NULL,
      1,
      NULL,
      0.926205,
      0,
      1.368955,
      1.578023,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.719308,
      2,
      NULL,
      1,
      0,
      0.806459,
      3.476245,
      1.324422,
      2,
      3.145923,
      0.864318,
      NULL,
      NULL,
      1,
      1.854137,
      0,
      1.470849,
      2,
      1.945311,
      1.098952,
      3.493339,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483983,
      3.206300,
      3,
      1,
      NULL,
      2.971592,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      3.326739,
      NULL,
      NULL,
      2,
      2,
      1,
      2,
      0,
      1,
      1,
      3.030649,
      1.933831,
      NULL,
      1.425451,
      22.387878,
      0.342411,
      NULL,
      1.758709,
      0,
      2,
      3.437748,
      1.368818,
      0,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      83,
      7.228691,
      1,
      0,
      2.561532,
      '03031',
      '',
      '',
      1.011846,
      NULL,
      NULL,
      '',
      NULL,
      '12042',
      NULL,
      '');
commit;
end;
/


