set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6605896';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      6,
      22.184734,
      '1434110',
      1,
      1.516797,
      0,
      NULL,
      '4032',
      0.566562,
      NULL,
      NULL,
      NULL,
      ' 7-24-1993',
      66,
      11.871830,
      NULL,
      NULL,
      1.924776,
      ' 8-24-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 3- 4-1994',
      1.391723,
      0,
      2,
      0,
      0,
      0.377567,
      1,
      3,
      NULL,
      NULL,
      NULL,
      9.326945,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      2.054698,
      NULL,
      1.974161,
      0.385952,
      0.835199,
      0,
      0.862083,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.509683,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      0.362171,
      0.800190,
      1,
      NULL,
      0.685122,
      0,
      0,
      1.837966,
      0,
      NULL,
      1,
      0,
      NULL,
      3.424966,
      2,
      NULL,
      NULL,
      5,
      5.509625,
      NULL,
      5.423227,
      NULL,
      3.357950,
      NULL,
      53,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.867950,
      '41004',
      '',
      '',
      0.833629,
      NULL,
      '',
      '',
      2.682139,
      '10313',
      '',
      '',
      0,
      20.674123,
      NULL,
      20.400965,
      1.189421,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1.859280,
      NULL,
      NULL,
      1.899748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.119081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209699,
      1,
      1,
      0.934537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      6,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.014042,
      0,
      NULL,
      0,
      0.929658,
      0,
      1,
      0.242127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.849351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.650691,
      2,
      NULL,
      4,
      8,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.818767,
      0,
      3.330815,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.763863,
      1,
      0,
      NULL,
      NULL,
      5,
      3.331162,
      0,
      NULL,
      NULL,
      NULL,
      3.476817,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.718659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.606165,
      NULL,
      NULL,
      1.094036,
      NULL,
      NULL,
      1.058944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572731,
      NULL,
      NULL,
      NULL,
      2.763540,
      1,
      NULL,
      0.141498,
      0.761502,
      4,
      NULL,
      0.713539,
      0,
      2,
      0,
      2.060695,
      1.467613,
      NULL,
      0,
      NULL,
      NULL,
      2.446571,
      0,
      1,
      NULL,
      8.062023,
      0,
      2,
      7.227333,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.628718,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.110668,
      NULL,
      NULL,
      0.393195,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      3,
      1,
      0.131508,
      1,
      1.586828,
      2,
      NULL,
      1.430068,
      NULL,
      4,
      NULL,
      9.539461,
      NULL,
      3.860587,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.353755,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.642069,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.708393,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583354,
      NULL,
      1.949646,
      NULL,
      1,
      NULL,
      0.245505,
      NULL,
      NULL,
      NULL,
      0.013171,
      NULL,
      0.377833,
      NULL,
      1.207177,
      NULL,
      0.103747,
      NULL,
      3,
      NULL,
      2.996603,
      NULL,
      5.180319,
      NULL,
      10.109202,
      NULL,
      0.608339,
      2.371388,
      0.792417,
      4,
      1,
      0.238860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.617024,
      NULL,
      NULL,
      1.867823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      0,
      0,
      0.156073,
      1.506232,
      1.263845,
      1,
      1,
      0,
      0.714950,
      0.887050,
      NULL,
      0.069327,
      NULL,
      0.033588,
      1.780829,
      0.636262,
      1,
      1.049060,
      2.962288,
      NULL,
      0.036206,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.030878,
      NULL,
      11,
      NULL,
      2,
      10.903739,
      19,
      1,
      1.374336,
      NULL,
      NULL,
      1.811703,
      NULL,
      0,
      NULL,
      0.747963,
      NULL,
      1.459676,
      NULL,
      1,
      NULL,
      1.279522,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.772819,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.143576,
      1.232225,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812749,
      2.543214,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.524266,
      NULL,
      0.210774,
      NULL,
      3.594946,
      NULL,
      0.723306,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052080,
      1.047173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.085193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461289,
      1.266446,
      NULL,
      3,
      NULL,
      2,
      NULL,
      29.019834,
      NULL,
      2,
      NULL,
      0.668543,
      NULL,
      NULL,
      1,
      0,
      NULL,
      8,
      0.248675,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.105037,
      0,
      1.981748,
      2,
      14.020863,
      0.345052,
      1,
      1,
      0.450665,
      NULL,
      NULL,
      0,
      0,
      1.770609,
      0.082234,
      0,
      NULL,
      0,
      NULL,
      1.603215,
      0.929917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.826172,
      0,
      1.349231,
      0,
      0,
      0.468364,
      0.451951,
      0,
      0,
      1.144113,
      0.171325,
      0,
      NULL,
      NULL,
      0,
      0.849340,
      0.091936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018478,
      0.161555,
      1,
      0.213168,
      1.088311,
      NULL,
      1.127019,
      0.121134,
      0.329365,
      3.334898,
      1.483742,
      0.349871,
      1,
      1.662389,
      0,
      1,
      0.070929,
      NULL,
      1,
      1,
      0.868699,
      1.149405,
      0,
      0,
      0,
      1.453941,
      1,
      16.317996,
      3.697019,
      30,
      NULL,
      0.408487,
      1,
      1.806130,
      1,
      1,
      3,
      3,
      4,
      1,
      NULL,
      NULL,
      44,
      13.510913,
      0,
      3,
      NULL,
      '23422',
      '04412',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      '00410',
      NULL,
      '03024');
commit;
end;
/


