set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0403412',
      2.795506,
      1,
      2,
      3,
      '3013',
      0.849566,
      1,
      NULL,
      NULL,
      ' 3-13-1983',
      NULL,
      NULL,
      1,
      0.415166,
      0,
      ' 7- 3-1993',
      8,
      3,
      28.586307,
      62,
      NULL,
      ' 5- 1-1997',
      ' 9-11-1997',
      ' 4- 0-1974',
      NULL,
      0.961583,
      3,
      0,
      NULL,
      3,
      NULL,
      2.832012,
      NULL,
      NULL,
      NULL,
      0,
      5,
      21,
      NULL,
      5,
      2.256875,
      NULL,
      2,
      4.143363,
      1.389732,
      NULL,
      0,
      1.624248,
      0,
      1,
      1,
      3,
      1,
      0.583735,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053332,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1.550082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      3,
      3.980516,
      3.099102,
      3,
      1.720181,
      1,
      0.777267,
      NULL,
      2,
      0,
      3,
      1,
      2.644126,
      0,
      1,
      2,
      4,
      3,
      1,
      0.111863,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      0,
      5,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      2,
      5,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      3,
      4,
      4,
      3,
      3,
      9,
      NULL,
      NULL,
      NULL,
      ' 1-18-1994',
      289,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.057923,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.449562,
      0.818954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.525679,
      1.627837,
      1.970235,
      1,
      1.917071,
      0.389767,
      27,
      0.157210,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      0,
      0.152223,
      0,
      1,
      1.595495,
      1.455712,
      0,
      1.161607,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707195,
      0.399245,
      1.038531,
      2.615274,
      0.040705,
      2,
      2,
      1,
      0.973042,
      NULL,
      1.490925,
      5.399564,
      NULL,
      3.431094,
      NULL,
      12,
      3,
      3.329017,
      NULL,
      26,
      2,
      NULL,
      NULL,
      5.988031,
      0.325835,
      '20311',
      '',
      '',
      2.059434,
      '4340',
      '4241',
      NULL,
      0.534402,
      '',
      '',
      '',
      3.064377,
      11.849650,
      106,
      21,
      NULL,
      29,
      12.691587,
      18,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.620885,
      3.555235,
      2.058263,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363993,
      NULL,
      NULL,
      1.717241,
      7.729985,
      2.438291,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.106940,
      0,
      1,
      NULL,
      3,
      NULL,
      0.239884,
      2.736237,
      2,
      0.977409,
      0,
      3.115045,
      1.715556,
      3,
      1.098262,
      0,
      1.112415,
      1.253142,
      2,
      1.870093,
      1,
      2,
      NULL,
      3.705375,
      1.412479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.072496,
      1.591030,
      2,
      7,
      2.865900,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.855785,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.281999,
      1,
      1,
      NULL,
      NULL,
      6.657809,
      0,
      4,
      3,
      1.781062,
      NULL,
      0,
      NULL,
      NULL,
      4.645124,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.649178,
      NULL,
      7.412121,
      3,
      NULL,
      7,
      7,
      2.085051,
      3.643633,
      6,
      2.407924,
      2,
      NULL,
      3.593328,
      2,
      0.295366,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      9.020007,
      NULL,
      NULL,
      1.076746,
      NULL,
      2.006579,
      3.941428,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      9,
      9,
      3,
      2,
      NULL,
      6.556579,
      0.059569,
      3,
      1,
      0.151937,
      1,
      0,
      0.432168,
      NULL,
      2,
      NULL,
      NULL,
      1.191717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929364,
      NULL,
      NULL,
      0.205309,
      NULL,
      NULL,
      0.909738,
      NULL,
      NULL,
      1.087219,
      NULL,
      NULL,
      0.346226,
      NULL,
      NULL,
      0.665958,
      NULL,
      NULL,
      1.098624,
      NULL,
      NULL,
      1.909514,
      NULL,
      NULL,
      1.011696,
      NULL,
      1.701761,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      0.930231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747514,
      NULL,
      NULL,
      NULL,
      3.190709,
      NULL,
      NULL,
      NULL,
      0.333055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      8,
      2,
      0,
      1.713716,
      1.441535,
      NULL,
      NULL,
      3,
      5.041076,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10,
      1,
      0.302289,
      NULL,
      1.982934,
      1,
      1,
      NULL,
      0.309304,
      0,
      0.462852,
      0.371803,
      NULL,
      1,
      1.597771,
      1.841349,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      6.799576,
      1.067644,
      2.646554,
      0.585675,
      0,
      9,
      1.819292,
      1,
      1,
      1.387084,
      0.618115,
      NULL,
      0.005567,
      1.161000,
      NULL,
      1,
      2,
      NULL,
      0.285175,
      NULL,
      NULL,
      1.344818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.391437,
      0.848575,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.551779,
      NULL,
      0,
      1.035886,
      NULL,
      NULL,
      3.262469,
      NULL,
      NULL,
      0.897037,
      1.918151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      23.135843,
      58.394786,
      2,
      0.114239,
      0,
      NULL,
      '',
      '',
      1.806028,
      '3220',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


