set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '1304321',
      0,
      NULL,
      NULL,
      2,
      '0243',
      3,
      0.758771,
      NULL,
      NULL,
      ' 7-25-1998',
      37.433187,
      NULL,
      NULL,
      NULL,
      1.560473,
      NULL,
      NULL,
      1.991689,
      220.219748,
      61,
      3,
      ' 1- 1-1975',
      ' 3-28-2003',
      NULL,
      3.526989,
      1.124153,
      1.903789,
      3.235612,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      3,
      16.244984,
      2,
      2,
      3.683248,
      0,
      1,
      1,
      0,
      0.150378,
      NULL,
      NULL,
      1,
      NULL,
      1.636308,
      1.616565,
      4,
      1,
      2,
      1,
      4,
      NULL,
      1,
      0,
      0,
      1,
      3,
      2,
      0,
      1,
      1,
      NULL,
      2,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3.651468,
      0.056069,
      0,
      3.564399,
      NULL,
      1.742240,
      1,
      0,
      1,
      NULL,
      1,
      2.884608,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      7,
      1,
      1,
      1.991270,
      0.209985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      2,
      2,
      NULL,
      0,
      1,
      3,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      3,
      1,
      0,
      0,
      0,
      0,
      4,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1,
      5,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      ' 6-28-1995',
      NULL,
      '11-20-1997',
      34.685491,
      2,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0.603734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020207,
      0.607487,
      NULL,
      1,
      0,
      0,
      0.197943,
      NULL,
      NULL,
      NULL,
      1.670876,
      1.396959,
      0.753535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.694156,
      0,
      NULL,
      0.359441,
      0.759565,
      1,
      33,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      2,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1.511710,
      3.113293,
      2,
      0.226694,
      1.530420,
      3,
      0,
      0,
      1,
      0,
      1,
      0.710462,
      0,
      0.213663,
      NULL,
      9.809789,
      0,
      0.018489,
      0.247789,
      11.286382,
      4,
      1,
      2.223130,
      4,
      2,
      3.277356,
      2.655418,
      2,
      3.310778,
      NULL,
      17,
      0,
      1.315613,
      NULL,
      37,
      45,
      NULL,
      3,
      0.207314,
      4,
      '04442',
      '04040',
      '',
      1.076985,
      '',
      '',
      '',
      1.928004,
      NULL,
      '',
      '',
      0,
      NULL,
      34,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.422127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.753104,
      NULL,
      NULL,
      NULL,
      1.740708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      2.853292,
      1,
      0.366451,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.382732,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.679890,
      1,
      1.742118,
      1,
      0,
      0.825369,
      2,
      1,
      2.921593,
      2.092756,
      3,
      0,
      1,
      1,
      1.635843,
      1.547347,
      2,
      2,
      1,
      NULL,
      NULL,
      0.201363,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1.679692,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.474681,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      5.505426,
      NULL,
      NULL,
      3,
      1,
      0.097101,
      0.361086,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570026,
      NULL,
      NULL,
      1.038253,
      NULL,
      NULL,
      1.346791,
      NULL,
      NULL,
      1.596600,
      NULL,
      NULL,
      1.691864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807016,
      2.340178,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794449,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.931142,
      1,
      3.109382,
      NULL,
      NULL,
      NULL,
      3.090357,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.811002,
      2,
      2.538346,
      0.888506,
      0,
      2.834392,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      1.392479,
      1.287391,
      1,
      0.928532,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.815962,
      NULL,
      NULL,
      1,
      1,
      0.888436,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.544996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084960,
      0,
      NULL,
      NULL,
      1,
      0.917501,
      NULL,
      NULL,
      1.114658,
      0.538615,
      NULL,
      NULL,
      0.334853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.275891,
      NULL,
      NULL,
      NULL,
      1.167792,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.794102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167448,
      154.487926,
      NULL,
      1.851340,
      1,
      NULL,
      NULL,
      1.912918,
      1.353637,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.114613,
      0.088787,
      0,
      NULL,
      0.098031,
      3,
      1,
      0.395647,
      NULL,
      2.891271,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.113186,
      1.712744,
      NULL,
      1.888645,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.157283,
      NULL,
      1.307353,
      NULL,
      0.031492,
      NULL,
      1.615525,
      NULL,
      0.350080,
      NULL,
      0.748328,
      0.424599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217344,
      0.052029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900147,
      1.027639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.212436,
      2.797863,
      0,
      0,
      1,
      1.820207,
      NULL,
      NULL,
      1,
      1.445234,
      NULL,
      0.493615,
      0,
      1.283418,
      0.827646,
      0.074540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      1.403022,
      1,
      1.672726,
      NULL,
      NULL,
      3,
      2.707096,
      2,
      1,
      1.517250,
      NULL,
      NULL,
      1,
      3,
      3,
      0.928953,
      0.080135,
      0,
      0,
      1,
      0.691584,
      NULL,
      NULL,
      0.750890,
      1.291093,
      0,
      1.660049,
      1.442596,
      0.268106,
      2,
      1,
      1.164821,
      1.993373,
      NULL,
      0.735943,
      1.865751,
      0.664081,
      NULL,
      1.770582,
      1.075486,
      0,
      0,
      1.245955,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398437,
      0,
      1.505484,
      0.291236,
      0,
      4,
      2,
      2,
      2.579433,
      1,
      0,
      76.939610,
      46.843227,
      1,
      3.866125,
      4.588988,
      '00024',
      '11042',
      '',
      0.211461,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


