set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '03',
      NULL,
      11,
      NULL,
      1,
      0,
      NULL,
      3,
      '4212',
      4,
      0,
      NULL,
      NULL,
      ' 0-15-1995',
      91.001978,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-20-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1978',
      '11-18-2001',
      '10- 7-1974',
      1,
      0.113521,
      1.414809,
      0.254791,
      0.940690,
      3.706572,
      1,
      1.229851,
      0,
      10.379056,
      5,
      12.172527,
      11.725351,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.587086,
      NULL,
      0.280187,
      0.177544,
      1.253109,
      1,
      NULL,
      6,
      1,
      3,
      NULL,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      3,
      5,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.086285,
      NULL,
      NULL,
      0,
      0,
      4,
      2.702840,
      NULL,
      1,
      NULL,
      0.817454,
      1.837146,
      3,
      NULL,
      0,
      1.730026,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.541253,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.721301,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      2,
      0,
      0,
      0,
      1,
      2,
      0,
      0,
      0,
      2,
      2,
      4,
      0,
      0,
      4,
      0,
      2,
      0,
      1,
      1.290183,
      3,
      NULL,
      NULL,
      ' 6-28-1985',
      151,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190063,
      1,
      7,
      1.854038,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.609983,
      1.554087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.718619,
      1,
      1.467367,
      0.671126,
      NULL,
      6.381997,
      1,
      0.006227,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      2,
      2,
      3,
      NULL,
      3.561147,
      2.854466,
      NULL,
      1.197447,
      1.947405,
      5,
      0,
      0.982537,
      1.506708,
      1.887316,
      1,
      0,
      NULL,
      1,
      0,
      1,
      2,
      0,
      8,
      7,
      4,
      1,
      1.959400,
      NULL,
      3,
      NULL,
      5,
      2.851904,
      3.826895,
      1,
      19,
      0,
      NULL,
      8,
      NULL,
      50,
      58.326485,
      NULL,
      NULL,
      4.392296,
      '02034',
      '02443',
      '',
      0.310060,
      NULL,
      '',
      NULL,
      1.076446,
      '',
      '',
      '',
      2,
      45,
      28,
      4.157565,
      3,
      NULL,
      2.883486,
      0,
      5,
      NULL,
      1.596743,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.872616,
      NULL,
      NULL,
      1.058309,
      NULL,
      NULL,
      0.742680,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.098658,
      NULL,
      NULL,
      6,
      4.949044,
      4.312793,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.066809,
      NULL,
      NULL,
      NULL,
      3.548270,
      2,
      0,
      0.323262,
      NULL,
      NULL,
      3,
      3,
      3.330509,
      1.111285,
      1,
      1.775874,
      3,
      1.721738,
      1,
      3.837614,
      1.190377,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2,
      1.981174,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.535233,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.408460,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      1,
      0.329676,
      2,
      1,
      0.409293,
      NULL,
      NULL,
      5.497186,
      4,
      0,
      2,
      0,
      2.317059,
      0.848662,
      NULL,
      NULL,
      3.956506,
      2.113913,
      1.505304,
      0.018328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341459,
      NULL,
      NULL,
      0,
      NULL,
      2.954068,
      NULL,
      NULL,
      NULL,
      NULL,
      2.191273,
      NULL,
      1.004165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023317,
      2.570896,
      NULL,
      1.724125,
      0,
      NULL,
      6.314071,
      NULL,
      3,
      NULL,
      3,
      0,
      0.863115,
      2.115063,
      1.962505,
      1.186423,
      2.718920,
      3.166469,
      2.927483,
      1,
      0.176948,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      1.314386,
      3,
      3,
      1.614295,
      0.049615,
      1.307827,
      0,
      0.081065,
      NULL,
      NULL,
      NULL,
      1.263347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685869,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.626631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404772,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.989970,
      1,
      0.593873,
      0,
      3.733101,
      3.307616,
      NULL,
      NULL,
      0.300417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.005525,
      NULL,
      NULL,
      0.342152,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.164691,
      0,
      NULL,
      NULL,
      1.282447,
      1,
      NULL,
      NULL,
      1.790084,
      0.118644,
      NULL,
      NULL,
      3.595640,
      2.748334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      11,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.702277,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.616488,
      NULL,
      NULL,
      39,
      12,
      1.979644,
      0,
      1,
      1.095753,
      0.276683,
      0,
      0,
      1.486448,
      1.284030,
      1.318186,
      0.900402,
      1,
      NULL,
      0.150019,
      NULL,
      NULL,
      1,
      0.323551,
      NULL,
      0,
      NULL,
      0.316367,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.984629,
      NULL,
      95,
      NULL,
      0.829198,
      10.171101,
      39,
      3.736059,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.682943,
      NULL,
      1.948291,
      NULL,
      0,
      NULL,
      0.834465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613357,
      NULL,
      1.704355,
      NULL,
      1.064912,
      NULL,
      0.633052,
      NULL,
      0.064921,
      NULL,
      0,
      3,
      0,
      0.503382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.231824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808425,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.294960,
      NULL,
      0,
      0,
      0,
      NULL,
      1.653398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      NULL,
      1.460698,
      1.915796,
      3,
      3.604870,
      1,
      2.536048,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      0,
      1.649250,
      NULL,
      0,
      0.056681,
      0.828696,
      3.620319,
      1,
      1,
      1.432739,
      NULL,
      1.181429,
      0,
      NULL,
      1,
      1,
      0.733907,
      0.897461,
      1.205239,
      1.890558,
      1.916447,
      0,
      1.699360,
      1.527907,
      0.037725,
      1,
      0,
      NULL,
      2.562371,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888339,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0.467688,
      NULL,
      75,
      NULL,
      NULL,
      4,
      2.146499,
      '22324',
      '33210',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


