set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214550';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '11',
      42,
      34,
      '1422121',
      1.271071,
      0.083096,
      2,
      1,
      NULL,
      0,
      1.230393,
      NULL,
      NULL,
      NULL,
      29,
      19.026459,
      NULL,
      0.508998,
      1.302774,
      ' 9-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0-10-2001',
      ' 5- 6-1977',
      ' 1-20-1976',
      0.802529,
      0,
      3,
      0,
      NULL,
      0.649163,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.973991,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.220467,
      1,
      3,
      0,
      0.218296,
      1,
      2.153050,
      1.714848,
      0.754129,
      0,
      NULL,
      NULL,
      2,
      3,
      0.282072,
      2,
      1,
      1,
      5,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      1.758307,
      1,
      2,
      1,
      1,
      1,
      1,
      0,
      0.503565,
      NULL,
      0,
      1.353406,
      2,
      0.699228,
      1.293902,
      0,
      0.453701,
      1,
      1.487492,
      0.902076,
      0.606321,
      0,
      0.961593,
      NULL,
      0.520424,
      1,
      1,
      1,
      7,
      NULL,
      0,
      1.374841,
      NULL,
      1.306841,
      0.059627,
      NULL,
      1,
      1,
      3,
      4,
      2,
      3,
      0,
      NULL,
      3,
      NULL,
      2,
      1,
      1,
      3,
      0,
      2.201826,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      5,
      2,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      1,
      5,
      NULL,
      NULL,
      4,
      5.719674,
      1.053260,
      ' 8-19-2001',
      5,
      ' 6-26-1988',
      5.208061,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      1,
      3,
      2,
      3,
      5,
      3,
      0,
      2,
      NULL,
      2,
      0,
      6,
      1,
      ' 0-28-1993',
      3.627969,
      '11-14-2001',
      0,
      NULL,
      1,
      2,
      2,
      NULL,
      0,
      2.693784,
      2.929276,
      3,
      0,
      0,
      0,
      1,
      1.057019,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.052007,
      0,
      0,
      3,
      NULL,
      9.888882,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.763674,
      1,
      0,
      5,
      2,
      7.147203,
      '11-24-1982',
      3.613931,
      ' 6-11-1990',
      0,
      NULL,
      1,
      2.721814,
      1,
      1.790202,
      0.214341,
      0,
      1.161708,
      0,
      1,
      3,
      1.228019,
      NULL,
      1.849846,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      3,
      0,
      3,
      NULL,
      0,
      2,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      0,
      0.720949,
      0,
      2,
      NULL,
      0.748789,
      NULL,
      1,
      0.825133,
      NULL,
      NULL,
      3.881928,
      0,
      5,
      4,
      5,
      NULL,
      6.822219,
      5.103071,
      3,
      NULL,
      7.197913,
      NULL,
      2,
      1,
      NULL,
      0,
      2,
      38,
      NULL,
      37,
      30.969356,
      1,
      0,
      2.101349,
      '42223',
      '00101',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.866396,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526815,
      1.813470,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.898704,
      0,
      1,
      2.752071,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      765,
      NULL,
      3,
      1,
      2.625949,
      1,
      1,
      0,
      NULL,
      NULL,
      1.642894,
      NULL,
      NULL,
      1,
      0.286375,
      0.761900,
      1,
      1.106429,
      3,
      NULL,
      0.948677,
      NULL,
      3,
      NULL,
      0.675702,
      NULL,
      NULL,
      NULL,
      2.220647,
      NULL,
      51.772363,
      NULL,
      NULL,
      NULL,
      22.473791,
      NULL,
      0,
      0,
      NULL,
      0.630632,
      NULL,
      NULL,
      NULL,
      0.582952,
      NULL,
      0,
      NULL,
      1.689687,
      NULL,
      3.588685,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.684480,
      NULL,
      2,
      NULL,
      0.720657,
      NULL,
      1.634970,
      NULL,
      NULL,
      1,
      0.054289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267471,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.008007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.708496,
      1.794578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      4,
      3,
      3,
      NULL,
      2,
      2.813392,
      1,
      NULL,
      1.291581,
      0.286240,
      1.184055,
      NULL,
      0.685956,
      0.502075,
      NULL,
      1.304895,
      NULL,
      NULL,
      1.367697,
      1,
      NULL,
      1,
      0,
      NULL,
      0.228492,
      0,
      NULL,
      0.479722,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.668207,
      NULL,
      1.974882,
      NULL,
      NULL,
      3,
      0.461166,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.809768,
      NULL,
      0,
      NULL,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.190972,
      NULL,
      '22422',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


