set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8233883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3313213',
      NULL,
      NULL,
      2,
      3,
      NULL,
      3.666273,
      1,
      NULL,
      NULL,
      ' 6-24-1995',
      5,
      NULL,
      0,
      NULL,
      1,
      NULL,
      75,
      5.609657,
      36,
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 4-1984',
      0,
      0.666068,
      1,
      0,
      1.096713,
      1,
      0,
      1,
      0.999575,
      NULL,
      0,
      10,
      NULL,
      16,
      5.178683,
      3,
      27,
      NULL,
      NULL,
      3.536522,
      NULL,
      1,
      0,
      0.345690,
      1.920890,
      0.695887,
      0,
      0,
      0.650980,
      1.099163,
      0.235414,
      4,
      5,
      6,
      3.311509,
      3,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.524092,
      NULL,
      NULL,
      1,
      0,
      0.523316,
      0,
      1,
      0,
      0.854478,
      1.812575,
      0.821863,
      0,
      1.302677,
      NULL,
      1,
      0,
      0,
      0.260511,
      0.128027,
      0.945752,
      1,
      0,
      1,
      1,
      2.391888,
      0,
      1,
      NULL,
      0.829466,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      4,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.151330,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      4,
      NULL,
      2,
      0,
      4,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      5,
      5,
      5,
      4,
      4,
      5,
      0,
      3,
      4,
      3,
      4,
      8.513657,
      2.828376,
      ' 6-11-1996',
      231,
      NULL,
      1797,
      3.585939,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.260924,
      11.264159,
      1.462953,
      1.261630,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.627288,
      3.346455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.484014,
      1.158165,
      NULL,
      2,
      8974.616437,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.979080,
      '24402',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3,
      35.091284,
      148.840648,
      10.326350,
      NULL,
      NULL,
      19.928653,
      120,
      NULL,
      1,
      2.946375,
      2.981403,
      0,
      NULL,
      NULL,
      0.048283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.123212,
      2,
      NULL,
      0.406464,
      NULL,
      NULL,
      1,
      1.418076,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.549915,
      NULL,
      NULL,
      0.442163,
      NULL,
      NULL,
      0.409496,
      NULL,
      NULL,
      NULL,
      1.159243,
      2.053392,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.191211,
      NULL,
      NULL,
      NULL,
      0.825063,
      3.198922,
      0.612799,
      7,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1.662024,
      0.590917,
      0,
      NULL,
      1,
      1.968299,
      1.644893,
      1.913630,
      0,
      0,
      1,
      1,
      0.378153,
      NULL,
      0.788560,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      2.539884,
      3,
      1.082110,
      NULL,
      NULL,
      NULL,
      0.113379,
      NULL,
      NULL,
      NULL,
      1.727670,
      NULL,
      NULL,
      0,
      0,
      0.534999,
      1.497974,
      3,
      2,
      1,
      NULL,
      NULL,
      10.563667,
      7,
      0,
      3.465012,
      0.084861,
      NULL,
      NULL,
      NULL,
      NULL,
      5.902716,
      0.861934,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455937,
      NULL,
      NULL,
      2,
      1.896512,
      2.214691,
      0.307219,
      2.362845,
      NULL,
      5,
      5,
      0.871804,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.262891,
      3,
      NULL,
      NULL,
      0,
      3.558858,
      0,
      0.214120,
      3.701598,
      1,
      0,
      NULL,
      6,
      1,
      1.287150,
      NULL,
      NULL,
      1.387262,
      3.837877,
      3,
      1.519005,
      3.478271,
      2.519209,
      0,
      0,
      11.686478,
      5.667194,
      0,
      3.821464,
      NULL,
      3.581859,
      3,
      3,
      2,
      NULL,
      0.282049,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759485,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.458100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960226,
      NULL,
      NULL,
      1.433214,
      0.839959,
      NULL,
      1.808323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.823389,
      NULL,
      NULL,
      NULL,
      1.308833,
      NULL,
      NULL,
      NULL,
      1.889842,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.755875,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.353536,
      NULL,
      NULL,
      NULL,
      0.988486,
      475,
      539.076393,
      1.325420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808542,
      NULL,
      NULL,
      0.695754,
      1,
      0,
      6399,
      1,
      0.737982,
      0.246045,
      0,
      1.860407,
      1.660983,
      0.208525,
      0.320288,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.197436,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.314131,
      NULL,
      3,
      2,
      NULL,
      3.838371,
      NULL,
      0.250980,
      1.303812,
      0.800370,
      NULL,
      1.454578,
      NULL,
      NULL,
      1,
      0.890534,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.489050,
      1.950350,
      NULL,
      1.699459,
      1,
      NULL,
      0,
      1.994400,
      NULL,
      1.190206,
      0,
      NULL,
      NULL,
      1.403705,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860668,
      NULL,
      1.517432,
      NULL,
      1.096623,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      14.036732,
      20.115030,
      1,
      0,
      1,
      '10220',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


