set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912406';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3442201',
      0.905520,
      1.082685,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '11- 3-1986',
      1.499419,
      NULL,
      5,
      1,
      1.498593,
      ' 1- 8-2002',
      43,
      3,
      27,
      9.990377,
      NULL,
      '10- 9-1981',
      ' 5-27-1982',
      ' 8-13-1985',
      NULL,
      0,
      0.503824,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.860927,
      45,
      NULL,
      17,
      7,
      24.781596,
      22.708053,
      4,
      16,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      0,
      1,
      1.527609,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      3,
      1,
      2.178429,
      0,
      0,
      0,
      1,
      0,
      2,
      4,
      1,
      4,
      0,
      0,
      1,
      1,
      1,
      2,
      2,
      1,
      1.378854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      7,
      NULL,
      0,
      1.310738,
      1.474775,
      NULL,
      3.882691,
      0,
      3,
      1.031916,
      0,
      NULL,
      0.488793,
      3.642449,
      0,
      0.907954,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.458697,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1.245137,
      1,
      1,
      0,
      0,
      1.533344,
      NULL,
      1.112922,
      0,
      0,
      1,
      5,
      0,
      3,
      0,
      1,
      2,
      1,
      4,
      3,
      0,
      1,
      1,
      NULL,
      4,
      1,
      0,
      1,
      2,
      0,
      0,
      1,
      5,
      NULL,
      0.496105,
      '10-15-1997',
      NULL,
      ' 3-15-1997',
      21,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.873750,
      NULL,
      NULL,
      0,
      6.807814,
      0.395376,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.991537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260328,
      1.815762,
      0.964564,
      1.461173,
      1,
      0,
      0,
      0.923350,
      196.685640,
      1.371189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026306,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      14,
      2,
      40,
      NULL,
      180,
      105.763424,
      NULL,
      114,
      0.073857,
      1,
      1.390910,
      1,
      1.576669,
      1.657713,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      5.396599,
      NULL,
      2.342773,
      2.282514,
      NULL,
      3,
      0.262356,
      0.872063,
      3.637782,
      0,
      22.620435,
      2,
      3,
      NULL,
      NULL,
      31,
      NULL,
      0,
      NULL,
      NULL,
      '32234',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      5,
      NULL,
      1,
      4.643159,
      1,
      1.347827,
      NULL,
      2.476613,
      3.922267,
      1,
      NULL,
      NULL,
      NULL,
      1.139049,
      NULL,
      NULL,
      1.369719,
      NULL,
      NULL,
      0.092134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.319126,
      NULL,
      NULL,
      0.308859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.687944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.753754,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.595491,
      0.404174,
      NULL,
      NULL,
      NULL,
      0.051220,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873756,
      NULL,
      NULL,
      NULL,
      1.372601,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      1,
      0.857962,
      NULL,
      NULL,
      NULL,
      3.501570,
      0.477919,
      NULL,
      1.312635,
      0.314422,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.489544,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.127363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.592605,
      NULL,
      NULL,
      1.658378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.304973,
      NULL,
      3.811895,
      0.771585,
      NULL,
      NULL,
      4,
      2,
      8.593963,
      NULL,
      7,
      4,
      0,
      NULL,
      NULL,
      3,
      3.391675,
      1.751010,
      1,
      0.574261,
      0.469000,
      NULL,
      0,
      0,
      1.241658,
      3.639802,
      1,
      2.187202,
      3.256456,
      0.166400,
      0.956848,
      2,
      0.190053,
      NULL,
      3.202746,
      0,
      0.886291,
      NULL,
      2.422864,
      1,
      5,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.913717,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1.475978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.499541,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.752067,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2.183341,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.294791,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.989248,
      NULL,
      1.276332,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.745468,
      NULL,
      NULL,
      NULL,
      4.046483,
      NULL,
      0,
      NULL,
      0,
      0.461969,
      NULL,
      NULL,
      NULL,
      0.129059,
      0.448210,
      NULL,
      0,
      2,
      NULL,
      0.755430,
      NULL,
      NULL,
      0.283490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219216,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523102,
      48.835163,
      6,
      1.321934,
      1.530690,
      0.458113,
      0,
      0.707613,
      1.987880,
      0.963608,
      1.772360,
      1.586313,
      NULL,
      1,
      1.136863,
      NULL,
      0,
      1.893989,
      0.588376,
      0.457475,
      0.228261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      4.975662,
      1,
      0,
      2.321742,
      0,
      7.411445,
      2.892008,
      0.835633,
      2.899919,
      1.770331,
      0,
      1,
      1,
      0,
      1.041467,
      NULL,
      NULL,
      0.836425,
      0.287605,
      0.882258,
      0.454871,
      0,
      0.083506,
      NULL,
      NULL,
      0,
      3,
      0.630600,
      0,
      0,
      0.753472,
      1,
      0,
      0,
      1,
      1,
      NULL,
      3.601466,
      0.269162,
      1.538988,
      1,
      0.792659,
      3.424734,
      1,
      1.783450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.700082,
      0.810215,
      0.573658,
      0.221192,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      41.259601,
      NULL,
      0,
      NULL,
      '03030',
      '13401',
      '13140',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


