set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912406';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '4302401',
      2,
      1.682752,
      NULL,
      3,
      '3110',
      3.054400,
      1.006178,
      NULL,
      NULL,
      '10-16-1997',
      12,
      NULL,
      0,
      3,
      3,
      ' 3-16-1991',
      NULL,
      5,
      55.945949,
      NULL,
      1,
      ' 2- 3-1985',
      ' 5-25-1990',
      NULL,
      1,
      1.738059,
      0.673375,
      2,
      0,
      0,
      2,
      0.297916,
      0.767158,
      41,
      5,
      17.989293,
      11.436930,
      23.047729,
      18,
      3,
      18,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      1.175300,
      0,
      0.901194,
      NULL,
      0.526179,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      1,
      6,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1.685161,
      NULL,
      NULL,
      1,
      0,
      0.524045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0.993364,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      1,
      4,
      4,
      NULL,
      0,
      1,
      5,
      NULL,
      3,
      NULL,
      2,
      4,
      4,
      4,
      NULL,
      1,
      4,
      1,
      0,
      3,
      NULL,
      0.042833,
      3.243894,
      ' 0-13-1984',
      79.988740,
      ' 5-17-1999',
      13.128180,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.108682,
      1,
      0.156287,
      3,
      857.520097,
      3,
      NULL,
      NULL,
      3.267860,
      0,
      3,
      NULL,
      2.083040,
      3.316888,
      1.625708,
      NULL,
      3.908819,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.577419,
      0.869199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.088403,
      72,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.038248,
      3,
      0,
      1,
      2,
      2,
      NULL,
      3,
      2,
      2,
      1,
      2,
      0.392759,
      NULL,
      1,
      1.847037,
      1,
      3.184897,
      0,
      0.369437,
      1,
      0,
      0.637842,
      17.493983,
      199,
      NULL,
      NULL,
      1.165309,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.556735,
      NULL,
      13,
      35,
      54,
      NULL,
      1.738181,
      5,
      '14131',
      '04003',
      '',
      1,
      '',
      '',
      NULL,
      1.430690,
      NULL,
      NULL,
      '',
      NULL,
      13,
      1.393048,
      NULL,
      0.214442,
      32,
      0.710841,
      3.519364,
      0,
      NULL,
      0,
      0.201035,
      1.871584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.408868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290574,
      NULL,
      NULL,
      8.883666,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.385508,
      NULL,
      NULL,
      NULL,
      NULL,
      3.115203,
      1,
      1.615433,
      NULL,
      NULL,
      1.088705,
      NULL,
      NULL,
      NULL,
      0,
      1.847851,
      0,
      1,
      1,
      0.275518,
      3,
      1.038616,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.245530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.617717,
      2,
      1.005069,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.010137,
      2.250507,
      NULL,
      3.902957,
      0.981467,
      1,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1.453947,
      1.830588,
      NULL,
      NULL,
      0.606157,
      NULL,
      NULL,
      1.136260,
      NULL,
      NULL,
      1.079480,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.145227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.089842,
      0,
      3.825782,
      0,
      NULL,
      NULL,
      2,
      8,
      1.452475,
      6.216128,
      6,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.595846,
      NULL,
      0.381972,
      2.531151,
      NULL,
      1.682891,
      1.427249,
      8,
      5,
      6,
      3,
      0,
      NULL,
      13,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      8,
      7,
      NULL,
      1,
      6,
      2,
      1.601583,
      3,
      3,
      1.484860,
      0.776810,
      1.027808,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.317680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.154981,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.315170,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.932256,
      NULL,
      NULL,
      4.862307,
      NULL,
      NULL,
      0,
      0.370588,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      5.992999,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241048,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.009982,
      1.098596,
      NULL,
      NULL,
      0.637983,
      NULL,
      NULL,
      NULL,
      1.167936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051732,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458523,
      NULL,
      NULL,
      NULL,
      0.572020,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.734280,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.366791,
      26.309182,
      NULL,
      0.041494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852611,
      NULL,
      NULL,
      6216,
      0,
      0,
      0.558199,
      0.800160,
      NULL,
      1.378480,
      1.793446,
      1.475480,
      0.335829,
      1,
      1.052609,
      0.595280,
      1,
      0.738081,
      1.259044,
      0.024650,
      1.923158,
      0,
      1.245965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      5.729509,
      NULL,
      0.082428,
      3,
      NULL,
      9,
      2,
      1,
      3.316647,
      0,
      1.436475,
      1.409129,
      0.378721,
      0,
      0.540485,
      1,
      1.432252,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1.950659,
      NULL,
      0,
      0.677024,
      1,
      NULL,
      NULL,
      1,
      0.271632,
      1.201331,
      NULL,
      NULL,
      0,
      1,
      1.339114,
      0,
      0.191570,
      1.692202,
      NULL,
      2.970041,
      0,
      1.408981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384305,
      0,
      0,
      NULL,
      1.096297,
      1,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      48,
      114.883013,
      4,
      NULL,
      5,
      '42420',
      '42402',
      '41113',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


