set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912406';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      0.782283,
      6,
      2,
      '0422',
      NULL,
      0,
      NULL,
      NULL,
      ' 8- 8-1983',
      34,
      NULL,
      1,
      1,
      2.335653,
      '10-17-2001',
      16.305610,
      0.449375,
      88.650175,
      NULL,
      0,
      ' 0-19-1979',
      '11- 9-1977',
      ' 0- 0-2001',
      2.263007,
      0,
      2,
      1,
      NULL,
      NULL,
      2,
      0.981639,
      NULL,
      4,
      NULL,
      0.215751,
      0.926697,
      NULL,
      NULL,
      3,
      20.747823,
      NULL,
      1,
      2.898277,
      0.006346,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1.870842,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      2,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      0,
      7.428381,
      1,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.434844,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0.692516,
      1,
      0,
      2.651378,
      NULL,
      1.502815,
      NULL,
      1,
      0,
      0.981769,
      NULL,
      0.156127,
      0.142464,
      1,
      1,
      1,
      2,
      1,
      0,
      NULL,
      1.298251,
      0.208316,
      NULL,
      NULL,
      1.539186,
      NULL,
      NULL,
      1,
      4,
      3,
      0,
      3,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0.477531,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      0,
      NULL,
      5,
      5,
      2,
      0,
      4,
      1,
      0,
      1,
      5,
      2,
      3,
      4,
      2,
      2,
      0,
      5,
      0,
      0,
      2,
      2,
      ' 5-27-1996',
      NULL,
      NULL,
      17.927749,
      3.913785,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      4,
      0,
      0.042853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.209891,
      2,
      2.216765,
      1628.194701,
      3,
      0.996358,
      3.947255,
      1,
      2,
      NULL,
      7,
      NULL,
      3.686412,
      NULL,
      0,
      1.624596,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963225,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939320,
      1.592962,
      0,
      1.702451,
      0,
      NULL,
      2.566642,
      7.222798,
      0,
      0.765425,
      NULL,
      NULL,
      NULL,
      2,
      0.661088,
      2,
      1,
      3,
      1,
      1,
      3,
      1,
      1,
      1,
      0,
      3,
      1,
      1.923252,
      0,
      3,
      0.509808,
      0.236289,
      0.619191,
      1,
      0.210468,
      1,
      1.470048,
      0.404165,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      5,
      5.680327,
      1,
      8.426878,
      8.972825,
      2,
      5,
      0.907367,
      6.960559,
      2,
      NULL,
      3.601699,
      NULL,
      2,
      3.454172,
      NULL,
      4,
      30,
      77.088461,
      NULL,
      0,
      0.734987,
      '43333',
      '30440',
      '',
      1.826135,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.814569,
      5,
      NULL,
      NULL,
      1.852055,
      3,
      NULL,
      NULL,
      NULL,
      3,
      2.138355,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.036358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.479317,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.825252,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.456125,
      0,
      NULL,
      NULL,
      1,
      2,
      0.619390,
      0,
      NULL,
      NULL,
      0.064760,
      NULL,
      NULL,
      0.874397,
      1.436538,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.939405,
      2.831736,
      1,
      0.460062,
      0,
      0.428413,
      1.324418,
      0.383334,
      1.422444,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.817125,
      NULL,
      0.572880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.162052,
      0.132245,
      2.993077,
      NULL,
      1,
      NULL,
      3,
      0.039297,
      2,
      2.336666,
      0,
      0.523701,
      NULL,
      NULL,
      7,
      3.529068,
      1.403640,
      0.482861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.378685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397794,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662901,
      NULL,
      NULL,
      NULL,
      3,
      3.550518,
      1.753268,
      NULL,
      NULL,
      7.491501,
      6,
      4,
      1.252147,
      1,
      1.323313,
      0,
      NULL,
      NULL,
      2.464034,
      0.376905,
      NULL,
      3,
      1,
      NULL,
      1.345931,
      NULL,
      NULL,
      NULL,
      0,
      7,
      3.866780,
      0,
      1.772450,
      3,
      3.044926,
      1.027802,
      0.909255,
      0.481156,
      3,
      1,
      3,
      3,
      8.765905,
      NULL,
      6,
      NULL,
      0.631322,
      0.087578,
      0.002155,
      1,
      0,
      0,
      NULL,
      0.166035,
      1.618187,
      1,
      3,
      NULL,
      NULL,
      1.510096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.572222,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.769901,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.538626,
      1,
      3.425700,
      NULL,
      0.579827,
      0.926048,
      0,
      NULL,
      4.472638,
      NULL,
      1.763454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.544871,
      NULL,
      NULL,
      NULL,
      1.081741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545298,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.583606,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.304675,
      NULL,
      NULL,
      NULL,
      1.477675,
      NULL,
      NULL,
      NULL,
      0.098975,
      NULL,
      NULL,
      NULL,
      2.600332,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444814,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.525249,
      NULL,
      0.525469,
      NULL,
      NULL,
      NULL,
      1.591352,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.059825,
      NULL,
      NULL,
      NULL,
      0,
      4.602790,
      7,
      NULL,
      NULL,
      2.148270,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.745092,
      2,
      1,
      NULL,
      NULL,
      0.369129,
      NULL,
      0.982889,
      80.548151,
      NULL,
      0,
      0.760769,
      1,
      NULL,
      1.828758,
      0,
      0,
      1.659337,
      1,
      1,
      1.050508,
      0,
      1,
      NULL,
      0,
      0.263111,
      0.681463,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      3.812116,
      3,
      4,
      NULL,
      NULL,
      3,
      NULL,
      0.312693,
      0,
      1,
      1.172644,
      2,
      0.345329,
      0,
      1.785116,
      1.954883,
      1.639232,
      NULL,
      1.238811,
      1.426343,
      1,
      1,
      0.395597,
      2,
      0,
      0.703188,
      0.249621,
      1.975380,
      0.781291,
      2.227931,
      1.481566,
      NULL,
      0.157322,
      1.049554,
      NULL,
      0.260135,
      NULL,
      0.284732,
      NULL,
      0,
      1.501410,
      1.552375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067100,
      0.896730,
      0,
      1,
      1.892054,
      1.766097,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      98,
      0,
      0.836238,
      6,
      '12121',
      '44112',
      '01110',
      0.622825,
      '',
      '',
      NULL,
      0.284836,
      '',
      '',
      '');
commit;
end;
/


