set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.880578,
      1,
      7,
      0,
      1.484875,
      0,
      0.090389,
      2,
      '243',
      '31143331',
      12,
      NULL,
      '3141033',
      0,
      0,
      3,
      NULL,
      '3130',
      2,
      0.422884,
      NULL,
      NULL,
      NULL,
      97.324059,
      53.444631,
      NULL,
      NULL,
      0,
      ' 1-24-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 7-28-1998',
      NULL,
      NULL,
      2,
      2,
      1.803016,
      NULL,
      3,
      3.837588,
      NULL,
      NULL,
      NULL,
      8,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.734134,
      0,
      NULL,
      0.043094,
      1,
      0,
      0.939373,
      0,
      1.772179,
      3.100774,
      0.288762,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      5,
      0,
      0,
      1,
      NULL,
      1,
      5.688306,
      0,
      NULL,
      1,
      0,
      0.957261,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.945294,
      1.738771,
      0,
      1.702419,
      0,
      0,
      2,
      2.453066,
      NULL,
      NULL,
      2.558449,
      2,
      1.757854,
      3.652432,
      0,
      2,
      1,
      0,
      3,
      5,
      0,
      1,
      5.603284,
      NULL,
      NULL,
      NULL,
      1.185140,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      1,
      1,
      0,
      1.901871,
      NULL,
      1,
      1,
      0,
      3,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      3,
      3,
      0,
      NULL,
      2,
      1,
      4,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      ' 4- 6-2002',
      317.352536,
      ' 3-20-1981',
      488,
      0,
      2,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.003472,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.189346,
      0.851096,
      1,
      0,
      7,
      NULL,
      1,
      7,
      0.376895,
      NULL,
      NULL,
      NULL,
      1.713801,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464713,
      0.280512,
      1.073063,
      0.130380,
      NULL,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.034761,
      1,
      0,
      2,
      NULL,
      2,
      3,
      2,
      NULL,
      3,
      1,
      NULL,
      2,
      NULL,
      1.741718,
      1,
      0,
      3,
      0,
      1.923079,
      0.204721,
      NULL,
      1.324181,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1.900846,
      NULL,
      7.014149,
      2.906760,
      8,
      9.952775,
      2,
      0.344327,
      NULL,
      2.833135,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      36,
      NULL,
      NULL,
      21,
      2,
      4.881398,
      NULL,
      '31344',
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      '11132',
      '2411',
      '',
      NULL,
      8.340947,
      50,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      3.365645,
      3.938221,
      0.679772,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252508,
      NULL,
      NULL,
      NULL,
      1.708554,
      NULL,
      3.679316,
      3,
      3.769954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.418436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053998,
      NULL,
      NULL,
      4,
      0.316357,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420951,
      NULL,
      NULL,
      NULL,
      1.072743,
      3,
      NULL,
      NULL,
      0,
      0.983305,
      3,
      NULL,
      3,
      2.110876,
      NULL,
      1,
      2.517860,
      3,
      0.287275,
      0,
      2.411730,
      3.410495,
      3.382664,
      3,
      2.414855,
      0,
      NULL,
      1.702632,
      3,
      2,
      0.454099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4.550875,
      0,
      1.369552,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.094497,
      NULL,
      NULL,
      NULL,
      0.500181,
      3.603314,
      0,
      2,
      0,
      0.667238,
      NULL,
      NULL,
      NULL,
      1.570525,
      3.668604,
      3,
      1.875150,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.467261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.455117,
      NULL,
      NULL,
      0,
      0,
      1,
      3.201391,
      NULL,
      NULL,
      5,
      2.015444,
      1,
      1,
      NULL,
      NULL,
      2.979693,
      0.424141,
      NULL,
      1.524046,
      0,
      0.020951,
      0,
      NULL,
      NULL,
      NULL,
      0.115933,
      0.022211,
      2,
      0.877444,
      2,
      NULL,
      1.221232,
      0.518603,
      0,
      0.543663,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.309552,
      2,
      1,
      1,
      5.081742,
      2,
      2,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549723,
      NULL,
      NULL,
      1.116795,
      NULL,
      NULL,
      0.910303,
      NULL,
      NULL,
      0.729093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.109963,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.972027,
      NULL,
      NULL,
      1.605316,
      1,
      1,
      1,
      0,
      2.659514,
      NULL,
      NULL,
      NULL,
      0.338836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.118773,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.834029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035926,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.433454,
      NULL,
      NULL,
      NULL,
      1.585377,
      NULL,
      NULL,
      NULL,
      0.708645,
      NULL,
      NULL,
      NULL,
      0.330367,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.527735,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      0.113746,
      157.828101,
      46,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.939079,
      0.940744,
      1,
      1.929389,
      1,
      0,
      NULL,
      0,
      0.130400,
      1,
      0,
      0.268907,
      0.003944,
      0,
      1,
      1,
      1.302424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.847183,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163158,
      0.271862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994105,
      3,
      NULL,
      NULL,
      NULL,
      0.748213,
      NULL,
      NULL,
      NULL,
      0.999853,
      NULL,
      1.168245,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.381527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.305493,
      NULL,
      0.442641,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1,
      4.523831,
      1.866827,
      NULL,
      2,
      7,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.134860,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.694771,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      3,
      NULL,
      3.571244,
      0,
      NULL,
      NULL,
      1.000823,
      NULL,
      2.724460,
      1,
      1.722119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.540971,
      NULL,
      3,
      6,
      1,
      1.603063,
      2,
      0.626877,
      NULL,
      41,
      NULL,
      4.561785,
      7,
      NULL,
      '02443',
      '02031',
      1.041787,
      '',
      '',
      '',
      NULL,
      '14131',
      NULL,
      '');
commit;
end;
/


