set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758892';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.826147,
      6.757797,
      1.103987,
      6.172958,
      NULL,
      NULL,
      NULL,
      1.036861,
      '03',
      '20113021',
      24,
      41.299371,
      '1032410',
      1,
      0,
      1,
      1,
      '1301',
      4,
      1.954240,
      NULL,
      NULL,
      ' 5-12-2000',
      71,
      248.089276,
      NULL,
      1,
      0,
      '11-22-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5-25-1975',
      NULL,
      ' 5- 3-1987',
      1,
      2.313691,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      8,
      5.538253,
      6.709491,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.719641,
      1,
      0,
      NULL,
      0.135197,
      0,
      NULL,
      1,
      0,
      0,
      0.006442,
      3,
      6,
      1,
      3,
      0,
      1,
      2,
      0,
      NULL,
      0,
      3,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      2,
      1.132980,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      3.846540,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      4,
      3,
      NULL,
      0,
      1,
      0,
      4,
      NULL,
      0,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.478073,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      3,
      4,
      4,
      NULL,
      3,
      ' 1-11-1984',
      NULL,
      ' 9-20-1997',
      0,
      0.015642,
      0,
      0,
      1,
      4,
      NULL,
      2,
      1,
      NULL,
      NULL,
      5,
      5,
      1,
      3,
      3,
      5,
      1,
      NULL,
      2.090703,
      1,
      1,
      ' 6-23-1991',
      0,
      '11- 1-1993',
      2,
      0.062203,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.612382,
      3.480919,
      1,
      NULL,
      2.908595,
      1,
      NULL,
      0,
      1.557360,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.482735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.357712,
      3.821480,
      NULL,
      1,
      1.032131,
      0,
      5.504983,
      1.141491,
      0.727573,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.023034,
      1.574709,
      1.274302,
      1,
      1.172701,
      0,
      0,
      0.158533,
      3.526311,
      0.322895,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5.638052,
      2,
      NULL,
      7,
      4.242098,
      6.370757,
      2.623938,
      1,
      6,
      NULL,
      2.366963,
      2.099120,
      12.459887,
      NULL,
      2,
      45,
      NULL,
      21,
      8,
      NULL,
      NULL,
      0,
      NULL,
      '42403',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.138158,
      NULL,
      13,
      2.595751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587639,
      NULL,
      NULL,
      0.295570,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173238,
      NULL,
      NULL,
      0.476244,
      NULL,
      NULL,
      1.832782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.096507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058290,
      NULL,
      NULL,
      0.359267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.074511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979887,
      NULL,
      NULL,
      0.229906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884100,
      NULL,
      NULL,
      1.754551,
      NULL,
      NULL,
      1.498380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.541788,
      NULL,
      NULL,
      1.738629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.601499,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202165,
      NULL,
      NULL,
      1.864105,
      NULL,
      NULL,
      1,
      0,
      1.765899,
      0,
      0.923284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.990882,
      2,
      2.548721,
      0,
      1.774207,
      0.111998,
      3.745462,
      NULL,
      NULL,
      NULL,
      23.859789,
      NULL,
      NULL,
      NULL,
      0.068329,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662752,
      NULL,
      NULL,
      NULL,
      2.855348,
      NULL,
      NULL,
      NULL,
      0.472373,
      NULL,
      NULL,
      NULL,
      1.285044,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.688634,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.267771,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.782302,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.135517,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.976523,
      0,
      0.022311,
      0.167775,
      NULL,
      NULL,
      0,
      NULL,
      0,
      135,
      1,
      0,
      1.377878,
      NULL,
      0.253217,
      1,
      1.149748,
      1,
      1.575420,
      1,
      NULL,
      1.031206,
      1.758018,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816231,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.564436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.362709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037185,
      NULL,
      1,
      0.989841,
      0.338436,
      NULL,
      NULL,
      NULL,
      0.872201,
      1.818128,
      1.766809,
      1,
      1,
      0.250237,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.230708,
      NULL,
      0.708224,
      NULL,
      1,
      1.932831,
      2,
      3,
      1,
      0,
      1,
      NULL,
      1.443638,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.152870,
      NULL,
      0,
      0.414981,
      NULL,
      1,
      0,
      NULL,
      0,
      0.550920,
      NULL,
      0,
      NULL,
      NULL,
      2.787298,
      0.723082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671680,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.806738,
      NULL,
      1.047141,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      59.308149,
      46.138991,
      NULL,
      0.557713,
      2.553202,
      '3301',
      '42030',
      '',
      0.899134,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


