set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2433401',
      2,
      0.905592,
      2,
      0,
      '4301',
      0.034272,
      1.166126,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      2,
      NULL,
      NULL,
      ' 5-20-2000',
      34.586502,
      1.861538,
      94.661226,
      NULL,
      0,
      ' 7-29-1987',
      NULL,
      '11- 5-1997',
      NULL,
      NULL,
      2,
      0.617238,
      NULL,
      1.314005,
      3,
      1.413870,
      1.794738,
      NULL,
      4,
      0.301464,
      8.249118,
      22.870068,
      1.619759,
      NULL,
      4,
      4,
      NULL,
      4,
      1.965154,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      3.646058,
      NULL,
      0.611126,
      0,
      3,
      1,
      6,
      1,
      NULL,
      1,
      1,
      1,
      5,
      2,
      NULL,
      2,
      1,
      5,
      NULL,
      5,
      7.832722,
      1,
      0,
      1,
      1,
      0.144147,
      NULL,
      NULL,
      0.496427,
      NULL,
      NULL,
      2,
      5,
      3.930930,
      0.862702,
      3,
      1.952093,
      1,
      NULL,
      NULL,
      0,
      0,
      1.721910,
      0,
      1,
      1.237122,
      2,
      0,
      1,
      NULL,
      3,
      0,
      0,
      1.431130,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.774955,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0.783373,
      1,
      2,
      0,
      4,
      2,
      4,
      1,
      1,
      3,
      3,
      5,
      0,
      5,
      1,
      0,
      2,
      4,
      4,
      0,
      2,
      1,
      NULL,
      0,
      5,
      0,
      1,
      NULL,
      ' 4- 7-1991',
      245,
      NULL,
      33,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.057426,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.013785,
      0.111643,
      NULL,
      3,
      NULL,
      2,
      1.547498,
      NULL,
      NULL,
      1.934606,
      2.547009,
      0.888780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      69.527433,
      3.386089,
      1.057869,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      3,
      3,
      3,
      2,
      2,
      3,
      NULL,
      2,
      0,
      3,
      2.013134,
      0,
      1.543206,
      NULL,
      1,
      5.436123,
      1,
      NULL,
      1,
      1.315271,
      1.347646,
      1,
      NULL,
      1.866603,
      0,
      NULL,
      0.652440,
      1,
      8,
      7.417154,
      1.160330,
      0.423501,
      2.100687,
      3,
      2,
      3.967652,
      NULL,
      3,
      1,
      1.828337,
      26,
      1,
      3.797338,
      NULL,
      18,
      15,
      62,
      5,
      0.034510,
      3,
      '01201',
      '',
      '',
      1,
      '',
      '',
      '',
      0.177574,
      '',
      '',
      '',
      NULL,
      NULL,
      23.012722,
      NULL,
      1.978075,
      36.573720,
      3,
      1.052830,
      1,
      NULL,
      3,
      3.592217,
      0.642721,
      NULL,
      NULL,
      2.448776,
      3.228020,
      3.271106,
      0,
      NULL,
      NULL,
      1.597485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.307289,
      2.251232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.437333,
      3.494215,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.180019,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.287819,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.712172,
      0,
      1,
      1,
      1,
      2,
      3,
      0,
      3.126844,
      NULL,
      1.023333,
      0.303319,
      NULL,
      1,
      NULL,
      NULL,
      0.564072,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017286,
      NULL,
      NULL,
      4,
      4,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      1.994304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533377,
      NULL,
      NULL,
      1.296832,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.240639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.907689,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      6,
      5.058758,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780841,
      0,
      0,
      3.505868,
      0,
      NULL,
      0.524251,
      3,
      1,
      8,
      3.454903,
      7.926205,
      2,
      0,
      1.752540,
      0,
      3,
      3.119405,
      0.893757,
      NULL,
      2,
      NULL,
      2.548358,
      0.228666,
      7,
      1,
      5,
      5,
      5.519723,
      0.559377,
      1,
      NULL,
      NULL,
      1.002220,
      1.791737,
      NULL,
      NULL,
      0.519400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.015627,
      1,
      0.181900,
      0.234006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958162,
      NULL,
      NULL,
      NULL,
      3.091423,
      5.991102,
      3.871877,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.634821,
      NULL,
      NULL,
      1.360499,
      NULL,
      NULL,
      1.172585,
      NULL,
      1.556802,
      0.512580,
      1.634781,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.349146,
      0.691140,
      1,
      1.697752,
      NULL,
      NULL,
      1.825779,
      NULL,
      2.580244,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.313937,
      NULL,
      NULL,
      NULL,
      3,
      46.041564,
      11.127812,
      NULL,
      0.974779,
      NULL,
      NULL,
      1.334823,
      NULL,
      0.145938,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220198,
      NULL,
      0.857479,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      2.635261,
      0.751041,
      1.296708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315764,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.704010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.270351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.571647,
      NULL,
      0,
      NULL,
      0.021784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.488542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      5,
      3.773903,
      1,
      1,
      6,
      1.381998,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.441346,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.073341,
      2.484039,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317266,
      0.597739,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.022578,
      NULL,
      1.583797,
      1.471846,
      NULL,
      2,
      0.212448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248665,
      NULL,
      0.342966,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      46,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '12321',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


