set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8203083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '2143001',
      1,
      NULL,
      2,
      NULL,
      '1443',
      NULL,
      0,
      NULL,
      NULL,
      ' 8-28-1986',
      NULL,
      NULL,
      5,
      2,
      1.016302,
      '10-16-1974',
      NULL,
      5.011848,
      NULL,
      105,
      NULL,
      ' 3-13-1978',
      ' 7-28-1986',
      ' 4-14-2000',
      NULL,
      NULL,
      2,
      NULL,
      0.106475,
      3.216145,
      3,
      1.627697,
      1.686612,
      108,
      NULL,
      7,
      3.145296,
      NULL,
      2,
      4,
      27.800748,
      5,
      2,
      4,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.429058,
      0.531653,
      NULL,
      165.214026,
      3,
      1,
      NULL,
      0.814383,
      NULL,
      0,
      4,
      1,
      NULL,
      1,
      4,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      0.042630,
      0,
      NULL,
      4,
      1,
      1.155364,
      0.935891,
      0.547127,
      1,
      1,
      0.930210,
      1.027090,
      2.341739,
      2,
      1.101347,
      NULL,
      NULL,
      2.103186,
      1,
      2,
      1,
      1,
      0,
      0,
      NULL,
      11,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0,
      NULL,
      1,
      5,
      0,
      1,
      3,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.105205,
      NULL,
      NULL,
      3,
      2,
      1,
      4,
      3,
      1,
      1,
      4,
      1,
      2,
      4,
      NULL,
      5,
      0,
      1,
      2,
      2,
      2,
      1,
      3,
      1,
      0,
      5,
      NULL,
      5,
      NULL,
      1,
      ' 5-23-1999',
      NULL,
      NULL,
      30.811673,
      1.026012,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0.575748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      47.597358,
      NULL,
      1,
      0,
      0,
      NULL,
      2.432032,
      2.235934,
      5,
      1,
      0,
      2,
      3.706291,
      NULL,
      1,
      0.150732,
      0,
      4.718624,
      NULL,
      5,
      0.058081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.016876,
      2,
      2,
      NULL,
      1,
      6,
      ' 2-18-1977',
      665.717286,
      NULL,
      7,
      NULL,
      0,
      2.381273,
      0,
      2.830589,
      0,
      NULL,
      0,
      0.463401,
      1.257425,
      3.482387,
      211,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212008,
      3.887273,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      3,
      3,
      1,
      0,
      NULL,
      0.551171,
      1,
      0,
      1,
      0,
      0,
      1,
      0.811512,
      NULL,
      NULL,
      1.904180,
      0.687831,
      1,
      0,
      0,
      0.396740,
      4.708274,
      NULL,
      3,
      5.359646,
      NULL,
      5.532868,
      0,
      1,
      NULL,
      NULL,
      1,
      0.330493,
      61.557463,
      NULL,
      1.700739,
      NULL,
      48,
      3,
      68.011045,
      2,
      0.347888,
      3,
      '02334',
      '',
      '',
      0.377746,
      '11232',
      '',
      '',
      0,
      '',
      '',
      '',
      2.008053,
      42.566032,
      2,
      52.206945,
      2.672229,
      12.681374,
      18,
      10.355154,
      1,
      1,
      2.654101,
      NULL,
      1,
      NULL,
      NULL,
      3.282274,
      1.706170,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.483108,
      NULL,
      NULL,
      0.444053,
      3.495929,
      1,
      0.797685,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.468044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615109,
      NULL,
      NULL,
      8.608450,
      NULL,
      3.620210,
      NULL,
      1.542119,
      NULL,
      NULL,
      NULL,
      0.439708,
      3,
      0,
      NULL,
      1,
      8,
      1,
      0.837079,
      NULL,
      NULL,
      1.671343,
      18,
      1.957118,
      1.524218,
      NULL,
      NULL,
      1.819325,
      0.061068,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      3.485922,
      NULL,
      1.199466,
      0.026843,
      1.136370,
      NULL,
      NULL,
      NULL,
      0.982075,
      NULL,
      NULL,
      0.701161,
      0,
      0,
      1.574505,
      NULL,
      0.952315,
      1,
      1.153987,
      NULL,
      NULL,
      NULL,
      NULL,
      2.531398,
      0.034016,
      3.058490,
      1.189572,
      NULL,
      NULL,
      0.454739,
      NULL,
      1,
      0.824916,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.593529,
      NULL,
      2,
      0.241757,
      3.390391,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.245548,
      1.852659,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.713521,
      NULL,
      NULL,
      0.241492,
      0,
      1.064019,
      0.853653,
      NULL,
      1.888721,
      NULL,
      NULL,
      NULL,
      4.640357,
      8.429084,
      5.898095,
      3.582313,
      9,
      1.972473,
      0,
      NULL,
      NULL,
      NULL,
      0.693008,
      NULL,
      1.298722,
      3,
      2.603392,
      2.628838,
      3.673156,
      3.318319,
      1.934602,
      2.879063,
      2.076374,
      0.589265,
      0,
      NULL,
      3,
      3,
      1,
      1.207102,
      NULL,
      NULL,
      2.858382,
      2.112191,
      2.487855,
      NULL,
      1.366519,
      7,
      4.157978,
      2.296770,
      5.124390,
      2.611280,
      NULL,
      NULL,
      NULL,
      1,
      1.515069,
      1.099181,
      0.972133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      1.763898,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397779,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.319972,
      NULL,
      NULL,
      NULL,
      0.110026,
      NULL,
      NULL,
      NULL,
      3.968298,
      NULL,
      NULL,
      NULL,
      3.231683,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.820204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.187763,
      NULL,
      NULL,
      NULL,
      1.597079,
      NULL,
      NULL,
      NULL,
      1.287007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.600129,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.359791,
      NULL,
      1.375166,
      NULL,
      NULL,
      1,
      2.684108,
      NULL,
      NULL,
      0,
      165.198682,
      8,
      1.552053,
      2,
      1,
      2.972363,
      109,
      13,
      NULL,
      15.484898,
      3.552451,
      0.220569,
      1.237694,
      5,
      NULL,
      127,
      1.340849,
      9,
      1,
      NULL,
      1,
      1.122679,
      NULL,
      0,
      1.937036,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513186,
      0.822181,
      1.004276,
      1.705129,
      0.547639,
      1.579314,
      0.081341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.950995,
      NULL,
      NULL,
      2,
      0,
      3.225329,
      3,
      2.479998,
      1.806462,
      NULL,
      1,
      0.520982,
      1.426156,
      NULL,
      0,
      1,
      2,
      0.768243,
      1,
      1.958632,
      1.586326,
      0.383456,
      1,
      1.279506,
      1.008838,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.767857,
      NULL,
      NULL,
      0.919061,
      1,
      NULL,
      0,
      0,
      1,
      3.058221,
      3.348207,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.508285,
      3.405754,
      0.975299,
      0,
      NULL,
      0.822862,
      0,
      0,
      1,
      0,
      0,
      0.397347,
      2.502798,
      1.168589,
      1.163005,
      0,
      2.665079,
      1,
      1.034785,
      NULL,
      0.647988,
      NULL,
      1.759874,
      NULL,
      1.093064,
      1,
      1.915113,
      49.021103,
      NULL,
      NULL,
      1,
      0.938175,
      0,
      0.217745,
      0.532440,
      0.991389,
      2,
      6,
      4,
      1,
      1.254321,
      1.876995,
      53,
      66,
      0,
      0,
      4,
      NULL,
      '20133',
      NULL,
      NULL,
      '33142',
      NULL,
      NULL,
      1.383497,
      '',
      '',
      NULL);
commit;
end;
/


