set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      2.432591,
      1.428969,
      0,
      3,
      '1222',
      0,
      0.473337,
      NULL,
      NULL,
      ' 5-24-1979',
      25,
      NULL,
      NULL,
      1.387709,
      NULL,
      ' 8- 5-1979',
      NULL,
      3.764578,
      182,
      122.841450,
      1,
      ' 7-12-1999',
      ' 5-29-1982',
      ' 2-18-1984',
      0,
      NULL,
      2.649214,
      1,
      1,
      NULL,
      3,
      0.221783,
      0,
      NULL,
      4,
      12.348614,
      0.746195,
      3,
      25,
      2,
      9.461480,
      5,
      5,
      8,
      NULL,
      NULL,
      NULL,
      0.241391,
      NULL,
      0,
      1,
      NULL,
      0.565167,
      NULL,
      0.423767,
      NULL,
      0,
      3,
      0,
      4,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      5.473652,
      0,
      NULL,
      0,
      NULL,
      1.710927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.952842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.691516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      2.381176,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1.222222,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      1,
      5,
      4,
      3,
      2,
      0,
      2,
      1,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      88,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      4,
      NULL,
      NULL,
      0.594220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.703868,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.897027,
      0.994734,
      NULL,
      NULL,
      NULL,
      4,
      6.503287,
      11.346801,
      0,
      1,
      0,
      1.377093,
      NULL,
      NULL,
      NULL,
      0.596215,
      9.310953,
      0.538893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.417929,
      1.485502,
      1,
      0.919805,
      1.883469,
      0.033705,
      1,
      15,
      0.002565,
      1.237481,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.248371,
      NULL,
      0,
      1,
      2,
      0,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      11.553813,
      NULL,
      NULL,
      187,
      191,
      170.153905,
      22,
      105.882769,
      138,
      171,
      166.699739,
      188,
      2,
      NULL,
      NULL,
      12,
      2.444197,
      0,
      2.792064,
      NULL,
      3.551665,
      6.283993,
      7,
      1,
      0,
      NULL,
      3.735238,
      3.788501,
      0.682781,
      0,
      24,
      1,
      NULL,
      NULL,
      NULL,
      32,
      13,
      3,
      0,
      NULL,
      '01104',
      '13442',
      NULL,
      0.126740,
      '',
      '',
      '',
      0.971031,
      '',
      '',
      '',
      1,
      42,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.027017,
      NULL,
      NULL,
      8,
      2.868422,
      7.748006,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.170947,
      NULL,
      NULL,
      1.983806,
      NULL,
      NULL,
      0.001405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470080,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.599107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872321,
      NULL,
      NULL,
      1.963267,
      NULL,
      NULL,
      3,
      3.986175,
      0,
      0,
      NULL,
      NULL,
      6.023016,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.354562,
      NULL,
      NULL,
      0.036737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.789135,
      NULL,
      NULL,
      1.699638,
      NULL,
      NULL,
      1.077565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617987,
      NULL,
      NULL,
      1.435730,
      3.869885,
      2,
      0,
      NULL,
      NULL,
      1.014981,
      0,
      4,
      NULL,
      NULL,
      NULL,
      2.528923,
      NULL,
      NULL,
      1.054081,
      NULL,
      NULL,
      3.486767,
      0,
      1,
      NULL,
      2,
      1.945852,
      NULL,
      NULL,
      1.866257,
      0,
      0.352316,
      3,
      0.682101,
      NULL,
      NULL,
      1.682166,
      0,
      0.567099,
      2.236835,
      2,
      0.002622,
      8,
      0,
      1.154025,
      5.576727,
      4.246483,
      NULL,
      NULL,
      4,
      1,
      1.394931,
      1,
      0,
      1,
      0.236001,
      1,
      NULL,
      NULL,
      10.359762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.046595,
      NULL,
      NULL,
      10.046252,
      NULL,
      NULL,
      14.105616,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      14.774129,
      NULL,
      NULL,
      17.912196,
      NULL,
      NULL,
      15.073502,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      2.000368,
      NULL,
      NULL,
      NULL,
      13.149785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.143088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      2.885306,
      NULL,
      NULL,
      NULL,
      10.882246,
      NULL,
      NULL,
      NULL,
      10.632112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.870077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257571,
      NULL,
      NULL,
      1,
      NULL,
      1.537470,
      10012,
      307,
      NULL,
      1,
      0,
      1.712551,
      1.098375,
      0,
      0.996216,
      1,
      1.124735,
      0.028823,
      NULL,
      2,
      1,
      NULL,
      0.480464,
      0.455888,
      NULL,
      3.283339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.431565,
      NULL,
      0,
      NULL,
      73,
      NULL,
      38,
      71,
      111,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.471580,
      NULL,
      NULL,
      NULL,
      3.596368,
      NULL,
      1.687918,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      0.979519,
      0.489656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      15,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182382,
      0.236681,
      0.883349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657224,
      NULL,
      NULL,
      0.292042,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      171,
      79.990184,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      1.610792,
      3.908812,
      1.311153,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.795818,
      0.190724,
      NULL,
      3.544683,
      0.854179,
      NULL,
      2.188980,
      2,
      NULL,
      NULL,
      1.193068,
      NULL,
      1.876347,
      NULL,
      NULL,
      2.037637,
      0.644843,
      NULL,
      1,
      2.376161,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1.220842,
      NULL,
      NULL,
      1.343444,
      NULL,
      NULL,
      1.963102,
      0.817023,
      0,
      3,
      NULL,
      0,
      NULL,
      0.626647,
      NULL,
      1.675451,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.548675,
      NULL,
      1.243007,
      NULL,
      1.459708,
      NULL,
      1.465583,
      NULL,
      2,
      NULL,
      1.162640,
      NULL,
      0,
      NULL,
      NULL,
      0.041319,
      1832.970102,
      0,
      2.772373,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.560065,
      NULL,
      0.622161,
      NULL,
      3.916215,
      NULL,
      3.666632,
      NULL,
      2.235564,
      NULL,
      3.245013,
      NULL,
      3,
      NULL,
      1,
      NULL,
      13,
      0.133164,
      941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691764,
      NULL,
      NULL,
      65,
      142,
      1,
      NULL,
      NULL,
      NULL,
      '23443',
      '21313',
      1,
      '',
      '',
      '',
      0.728959,
      '',
      '',
      NULL);
commit;
end;
/


