set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1223304',
      2,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      ' 6-12-1995',
      NULL,
      NULL,
      6,
      1,
      2,
      ' 7-24-1976',
      29,
      NULL,
      238.906639,
      53,
      NULL,
      ' 5- 4-1987',
      ' 0- 3-1987',
      ' 0-12-1985',
      0.444296,
      0.480702,
      1.839612,
      1.325495,
      0.681988,
      0.739504,
      0,
      1,
      NULL,
      3,
      2,
      6.557621,
      2,
      3,
      NULL,
      5,
      13,
      NULL,
      NULL,
      NULL,
      1.871230,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.800782,
      0.553873,
      NULL,
      0,
      4,
      NULL,
      0,
      2.222383,
      0,
      2,
      5,
      0,
      1,
      0,
      1,
      0,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3.369584,
      0,
      1.178762,
      1.980683,
      NULL,
      0,
      2.037222,
      1,
      1,
      0.334094,
      0.197912,
      0.681535,
      1.456992,
      1,
      0.223034,
      0.608116,
      0,
      0,
      1,
      3,
      1,
      1,
      0,
      0.266080,
      NULL,
      NULL,
      1.340873,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      4,
      1,
      2,
      NULL,
      1,
      3,
      3,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      0,
      1,
      0,
      4,
      1,
      3,
      2,
      1,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2,
      2,
      5,
      5,
      1,
      0,
      1,
      1,
      0,
      4,
      4.246267,
      0.400080,
      '11- 5-1985',
      NULL,
      NULL,
      71,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      0,
      2,
      1,
      4,
      0,
      3,
      1,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.312972,
      NULL,
      5,
      0,
      0.455830,
      0.927679,
      2,
      NULL,
      NULL,
      1,
      1.104307,
      0,
      2,
      1.542051,
      8.871733,
      0,
      4.980465,
      2.277332,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.537993,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562595,
      1,
      1.917386,
      NULL,
      0,
      0.767223,
      0.819473,
      2.439454,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702512,
      2,
      2,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      3,
      1,
      2,
      3.069527,
      18,
      6,
      1,
      1.905145,
      0.628942,
      129,
      NULL,
      176,
      0.921654,
      1.113191,
      NULL,
      0,
      0.517688,
      0,
      1,
      NULL,
      18,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      50,
      NULL,
      NULL,
      1,
      NULL,
      0.171014,
      '30011',
      '',
      '',
      1,
      '',
      '',
      '',
      0.226112,
      '',
      NULL,
      '',
      NULL,
      7,
      NULL,
      0,
      1.233521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      1.649688,
      3.387092,
      0,
      0,
      0,
      NULL,
      NULL,
      0.310233,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.602892,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.859521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.356842,
      NULL,
      NULL,
      9.120584,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.208673,
      1.300691,
      1.343449,
      1.086521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.550463,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201960,
      NULL,
      NULL,
      2.885782,
      3.346081,
      0,
      1,
      3,
      1,
      1.001893,
      NULL,
      NULL,
      7.734979,
      3,
      1.445293,
      1,
      NULL,
      NULL,
      NULL,
      2.022944,
      1,
      0.439337,
      NULL,
      NULL,
      1.860943,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.109874,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.294891,
      NULL,
      NULL,
      NULL,
      2.873372,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834296,
      0.320640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4,
      4,
      0,
      0.057015,
      2,
      3,
      0,
      3.447216,
      0.541988,
      1.802996,
      NULL,
      3.438673,
      1,
      3.212641,
      1,
      6.627753,
      2,
      7,
      1,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      1.927908,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.317572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.869181,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.905768,
      NULL,
      0.830099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320048,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081288,
      NULL,
      NULL,
      NULL,
      6.269586,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.091475,
      NULL,
      0,
      NULL,
      NULL,
      1.580206,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.502110,
      NULL,
      NULL,
      0.368257,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      14281.650213,
      10.568843,
      0,
      1,
      3.804241,
      NULL,
      0.321352,
      1,
      0.299982,
      0.571499,
      NULL,
      0,
      NULL,
      NULL,
      3.593044,
      1,
      1,
      0,
      0.288954,
      0,
      0.906871,
      NULL,
      1,
      NULL,
      1.697301,
      NULL,
      2.745150,
      NULL,
      0,
      NULL,
      85,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.021345,
      2,
      1,
      NULL,
      3.172035,
      NULL,
      1.388431,
      NULL,
      NULL,
      NULL,
      0.135196,
      NULL,
      1,
      NULL,
      2.815483,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.495432,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.617307,
      0.942168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.439065,
      NULL,
      1,
      NULL,
      3.431138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662520,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003042,
      1.832749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      23.284079,
      0.888350,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      6,
      0,
      2,
      0,
      2,
      5.446336,
      1.871981,
      2,
      0.562346,
      1.916827,
      0.703702,
      NULL,
      NULL,
      1,
      NULL,
      0.551170,
      1,
      NULL,
      0.916993,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776667,
      1.058882,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.676722,
      0.046489,
      NULL,
      1.237196,
      0,
      2,
      1.967132,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.296301,
      NULL,
      0.769661,
      NULL,
      1.957098,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.943679,
      NULL,
      1.088910,
      NULL,
      0,
      NULL,
      1.239031,
      NULL,
      1.227424,
      NULL,
      2.218278,
      1.419061,
      857.397150,
      2.543970,
      2.965320,
      NULL,
      0,
      NULL,
      0.621980,
      NULL,
      0,
      NULL,
      1.536674,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421566,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.694300,
      NULL,
      47,
      1.901370,
      NULL,
      1.253571,
      NULL,
      1,
      NULL,
      1.755910,
      NULL,
      0,
      3,
      0,
      0.819173,
      NULL,
      NULL,
      8,
      102,
      0,
      1.567619,
      3,
      '03012',
      '14031',
      '21411',
      NULL,
      '',
      '',
      '',
      0.770974,
      '',
      NULL,
      '');
commit;
end;
/


