set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1134120',
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      0,
      1.883243,
      7.706889,
      ' 1- 8-1975',
      19,
      0,
      19,
      83,
      0,
      ' 8-16-1985',
      '11-21-1986',
      ' 0-18-1991',
      2,
      0.380863,
      NULL,
      NULL,
      0.086180,
      0,
      1,
      0,
      0.601043,
      NULL,
      1,
      5.350653,
      5,
      2,
      21.441419,
      NULL,
      23.910468,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.978070,
      0.205000,
      1,
      1,
      1,
      1,
      1,
      NULL,
      2,
      3,
      1,
      2,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2.101185,
      1,
      0,
      3,
      NULL,
      1.657650,
      2,
      1.488504,
      1,
      1,
      1,
      1.613132,
      0.254643,
      NULL,
      0,
      1.994900,
      0,
      1,
      0,
      4,
      NULL,
      NULL,
      0.508517,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      1,
      2,
      1,
      0,
      NULL,
      0,
      0,
      0,
      5.677728,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      4,
      4,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      1,
      1,
      5,
      3,
      1,
      4,
      3,
      2,
      0,
      4,
      1,
      0,
      4.656183,
      NULL,
      ' 1-27-1997',
      89,
      ' 4-12-1991',
      74.551360,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      0,
      4,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      1.458764,
      3,
      1.324304,
      1,
      0.793417,
      1.622659,
      0.979439,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.822299,
      3.897022,
      NULL,
      4,
      NULL,
      2.427033,
      1,
      0,
      NULL,
      NULL,
      0.215669,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079134,
      0,
      1,
      0.643498,
      1,
      1,
      1,
      NULL,
      19.250402,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      1,
      2,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      2.836831,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.471712,
      1,
      NULL,
      1,
      0,
      1.155600,
      0,
      1,
      8,
      0.513720,
      4,
      NULL,
      1.371532,
      6.349548,
      5.670522,
      2.175205,
      0.106353,
      2,
      NULL,
      3.120486,
      50.613609,
      0,
      3.858090,
      NULL,
      37,
      NULL,
      71,
      5,
      NULL,
      NULL,
      '41414',
      '',
      '',
      1.421197,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.003406,
      33,
      12,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.919165,
      NULL,
      1,
      2.638148,
      1.535245,
      2,
      0.000594,
      1.811137,
      0.152227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.620610,
      1.057992,
      1.882934,
      1,
      NULL,
      NULL,
      1.905928,
      1,
      1,
      3,
      1.691284,
      0.773628,
      0.581833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      7.331150,
      0,
      1.336197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.703148,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.467641,
      NULL,
      0,
      0.766503,
      NULL,
      0.324295,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.090784,
      0,
      1.825392,
      0,
      NULL,
      NULL,
      0.438420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739856,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0.100270,
      NULL,
      NULL,
      NULL,
      2,
      6,
      3,
      1,
      NULL,
      NULL,
      1.545553,
      2.814689,
      0,
      1.765192,
      NULL,
      NULL,
      0.585396,
      NULL,
      NULL,
      1.864176,
      NULL,
      NULL,
      1.993881,
      NULL,
      NULL,
      0.375908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.559220,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954240,
      NULL,
      2,
      1.540283,
      NULL,
      NULL,
      0.609427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.671122,
      3.502953,
      NULL,
      7.388538,
      0.872198,
      NULL,
      NULL,
      3,
      3,
      1,
      2.589448,
      0,
      NULL,
      1,
      1,
      3,
      3.918099,
      2.478469,
      3,
      7.615313,
      4,
      NULL,
      5.122821,
      3.667217,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.035079,
      0.908580,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.426906,
      NULL,
      NULL,
      1.457917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.680035,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.009787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.799265,
      0.365128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.816758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      18.549843,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.558181,
      0.584912,
      NULL,
      NULL,
      0,
      0.513115,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0.647813,
      3.334309,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.861557,
      NULL,
      0,
      NULL,
      44.008628,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      0.956134,
      0,
      0,
      0.119024,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2.765543,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294684,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1.821647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.926940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.965277,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.511537,
      NULL,
      1.169507,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262005,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.944453,
      3,
      45.259051,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      3,
      3,
      3,
      1,
      4,
      2,
      3.301878,
      0.094256,
      0.614316,
      NULL,
      NULL,
      1,
      3.364489,
      NULL,
      2,
      1,
      NULL,
      1.641729,
      1.199034,
      NULL,
      0,
      NULL,
      NULL,
      0.417302,
      1.259123,
      NULL,
      0.921564,
      1.959374,
      NULL,
      NULL,
      3,
      NULL,
      0.535349,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.416625,
      1,
      NULL,
      0.481159,
      0.181487,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.280260,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.241382,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      123.245084,
      1.186675,
      NULL,
      NULL,
      3.771706,
      NULL,
      NULL,
      NULL,
      1.748873,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.086079,
      NULL,
      3.453485,
      NULL,
      3.145988,
      NULL,
      3,
      NULL,
      1.078072,
      NULL,
      2.086631,
      NULL,
      3.210415,
      NULL,
      175,
      0,
      NULL,
      0.764548,
      NULL,
      1.159517,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      62.712189,
      108,
      5,
      0.070374,
      5,
      '14131',
      '03134',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.189233,
      NULL,
      '',
      NULL);
commit;
end;
/


