set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3340430',
      1.361537,
      1.894265,
      5,
      2,
      '4204',
      1.520164,
      1,
      NULL,
      NULL,
      ' 7-11-1974',
      22,
      NULL,
      3,
      0,
      NULL,
      '10-15-1996',
      1.112261,
      2.118599,
      188.275323,
      150.698881,
      2,
      NULL,
      ' 6-10-1994',
      '11- 5-1991',
      3,
      3,
      2.520369,
      3,
      1,
      3.648232,
      NULL,
      1.047140,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      8.771842,
      4,
      4,
      4.884062,
      0,
      0,
      1,
      0.396582,
      0.964869,
      0.655713,
      NULL,
      1.138409,
      0,
      1.492441,
      0.767544,
      0,
      5,
      0,
      3,
      5,
      NULL,
      5,
      1,
      0,
      0,
      2,
      2,
      1,
      3,
      5,
      NULL,
      5.131004,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169134,
      NULL,
      NULL,
      3,
      0,
      2.905038,
      0.561838,
      NULL,
      1,
      1.139955,
      3,
      0,
      1.172736,
      2,
      NULL,
      0.054321,
      1,
      0.658286,
      NULL,
      3,
      1.711319,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.372916,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      5,
      1,
      1,
      0,
      0,
      0,
      NULL,
      5,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1.939786,
      4,
      4,
      0,
      NULL,
      0,
      3,
      3,
      0,
      0,
      4,
      0,
      3,
      4,
      0,
      NULL,
      5,
      NULL,
      NULL,
      5,
      0,
      NULL,
      5,
      5,
      0,
      4,
      3,
      NULL,
      ' 3-21-1977',
      NULL,
      ' 3-15-1992',
      12,
      1.511059,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      28.653215,
      1,
      3.740047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.772288,
      0.643654,
      NULL,
      1.719730,
      NULL,
      6.309376,
      9.778951,
      3,
      9.822749,
      1.085277,
      NULL,
      NULL,
      NULL,
      1.350434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.012622,
      0.876017,
      NULL,
      NULL,
      1.091354,
      0.758428,
      NULL,
      1.559302,
      51,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.413108,
      1,
      1,
      0,
      3,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      3,
      3.491993,
      2,
      0,
      0.996170,
      0,
      5,
      1.519195,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      3.639120,
      2,
      NULL,
      4.344603,
      9,
      0.697016,
      5,
      4,
      1,
      5.036689,
      3.371718,
      NULL,
      1,
      0.950030,
      1,
      58.985008,
      1,
      0,
      NULL,
      36,
      38,
      NULL,
      2,
      0.919649,
      6,
      '44013',
      NULL,
      '41313',
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      26.537504,
      23.557671,
      16,
      0.859099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.162622,
      0.644141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.099783,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.024680,
      NULL,
      NULL,
      NULL,
      1,
      0.227352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174750,
      NULL,
      NULL,
      0.421025,
      NULL,
      NULL,
      0,
      NULL,
      0.742305,
      1,
      1.151557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.994289,
      0.818911,
      0.550810,
      0.678260,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885927,
      NULL,
      NULL,
      2.351032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.437920,
      2,
      2,
      2.758775,
      2,
      1,
      1.589474,
      NULL,
      NULL,
      3,
      0.256391,
      0.824783,
      NULL,
      0.296682,
      3,
      0.657109,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.330523,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.555119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559978,
      NULL,
      NULL,
      NULL,
      0.759564,
      1,
      3.649074,
      3.186127,
      3,
      0,
      NULL,
      3.864806,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.674100,
      1,
      2,
      2.202655,
      NULL,
      0.067349,
      1,
      1.058802,
      2,
      1.855790,
      6.142097,
      6.951914,
      1.215513,
      2,
      1,
      NULL,
      NULL,
      3,
      3.052991,
      0,
      2.387902,
      1,
      0,
      1.912244,
      7.717983,
      0,
      3,
      0.539420,
      5,
      NULL,
      0.246769,
      NULL,
      NULL,
      0.293748,
      1.594106,
      1,
      0,
      NULL,
      0.855326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423597,
      0,
      0.890238,
      1,
      NULL,
      0.476819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.018763,
      NULL,
      0,
      NULL,
      1.185131,
      0,
      NULL,
      NULL,
      1.863299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648782,
      NULL,
      NULL,
      1,
      NULL,
      1,
      481.386756,
      9.572060,
      0.547076,
      2.807697,
      0,
      2.185785,
      0.238583,
      3.534018,
      1.644301,
      NULL,
      0,
      1.415609,
      NULL,
      3,
      0.624926,
      NULL,
      0.897301,
      0.220177,
      1.796152,
      NULL,
      NULL,
      1.178759,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      0,
      29,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.805188,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3.336449,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.064523,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.688803,
      NULL,
      0.123952,
      NULL,
      NULL,
      2.966667,
      0.108980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682052,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173561,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838941,
      NULL,
      2.599730,
      NULL,
      1.491854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423706,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125784,
      NULL,
      NULL,
      2,
      NULL,
      2.077036,
      NULL,
      3,
      NULL,
      3.167821,
      1.159504,
      0,
      NULL,
      NULL,
      NULL,
      3.037922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.887441,
      1.137390,
      3.165235,
      0,
      NULL,
      0.020987,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      5,
      2.373990,
      3.459684,
      NULL,
      1,
      4.088920,
      1.502091,
      1.083901,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.724359,
      NULL,
      1,
      0.338976,
      NULL,
      1,
      1.637882,
      NULL,
      1.285740,
      NULL,
      NULL,
      NULL,
      0.725618,
      NULL,
      1.355805,
      NULL,
      NULL,
      1.622934,
      1.086942,
      NULL,
      1,
      1.230701,
      NULL,
      1.387426,
      2,
      NULL,
      1,
      3,
      NULL,
      2,
      0,
      1.664454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      1,
      NULL,
      2,
      34,
      40.724468,
      3,
      5,
      1.054965,
      '01312',
      '10313',
      '30313',
      NULL,
      NULL,
      '',
      NULL,
      1.329971,
      '',
      '',
      '');
commit;
end;
/


