set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '34',
      43,
      1.556316,
      '2422141',
      NULL,
      0,
      1,
      2,
      NULL,
      0.869629,
      1,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 2- 1-1976',
      ' 9-24-1987',
      ' 0-18-1975',
      1,
      1,
      0.001876,
      1.386040,
      0.121615,
      0.087010,
      2,
      0.694595,
      1.139715,
      9,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346315,
      1,
      NULL,
      0,
      0.438717,
      NULL,
      1.567558,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      3,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      3.712845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.482538,
      0.480825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      2.667136,
      7.376721,
      0,
      0,
      1,
      2,
      1,
      5,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      3,
      5,
      3,
      NULL,
      0,
      0,
      5,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1.751462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.446554,
      0,
      NULL,
      NULL,
      NULL,
      6.294424,
      6,
      6,
      NULL,
      NULL,
      0.032120,
      0.171079,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.968836,
      0.087840,
      1,
      1,
      NULL,
      NULL,
      3.098213,
      1.206798,
      17.198120,
      16,
      NULL,
      2,
      1.895170,
      1,
      2,
      0,
      0,
      0,
      NULL,
      1,
      2,
      2,
      0,
      3,
      3,
      NULL,
      2,
      4.250299,
      0,
      1,
      NULL,
      1,
      0.387295,
      NULL,
      0.819000,
      1.328558,
      1.184442,
      0,
      0.614377,
      1,
      2.696698,
      1,
      1,
      10.117964,
      3,
      NULL,
      7,
      5,
      2,
      3.786823,
      2.411107,
      0,
      1,
      2.488403,
      0,
      20,
      0,
      NULL,
      23,
      NULL,
      44,
      NULL,
      3,
      NULL,
      6.493313,
      '04403',
      '23231',
      '44400',
      NULL,
      '',
      '',
      '',
      0.348331,
      '',
      NULL,
      '',
      NULL,
      NULL,
      26.797173,
      31.682578,
      NULL,
      19.963225,
      0,
      1.244706,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.913305,
      NULL,
      NULL,
      1.263342,
      NULL,
      NULL,
      1.795403,
      NULL,
      NULL,
      0.003913,
      2.544441,
      0,
      0,
      NULL,
      NULL,
      1.467032,
      NULL,
      NULL,
      0.046487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281509,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.471001,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.842829,
      0,
      2.528038,
      2.611517,
      1.445909,
      1.937457,
      0.872041,
      1.104051,
      2,
      0.128292,
      2.319073,
      0,
      2.629826,
      2.838147,
      3,
      0.915107,
      0.166390,
      1,
      NULL,
      NULL,
      1,
      0.663961,
      0.102463,
      3,
      NULL,
      0,
      NULL,
      1.091625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.315826,
      3.786057,
      2,
      2,
      1.062193,
      NULL,
      NULL,
      NULL,
      0.439477,
      1.473272,
      3.049406,
      0.531818,
      3,
      2.685372,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.601876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.946789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.840746,
      2,
      0,
      1,
      1,
      2.444079,
      2.899253,
      6,
      6,
      2.071209,
      4,
      5.746002,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      2.073876,
      NULL,
      2.225786,
      2,
      2,
      10,
      6.581251,
      5.002167,
      NULL,
      0.311671,
      NULL,
      3.151402,
      NULL,
      1.165882,
      3,
      3,
      2,
      1.272971,
      NULL,
      3,
      NULL,
      3,
      4.566857,
      NULL,
      5,
      5.699777,
      0.624022,
      2,
      4,
      1,
      0.202526,
      1,
      NULL,
      1,
      0.121545,
      NULL,
      NULL,
      0.617193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.712865,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.614367,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.546140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.889183,
      1,
      1.680677,
      NULL,
      1.694790,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.978393,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.596190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007356,
      NULL,
      NULL,
      NULL,
      3.377769,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.565073,
      NULL,
      NULL,
      NULL,
      1.809370,
      NULL,
      NULL,
      NULL,
      0.049983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.640483,
      NULL,
      NULL,
      NULL,
      2.650261,
      NULL,
      NULL,
      NULL,
      3.192158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.248991,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.565490,
      NULL,
      15,
      0,
      2.779669,
      NULL,
      NULL,
      0.350597,
      0,
      0.264285,
      2,
      1.602098,
      NULL,
      1.253560,
      0,
      0.909285,
      NULL,
      NULL,
      0.147841,
      1,
      3,
      NULL,
      2.447873,
      NULL,
      1.022069,
      NULL,
      3.585914,
      NULL,
      1,
      NULL,
      1.761748,
      NULL,
      40.262645,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110991,
      0,
      0.193446,
      NULL,
      2.871186,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.893488,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785397,
      NULL,
      0,
      NULL,
      1.289628,
      3.749605,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.189789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902699,
      NULL,
      NULL,
      NULL,
      3.419704,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.246910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825971,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      105,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.202094,
      NULL,
      2.807018,
      NULL,
      271.584293,
      NULL,
      3,
      NULL,
      3.664283,
      NULL,
      NULL,
      0.191976,
      NULL,
      21,
      11.390135,
      NULL,
      0.117105,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      3,
      1,
      3,
      0,
      9.311068,
      1.725372,
      3.105342,
      0.142490,
      0,
      0,
      0,
      1,
      1,
      0,
      0.574638,
      0.648502,
      0,
      1,
      0,
      0.594021,
      NULL,
      2.052813,
      0.909964,
      3,
      2,
      0.953273,
      0.584968,
      1,
      3,
      1,
      1,
      3,
      0.927235,
      1.965002,
      1.824240,
      0.767270,
      1.718009,
      3,
      3,
      1,
      NULL,
      3.713784,
      3.058220,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418778,
      1,
      0,
      1,
      1,
      1.877652,
      1,
      5,
      7,
      0,
      2,
      2.089317,
      15,
      52.377084,
      0,
      5.527039,
      0.694289,
      '40130',
      '11323',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.247719,
      '',
      '',
      '');
commit;
end;
/


