set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1233012',
      0,
      0,
      2,
      NULL,
      '4101',
      NULL,
      1,
      NULL,
      NULL,
      '10-20-1981',
      NULL,
      NULL,
      3,
      1.630250,
      1.949634,
      ' 4-11-1981',
      NULL,
      2.370342,
      237.487092,
      117,
      2,
      '11-18-1974',
      ' 4-25-1983',
      ' 9-13-1975',
      NULL,
      0,
      2.225668,
      1,
      0,
      NULL,
      3,
      3.885588,
      NULL,
      NULL,
      NULL,
      10.447408,
      10.973932,
      18,
      10,
      0,
      NULL,
      4,
      2,
      2.083076,
      2.163368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3,
      2,
      1,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0,
      1,
      3,
      1,
      2,
      1.430351,
      1,
      NULL,
      1,
      1,
      0,
      2.768767,
      0.140519,
      1,
      1.723887,
      NULL,
      1.431568,
      3,
      1.690920,
      0,
      0.907609,
      1.421271,
      NULL,
      2.904119,
      1,
      0,
      1.195223,
      1,
      1,
      5,
      1,
      0,
      1,
      2.291493,
      1.893057,
      2.888050,
      0.051644,
      1,
      NULL,
      NULL,
      0,
      2,
      4,
      1,
      4,
      0,
      2,
      0,
      0,
      5,
      4,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      0.037610,
      NULL,
      1.025938,
      NULL,
      NULL,
      NULL,
      5,
      3,
      2,
      4,
      0,
      1,
      3,
      3,
      0,
      1,
      0,
      4,
      3,
      NULL,
      5,
      0,
      0,
      4,
      3,
      3,
      2,
      4,
      3,
      1.325686,
      NULL,
      NULL,
      ' 6- 1-2001',
      38,
      0,
      2,
      1,
      0,
      4,
      NULL,
      2,
      0,
      3,
      3,
      4,
      3,
      5,
      2,
      0,
      1,
      5,
      8,
      1.470768,
      13.141574,
      1.987319,
      '11-28-1997',
      NULL,
      ' 7-28-2001',
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.572710,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      12,
      4,
      1,
      NULL,
      3,
      0.553640,
      1,
      0,
      NULL,
      0.748068,
      2.062073,
      3.446892,
      3,
      1.110228,
      NULL,
      NULL,
      NULL,
      1,
      4.388068,
      1,
      0,
      5,
      NULL,
      NULL,
      ' 9- 9-2003',
      NULL,
      ' 1- 3-1995',
      4.272809,
      1,
      1,
      1,
      1,
      2.900725,
      NULL,
      0.558300,
      NULL,
      0,
      0,
      3.527441,
      45.192662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765510,
      0.399928,
      NULL,
      2,
      1,
      2,
      1,
      2,
      NULL,
      3,
      2,
      0,
      1.013943,
      2.418256,
      NULL,
      NULL,
      1.667751,
      0.687770,
      0,
      1,
      1.121998,
      1,
      0,
      NULL,
      NULL,
      1.506597,
      1.126774,
      NULL,
      NULL,
      6,
      0,
      1,
      0,
      4,
      6,
      NULL,
      2,
      2,
      NULL,
      1.442333,
      NULL,
      0,
      3,
      56.601276,
      2,
      1.471750,
      NULL,
      NULL,
      NULL,
      65,
      4,
      0,
      5.006388,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.758492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744369,
      NULL,
      11.587597,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.969352,
      8.600084,
      0.748436,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.477072,
      NULL,
      0,
      NULL,
      282,
      1.233230,
      0,
      0.153653,
      1.258268,
      1,
      1,
      0.166158,
      NULL,
      0.331287,
      3,
      1.903952,
      NULL,
      NULL,
      1.412988,
      NULL,
      1,
      1,
      3,
      NULL,
      1.461211,
      NULL,
      1.178085,
      NULL,
      0.783238,
      NULL,
      1.681362,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      7,
      NULL,
      2,
      0,
      0,
      10,
      3,
      0,
      1.332910,
      0.207418,
      NULL,
      1.358981,
      1.379353,
      1,
      1.064055,
      1,
      1,
      0,
      1.077909,
      NULL,
      1.967342,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.790606,
      1,
      0.586571,
      1,
      1,
      2,
      2,
      0,
      0,
      NULL,
      3.179304,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.666730,
      2,
      3,
      3.466554,
      2,
      2.714959,
      1.245188,
      0.620922,
      0.088448,
      0,
      0,
      NULL,
      0.609285,
      2.256882,
      1,
      0.579781,
      1,
      0.218576,
      NULL,
      3.786534,
      1,
      1.977191,
      1,
      0,
      NULL,
      2.057912,
      94.257145,
      0.117270,
      NULL,
      0.187843,
      1,
      1,
      3,
      NULL,
      0.952804,
      NULL,
      1.287288,
      NULL,
      1.546943,
      NULL,
      3,
      NULL,
      0.200487,
      NULL,
      1.697012,
      NULL,
      0.760496,
      NULL,
      1.962249,
      NULL,
      2,
      NULL,
      1.355400,
      NULL,
      0.289107,
      NULL,
      197,
      3.348817,
      NULL,
      1.476342,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      2,
      0.494923,
      NULL,
      NULL,
      67.430888,
      59,
      5,
      0.248428,
      3,
      '00303',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '40423',
      NULL,
      '');
commit;
end;
/


