set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '4030230',
      1.957551,
      1,
      NULL,
      0,
      '4010',
      NULL,
      1,
      NULL,
      NULL,
      ' 0-12-2000',
      31,
      NULL,
      4,
      0,
      0,
      ' 4-21-1996',
      NULL,
      2,
      339,
      NULL,
      1,
      NULL,
      ' 4-16-1993',
      NULL,
      0.749453,
      NULL,
      NULL,
      NULL,
      0,
      1.350395,
      1,
      2.880736,
      NULL,
      NULL,
      NULL,
      9.011452,
      2,
      21,
      NULL,
      1,
      15.832648,
      5,
      2,
      1.666921,
      2.633439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      1,
      3.205185,
      4,
      0,
      4,
      4,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.630951,
      1,
      NULL,
      1,
      NULL,
      1.386367,
      0,
      2,
      NULL,
      2,
      2,
      4,
      5,
      0,
      1,
      NULL,
      1.563009,
      2.293828,
      1.720893,
      0.727102,
      3.316879,
      NULL,
      1,
      1,
      0.684536,
      NULL,
      NULL,
      0.808641,
      0.156973,
      0,
      1,
      1,
      5,
      NULL,
      1,
      0,
      2,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      0,
      5,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      4,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      4,
      3,
      0,
      1,
      2,
      4,
      NULL,
      4,
      7,
      1,
      NULL,
      22,
      ' 9- 1-1998',
      28.141916,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      1,
      7,
      NULL,
      3,
      3,
      ' 7-26-1999',
      2,
      ' 1-17-1987',
      0.828640,
      1.393964,
      1,
      NULL,
      3,
      NULL,
      2.037384,
      2,
      0,
      5,
      0,
      1,
      3.432166,
      NULL,
      1794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513287,
      0,
      3,
      NULL,
      1.074162,
      0,
      NULL,
      NULL,
      NULL,
      3.336348,
      0.667281,
      1,
      2,
      NULL,
      1,
      1.188829,
      NULL,
      3.500218,
      ' 5- 2-1999',
      5.556753,
      1.564292,
      NULL,
      1,
      3.964114,
      2,
      1.012965,
      0,
      1,
      0.904193,
      0.441973,
      2.828701,
      113.339838,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.781949,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      3,
      0,
      0,
      NULL,
      2,
      0.116401,
      1.658614,
      1.537336,
      1.019218,
      1.303966,
      0.426420,
      NULL,
      NULL,
      0,
      1.992923,
      NULL,
      0.783408,
      1,
      0,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815393,
      NULL,
      18,
      NULL,
      102,
      2,
      0.389133,
      5.382308,
      '13011',
      '11140',
      '',
      0.157431,
      NULL,
      '',
      '',
      2,
      NULL,
      '',
      '',
      0.496345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.465685,
      NULL,
      NULL,
      1.432781,
      NULL,
      NULL,
      1.465556,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.166898,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331538,
      NULL,
      747,
      0,
      1.661809,
      1,
      0.238604,
      NULL,
      1.424396,
      1,
      NULL,
      0.218570,
      NULL,
      NULL,
      NULL,
      0.982642,
      0.046810,
      0.172376,
      NULL,
      NULL,
      2.703174,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.834125,
      NULL,
      0.145061,
      NULL,
      0.317198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3,
      6.472210,
      3.609699,
      5.081562,
      1.125668,
      2,
      10.877756,
      2.505646,
      1.561232,
      3,
      1.847259,
      1,
      1,
      0.456548,
      0.960727,
      3,
      NULL,
      NULL,
      11.146669,
      NULL,
      NULL,
      12,
      0,
      2.539866,
      1.086737,
      2,
      0,
      1.132882,
      1.753818,
      1,
      1.767805,
      0.132037,
      3.501624,
      NULL,
      0.661872,
      NULL,
      NULL,
      2.096695,
      1,
      NULL,
      0,
      0.833701,
      1.902060,
      2,
      NULL,
      1,
      0.986392,
      2,
      2.245851,
      1.814192,
      NULL,
      3.751840,
      0.752194,
      NULL,
      3,
      10.429177,
      15.909501,
      1,
      3,
      NULL,
      1,
      7,
      0,
      2.370662,
      3.615495,
      NULL,
      1,
      1.644739,
      1.789773,
      NULL,
      3.742869,
      1,
      12,
      NULL,
      0,
      2.026858,
      3.027110,
      2,
      1,
      3.514191,
      3,
      3,
      0,
      1,
      0,
      0.268982,
      3,
      0.672166,
      NULL,
      2,
      1,
      3,
      1.320437,
      2.799599,
      1,
      3,
      NULL,
      NULL,
      1.103430,
      0,
      NULL,
      2,
      197,
      1.067229,
      NULL,
      1,
      NULL,
      0.704532,
      1,
      0,
      0,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      '03143',
      NULL,
      '',
      1.913765,
      '',
      '',
      NULL,
      0.881466,
      '03213',
      '',
      '');
commit;
end;
/


