set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8623016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1214403',
      2,
      NULL,
      2,
      2,
      '1234',
      0,
      NULL,
      NULL,
      NULL,
      ' 7-15-1975',
      28.433447,
      NULL,
      4,
      2,
      0.899668,
      '11-22-1975',
      36,
      NULL,
      1301.863450,
      NULL,
      3,
      ' 4-11-1992',
      NULL,
      ' 7-19-1986',
      2,
      NULL,
      1.272704,
      1.586639,
      0,
      2.345985,
      NULL,
      0.062960,
      NULL,
      NULL,
      NULL,
      3.477900,
      3,
      75,
      27,
      4,
      23,
      NULL,
      3,
      7,
      1.516477,
      1,
      1,
      0.512848,
      1,
      0.886105,
      0.459693,
      1,
      0,
      1.225191,
      0.843877,
      1,
      1,
      2,
      1.616574,
      2,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.257456,
      0.802477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.869754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1,
      1,
      3,
      4,
      4,
      0,
      5,
      4,
      NULL,
      4,
      5,
      0,
      5,
      3,
      NULL,
      0,
      1,
      NULL,
      2,
      ' 8-12-1980',
      846,
      NULL,
      438,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273242,
      1,
      NULL,
      0.351001,
      NULL,
      1.593447,
      0.799254,
      NULL,
      NULL,
      NULL,
      1.244508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.560091,
      1.229039,
      NULL,
      NULL,
      1.311049,
      0.903470,
      NULL,
      21.303124,
      NULL,
      0.155525,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      2,
      3,
      5,
      NULL,
      1,
      1.574155,
      NULL,
      NULL,
      1,
      1,
      1.679219,
      0,
      0.539772,
      0,
      0.686485,
      NULL,
      1,
      NULL,
      15.561231,
      NULL,
      1.486069,
      9,
      9,
      NULL,
      NULL,
      4.003795,
      7,
      NULL,
      3,
      5,
      NULL,
      2,
      2.452105,
      71.021485,
      0,
      3.173430,
      NULL,
      75,
      37,
      52,
      5,
      0.143008,
      1.963800,
      '10423',
      '',
      '',
      1.525739,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.079482,
      13,
      NULL,
      NULL,
      NULL,
      18,
      11.777679,
      2.979694,
      0,
      3,
      2,
      1,
      3,
      3.791643,
      1,
      1.323310,
      3.580053,
      0,
      1.604084,
      2.507380,
      2.807072,
      0.911983,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2.492998,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.451402,
      NULL,
      1,
      2.930784,
      2,
      1.922602,
      1.330642,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.700902,
      2,
      3.123131,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.055812,
      NULL,
      NULL,
      NULL,
      3,
      3.663623,
      2.825181,
      1.858756,
      NULL,
      3,
      0.007703,
      NULL,
      0.523925,
      2.717004,
      1.819303,
      NULL,
      NULL,
      NULL,
      3,
      2.060645,
      2,
      2.389554,
      0,
      2,
      NULL,
      2,
      1,
      1,
      2.290308,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.489331,
      3.295757,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.412703,
      NULL,
      NULL,
      NULL,
      0.550108,
      3,
      0.354028,
      2.380884,
      3,
      2.295541,
      NULL,
      3,
      NULL,
      1.798256,
      NULL,
      NULL,
      1.373598,
      9,
      NULL,
      NULL,
      3,
      0,
      3.733438,
      NULL,
      NULL,
      6,
      2.901089,
      1,
      1,
      NULL,
      NULL,
      1.989875,
      NULL,
      NULL,
      1.870411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.292035,
      NULL,
      NULL,
      NULL,
      0,
      1.993215,
      2.707255,
      3,
      0,
      1.708947,
      3.930082,
      0,
      2,
      1,
      NULL,
      0.331482,
      NULL,
      NULL,
      NULL,
      2.332940,
      0.738070,
      2.630012,
      NULL,
      3,
      2.592495,
      NULL,
      1.649610,
      9.485121,
      10.477115,
      3,
      1,
      3,
      3,
      0,
      1.722435,
      NULL,
      2.159605,
      NULL,
      1.933716,
      10,
      NULL,
      NULL,
      3,
      2.228774,
      NULL,
      2,
      2.982531,
      1.732415,
      1,
      NULL,
      NULL,
      1,
      0.093220,
      0,
      0,
      0.126672,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.330431,
      NULL,
      NULL,
      0.084473,
      NULL,
      NULL,
      9.764239,
      NULL,
      NULL,
      1,
      1.807352,
      1,
      NULL,
      0.882119,
      1.827424,
      0.549979,
      NULL,
      NULL,
      3.316898,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.215089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      167.961570,
      56.915351,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.546839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.783422,
      NULL,
      1.414149,
      4544,
      231,
      0,
      1,
      1,
      0,
      0,
      1.399723,
      1,
      NULL,
      NULL,
      1.017985,
      0,
      0.492292,
      0,
      0.388222,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.024998,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581900,
      0.626485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847201,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511822,
      0.438495,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.752248,
      NULL,
      0,
      1.194437,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645091,
      3,
      NULL,
      18,
      9.455219,
      0.338702,
      7,
      16.492028,
      2,
      12,
      19,
      0.701036,
      5.808038,
      6,
      NULL,
      8,
      4.140526,
      0.681487,
      NULL,
      19,
      NULL,
      6,
      2.935753,
      1.435394,
      11,
      NULL,
      0,
      15.914297,
      1,
      1.304992,
      13.202013,
      4.395177,
      1,
      5,
      NULL,
      NULL,
      0,
      3.873059,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.372440,
      1.159457,
      1.605278,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      53.800033,
      75.384895,
      NULL,
      NULL,
      2,
      '10400',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


