set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8928591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2214212',
      0.444866,
      0,
      NULL,
      2,
      '1203',
      NULL,
      0.443497,
      4,
      18,
      '11- 9-1996',
      NULL,
      NULL,
      4,
      NULL,
      0.236165,
      ' 1- 4-1989',
      NULL,
      0,
      123.110952,
      36,
      NULL,
      NULL,
      NULL,
      ' 5-14-1991',
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      1.865960,
      1.819856,
      4.546257,
      NULL,
      NULL,
      2,
      14.754579,
      6.111882,
      0,
      4.164384,
      4,
      4,
      8.848002,
      NULL,
      1,
      0,
      NULL,
      1,
      0.732797,
      0,
      NULL,
      2,
      1.616244,
      0,
      0,
      4,
      7,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.505293,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      1.396218,
      1,
      NULL,
      NULL,
      1.798401,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      1,
      5,
      2,
      0,
      2,
      5,
      5,
      5,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      5,
      5,
      1,
      0,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      1,
      0,
      NULL,
      3,
      NULL,
      4,
      5,
      NULL,
      3,
      NULL,
      NULL,
      3.840018,
      NULL,
      154.072232,
      NULL,
      1291.124980,
      2.080115,
      2,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.219249,
      1,
      1,
      NULL,
      1.909012,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.219982,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053262,
      NULL,
      1.014397,
      0,
      0,
      0.854623,
      NULL,
      NULL,
      0.067158,
      NULL,
      NULL,
      NULL,
      0,
      1.552860,
      NULL,
      1,
      3,
      0,
      1,
      2,
      3,
      2,
      3,
      2,
      3,
      0.760554,
      NULL,
      NULL,
      NULL,
      0,
      1.893001,
      1.249030,
      NULL,
      0,
      1.735177,
      1,
      0.719831,
      0.357248,
      1.249771,
      0,
      1,
      1.330324,
      NULL,
      1,
      1,
      2.790428,
      4,
      NULL,
      3.684884,
      3,
      2.383240,
      1,
      7,
      2,
      0.884121,
      0.397271,
      63,
      1,
      1.984759,
      12,
      NULL,
      NULL,
      NULL,
      4,
      0.183323,
      NULL,
      '10420',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      1,
      473,
      30.049851,
      2.782930,
      NULL,
      NULL,
      18.550370,
      5,
      3.231742,
      2,
      1.442573,
      0.612717,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.804088,
      NULL,
      0,
      1,
      NULL,
      1,
      0.161287,
      1,
      0,
      2,
      1.639366,
      3,
      0.907283,
      7,
      5.396824,
      NULL,
      9,
      1,
      2,
      16,
      0.432054,
      NULL,
      19,
      10,
      5.760114,
      NULL,
      NULL,
      2,
      NULL,
      6.712554,
      0,
      0.155534,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161355,
      3.031278,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.829295,
      1.850858,
      0,
      NULL,
      0.143467,
      0.430171,
      1.572160,
      1.706842,
      1.582148,
      NULL,
      NULL,
      1.946787,
      NULL,
      0,
      0,
      1,
      3.320956,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.013357,
      1,
      3,
      7,
      4,
      3.337857,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.036861,
      1,
      1,
      2.947116,
      NULL,
      NULL,
      0,
      2.863744,
      3,
      NULL,
      NULL,
      11.316941,
      NULL,
      0.360286,
      1.999829,
      NULL,
      9.284774,
      10.492712,
      1.999473,
      1.451080,
      NULL,
      NULL,
      NULL,
      3.975622,
      2.093420,
      0.483587,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.032395,
      NULL,
      NULL,
      1.319090,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.837852,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.906940,
      3.836314,
      3,
      NULL,
      2,
      NULL,
      7.833110,
      1,
      4,
      1,
      0,
      0.337993,
      1,
      2,
      NULL,
      3.524677,
      2,
      0,
      3,
      14,
      0.496289,
      NULL,
      7,
      3,
      NULL,
      7.937088,
      1,
      1.858489,
      3.110138,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6,
      2,
      4,
      3,
      NULL,
      NULL,
      3.481839,
      0.355892,
      NULL,
      0,
      0,
      0,
      1.397309,
      NULL,
      NULL,
      0.577239,
      1.993239,
      NULL,
      NULL,
      0.187905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.287738,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.136337,
      0.384956,
      3,
      NULL,
      3,
      0.575359,
      3,
      3,
      NULL,
      NULL,
      3.823460,
      5,
      4.339958,
      NULL,
      1,
      3.098416,
      2,
      NULL,
      0.152458,
      0.698643,
      1.785101,
      NULL,
      NULL,
      0.273391,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.348149,
      NULL,
      2.555330,
      NULL,
      3.232948,
      NULL,
      2.152087,
      NULL,
      0.886400,
      3.993706,
      7,
      NULL,
      14.626812,
      8,
      NULL,
      NULL,
      0.256798,
      13,
      12,
      NULL,
      1,
      0,
      1.810203,
      NULL,
      2,
      1,
      1.812024,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      3.513983,
      14,
      NULL,
      NULL,
      18.628079,
      17.998875,
      NULL,
      2,
      NULL,
      14,
      NULL,
      0.309967,
      NULL,
      3.233153,
      NULL,
      3.272618,
      0.716020,
      0.214718,
      NULL,
      NULL,
      NULL,
      4.266800,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      6,
      3.505700,
      156.607553,
      NULL,
      NULL,
      0.975300,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.730359,
      2,
      1,
      1,
      NULL,
      NULL,
      965.138140,
      8,
      0,
      0.109389,
      1,
      NULL,
      0,
      0.439573,
      1,
      0.784313,
      1.546671,
      0.932011,
      1.018258,
      1,
      1.793797,
      0.297445,
      0.806743,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      8,
      0.944038,
      2.138654,
      0,
      2,
      NULL,
      1,
      0.001132,
      0,
      0.481308,
      1,
      NULL,
      0.400959,
      NULL,
      NULL,
      1,
      18,
      NULL,
      1,
      NULL,
      NULL,
      1.215896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.737850,
      NULL,
      NULL,
      0,
      5.947112,
      NULL,
      1,
      NULL,
      NULL,
      1.385892,
      0.226031,
      NULL,
      1.543906,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.625989,
      NULL,
      4,
      2,
      1,
      2,
      1,
      1,
      67.549017,
      69.148045,
      NULL,
      0.015051,
      3,
      '42002',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


