set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      3.218452,
      NULL,
      0.806807,
      2,
      3,
      NULL,
      2.676109,
      '421',
      '20320143',
      63.302574,
      26.197326,
      '4442021',
      0.304127,
      0.317026,
      NULL,
      NULL,
      '3203',
      2,
      1.932034,
      NULL,
      NULL,
      ' 0-22-1988',
      85.876938,
      137.299339,
      NULL,
      0,
      3,
      ' 7- 4-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 1-13-1980',
      '10-23-1977',
      NULL,
      2,
      1.734021,
      1,
      2.393792,
      1.310219,
      3.800648,
      5,
      NULL,
      0.062812,
      5,
      0,
      17.406692,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.758756,
      1,
      0,
      NULL,
      1.118071,
      3.069475,
      NULL,
      1.509355,
      NULL,
      1.411870,
      NULL,
      0,
      2,
      0,
      0.478458,
      0,
      0,
      1,
      0,
      2,
      0,
      4,
      4,
      5,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      0,
      1,
      1.285316,
      NULL,
      NULL,
      0.615176,
      NULL,
      NULL,
      3,
      3,
      2.336337,
      2.338272,
      1.848770,
      0,
      0,
      0,
      1,
      2.758362,
      0,
      0.903841,
      2,
      3,
      0.799613,
      0,
      1,
      2,
      2,
      1,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      0.437245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      0,
      4,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.136416,
      NULL,
      1.109790,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      2,
      5,
      0,
      5,
      1,
      2,
      0,
      3,
      0,
      1,
      0,
      4,
      3,
      1,
      NULL,
      5,
      NULL,
      2,
      NULL,
      2,
      ' 8-14-1993',
      8.156527,
      ' 9-29-1994',
      37,
      1.888598,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      0.859879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      3.252275,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.018035,
      3.578212,
      NULL,
      0,
      0.580784,
      NULL,
      7,
      NULL,
      NULL,
      1.747766,
      2.711452,
      0.943743,
      NULL,
      NULL,
      NULL,
      0,
      4.729838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709369,
      NULL,
      1,
      1.994674,
      1,
      1.845800,
      1.781044,
      0.913492,
      0,
      0.144167,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      2,
      3,
      NULL,
      1,
      2,
      1,
      3,
      0.095121,
      0,
      0.760173,
      1,
      0.414079,
      2.118140,
      NULL,
      1.467930,
      NULL,
      1.884596,
      0.725191,
      1,
      0,
      NULL,
      3,
      1,
      3,
      0.910065,
      4,
      NULL,
      2,
      8,
      0,
      NULL,
      5,
      0.421993,
      0.701126,
      3,
      3,
      3,
      29,
      NULL,
      0.809079,
      31,
      NULL,
      33,
      19,
      NULL,
      4.299957,
      1.308443,
      '20131',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.634694,
      '',
      '',
      '',
      NULL,
      NULL,
      68,
      6.869588,
      1,
      24,
      1,
      3.750272,
      2,
      3.105845,
      NULL,
      0,
      0.701160,
      NULL,
      NULL,
      0.394464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.971949,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282750,
      0.444589,
      NULL,
      NULL,
      2.940303,
      1.834055,
      NULL,
      0.906503,
      NULL,
      NULL,
      3,
      NULL,
      0.298192,
      1.801836,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.785973,
      NULL,
      NULL,
      NULL,
      0.580978,
      0,
      NULL,
      0,
      3.009899,
      1.178718,
      2,
      0.370333,
      3,
      3,
      1.358005,
      0.831805,
      2,
      0.922880,
      0,
      1,
      0.472583,
      1,
      1,
      3.329314,
      0.464260,
      NULL,
      0,
      0,
      1.126361,
      3.629617,
      0,
      0,
      3,
      0.459834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.257139,
      1.683164,
      4.632777,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.369091,
      0,
      1,
      0,
      NULL,
      NULL,
      1.760466,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.965404,
      NULL,
      NULL,
      3.154596,
      NULL,
      NULL,
      3,
      NULL,
      0.872443,
      0,
      NULL,
      NULL,
      2,
      0.644157,
      NULL,
      0.381747,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.192449,
      NULL,
      NULL,
      1.370893,
      NULL,
      NULL,
      0.588153,
      NULL,
      NULL,
      1.428204,
      NULL,
      NULL,
      6.667695,
      1.105552,
      1,
      0.011027,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.346540,
      0,
      1,
      3,
      1.936164,
      0,
      8,
      1.856689,
      0,
      2.790381,
      0,
      1,
      1.875241,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.868487,
      7,
      1.937088,
      3.978315,
      6,
      1,
      0.748960,
      1.353052,
      NULL,
      NULL,
      NULL,
      1.873243,
      0,
      0,
      1.087697,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.253767,
      NULL,
      NULL,
      0.322844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.764735,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0.205052,
      3.912576,
      3.947517,
      NULL,
      NULL,
      2.054993,
      3,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.744494,
      1.291401,
      NULL,
      0.838169,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      1.264009,
      2.775573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589280,
      1.649745,
      NULL,
      NULL,
      1.516393,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.739078,
      NULL,
      3.610820,
      NULL,
      0,
      NULL,
      2.043500,
      1.610645,
      0.584715,
      NULL,
      1,
      1.329926,
      NULL,
      NULL,
      1,
      0.906901,
      1,
      NULL,
      1,
      1.273375,
      1.715534,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.505006,
      1.492798,
      NULL,
      NULL,
      NULL,
      3.846890,
      6.450316,
      5.122339,
      NULL,
      5.156061,
      3.162130,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.912303,
      8,
      1,
      64.568629,
      43.411974,
      1,
      0,
      1.127913,
      2.383780,
      0.136529,
      0.310779,
      0,
      2,
      1.111719,
      NULL,
      NULL,
      1.619389,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.745839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325937,
      NULL,
      0.678131,
      NULL,
      62,
      NULL,
      2,
      0.959600,
      4,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.151316,
      NULL,
      0.206103,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.293783,
      NULL,
      0,
      NULL,
      0.626778,
      NULL,
      0.977760,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.502855,
      0,
      0,
      3,
      1.676341,
      1.044826,
      1,
      0,
      0,
      1,
      NULL,
      3,
      0,
      3,
      0,
      0.861218,
      NULL,
      1,
      1.789359,
      2,
      1,
      1,
      1.799154,
      NULL,
      1.857394,
      NULL,
      0.339634,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.436742,
      1.834419,
      0.627054,
      1,
      1.758921,
      NULL,
      NULL,
      0.705672,
      1.487925,
      0.691670,
      NULL,
      1.547863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.761645,
      1.279762,
      0,
      0,
      4,
      3,
      3,
      0.056408,
      NULL,
      NULL,
      5,
      87.936679,
      3,
      4.210193,
      0.619023,
      NULL,
      '02301',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


