set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '23',
      29,
      29,
      NULL,
      2,
      0,
      0,
      2,
      NULL,
      4.882461,
      0,
      NULL,
      NULL,
      ' 8-16-1988',
      150.769681,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10-26-2001',
      '11- 7-1982',
      ' 2-10-1999',
      2,
      2.490289,
      0,
      NULL,
      1.644041,
      NULL,
      0,
      1.626601,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      1,
      1,
      4,
      3,
      0,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      0,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.917070,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0.504817,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      5,
      1,
      1,
      4,
      0,
      0,
      2,
      0,
      4,
      5,
      1,
      3,
      0,
      3,
      NULL,
      3,
      2,
      1,
      NULL,
      0,
      NULL,
      ' 4- 8-1988',
      62,
      ' 8-29-1974',
      4,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3.022494,
      4.714058,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.497754,
      4.292233,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.036538,
      1.849704,
      1.311702,
      NULL,
      1.886435,
      1.284630,
      NULL,
      1.152539,
      18.604703,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.099881,
      3.754316,
      3,
      0,
      NULL,
      2,
      3,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      3,
      1,
      3,
      3,
      NULL,
      2,
      3.501438,
      0.477415,
      1,
      1,
      1,
      1.026910,
      NULL,
      1.312560,
      1,
      NULL,
      1,
      0.499385,
      10.905223,
      3,
      0,
      NULL,
      4.111282,
      1,
      2,
      0.866503,
      6,
      NULL,
      3,
      1,
      13,
      2,
      3.223765,
      NULL,
      NULL,
      29,
      54.020575,
      5,
      5,
      0.816226,
      '20234',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.554176,
      '',
      '',
      '',
      NULL,
      60.874638,
      280,
      NULL,
      2,
      NULL,
      2.591423,
      NULL,
      NULL,
      0.487502,
      NULL,
      1,
      0.135024,
      NULL,
      NULL,
      1.292761,
      1.575446,
      0.007573,
      2,
      2,
      2.847977,
      1,
      NULL,
      NULL,
      1.674269,
      NULL,
      NULL,
      3.307611,
      0.938781,
      1,
      2,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.105707,
      NULL,
      NULL,
      NULL,
      1,
      3.353734,
      1,
      1.433781,
      NULL,
      NULL,
      NULL,
      0.192235,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406129,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.256813,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845542,
      NULL,
      NULL,
      0.591547,
      0.218886,
      NULL,
      0,
      NULL,
      NULL,
      0.583977,
      NULL,
      NULL,
      0,
      0,
      0.376742,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.770528,
      NULL,
      NULL,
      1.693900,
      NULL,
      NULL,
      1.001761,
      NULL,
      NULL,
      1.071528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373134,
      NULL,
      NULL,
      0.587760,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.446217,
      0.698046,
      3.889796,
      2,
      1,
      1.923743,
      1.865335,
      2.771279,
      1,
      3,
      4.632927,
      NULL,
      2,
      2.330542,
      0.945099,
      0,
      1,
      1.316402,
      3.297555,
      NULL,
      2.781318,
      1,
      3.095497,
      3,
      1.944646,
      2.701472,
      2,
      2.969784,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      1.629518,
      1,
      0,
      1.811946,
      NULL,
      NULL,
      0.339172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981651,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.636912,
      0.607499,
      NULL,
      3.195144,
      NULL,
      NULL,
      2.673567,
      1.560652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.473185,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.358407,
      NULL,
      NULL,
      NULL,
      NULL,
      3.291261,
      NULL,
      NULL,
      0.906681,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.315807,
      NULL,
      NULL,
      0.133545,
      NULL,
      NULL,
      1.343201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744423,
      NULL,
      1,
      342.335667,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.292965,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.010627,
      1.682663,
      NULL,
      1,
      NULL,
      0.082658,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      50,
      NULL,
      2.384774,
      31.506269,
      24.762171,
      0,
      0.149218,
      0,
      NULL,
      1,
      NULL,
      0.510269,
      NULL,
      0,
      NULL,
      0.618169,
      NULL,
      1.948393,
      NULL,
      0.968955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.490566,
      NULL,
      0.153795,
      NULL,
      NULL,
      NULL,
      1.527105,
      3,
      0.575597,
      1.249595,
      NULL,
      0.537428,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.998193,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.226154,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.559989,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.445850,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065542,
      NULL,
      NULL,
      NULL,
      0.408973,
      NULL,
      NULL,
      0,
      0.786967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.484002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707891,
      NULL,
      NULL,
      0.777193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.026683,
      NULL,
      1.692766,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.142408,
      NULL,
      1.170108,
      0.090153,
      3,
      0,
      3,
      2,
      2.397871,
      NULL,
      NULL,
      1,
      1,
      0.880278,
      NULL,
      1,
      0,
      1,
      0,
      0.402113,
      0.044914,
      1.330206,
      0.171611,
      0,
      0.064095,
      1,
      1.001237,
      3,
      NULL,
      0.891003,
      0.030775,
      1.045134,
      2.188701,
      NULL,
      NULL,
      0,
      0,
      1.201697,
      1.980530,
      0.067068,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      0,
      NULL,
      0.712719,
      NULL,
      0.219048,
      0.802555,
      NULL,
      0,
      NULL,
      1.548754,
      2,
      0,
      3.150628,
      1,
      1.835950,
      1.427667,
      0.588986,
      0,
      0,
      0.242681,
      1,
      1,
      1,
      4.818038,
      0.069980,
      1.928983,
      0.961232,
      0.460255,
      1.193859,
      NULL,
      1.359497,
      1.970897,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      88,
      NULL,
      0,
      4,
      3.509133,
      '43312',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


